// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb

using System.Runtime.CompilerServices;

namespace Prologin {
// Erreurs possibles
	public enum Erreur {
		OK, // <- L'action a été exécutée avec succès
		PA_INSUFFISANTS, // <- Vous ne possédez pas assez de points d'action pour cette action.
		AUCUN_PORTAIL, // <- La position spécifiée n'est pas un portail.
		POSITION_INVALIDE, // <- La position spécifiée est hors de la carte.
		POSITION_ELOIGNEE, // <- La destination est trop éloignée.
		PORTAIL_AMI, // <- Le portail vous appartient.
		PORTAIL_NEUTRE, // <- Le portail est neutre.
		PORTAIL_ENNEMI, // <- Le portail appartient à votre adversaire.
		LIEN_INTERSECTION, // <- Le lien croise un lien existant.
		LIEN_CHAMP, // <- Le lien se trouve dans un champ existant.
		LIEN_DEGENERE, // <- Les deux extrémités du lien coïncident.
		LIMITE_BOUCLIERS, // <- Ce portail est équipé du nombre maximal de boucliers.
	}

// Position sur la carte, donnée par deux coordonnées.
	class Position {
		public Position() {
		}
		public int X; // <- Coordonnée en X
		public int Y; // <- Coordonnée en Y
	}

// Représente un lien existant.
	class Lien {
		public Lien() {
		}
		public Position Extr1; // <- Première extrémité du lien.
		public Position Extr2; // <- Seconde extrémité du lien.
		public int JoueurL; // <- Joueur possédant ce lien.
	}

// Représente un champ de contrôle existant.
	class Champ {
		public Champ() {
		}
		public Position Som1; // <- Premier sommet du champ.
		public Position Som2; // <- Deuxième sommet du champ.
		public Position Som3; // <- Troisième sommet du champ.
		public int JoueurC; // <- Joueur possédant ce champ.
	}

	class Api {
// Taille du terrain (longueur et largeur).
		public const int TAILLE_TERRAIN = 30;

// Nombre de tours à jouer avant la fin de la partie.
		public const int NB_TOURS = 100;

// Nombre de points de déplacement par tour (avant utilisation du turbo).
		public const int NB_POINTS_DEPLACEMENT = 6;

// Nombre de points d'action par tour.
		public const int NB_POINTS_ACTION = 42;

// Nombre de points d'action que coûte la capture d'un portail.
		public const int COUT_CAPTURE = 3;

// Nombre de points d'action que coûte la création d'un lien.
		public const int COUT_LIEN = 2;

// Nombre de points d'action que coûte la neutralisation d'un portail de base.
		public const int COUT_NEUTRALISATION = 10;

// Nombre de points d'action supplémentaires que coûte la neutralisation pour chaque bouclier présent.
		public const int COUT_NEUTRALISATION_BOUCLIER = 5;

// Nombre de points d'action que coûte la mise en place d'un bouclier sur un portail sans bouclier.
		public const int COUT_BOUCLIER = 3;

// Nombre de points d'action que coûte l'utilisation d'un turbo.
		public const int COUT_TURBO = 6;

// Nombre maximum de boucliers sur un même portail.
		public const int MAX_BOUCLIERS = 6;

// Nombre de points que rapporte la capture d'un portail.
		public const int POINTS_CAPTURE = 10;

// Constante de proportionnalité reliant l'aire d'un champ au nombre de points qu'il rapporte par tour.
		public const int POINTS_CHAMP = 2;

// Déplace votre agent sur la case passée en argument.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Deplacer(Position dest);

// Utilise un turbo.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur UtiliserTurbo();

// Capture le portail où est positionné votre agent.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Capturer();

// Crée un lien entre le portail où se trouve votre agent et le portail de destination donné en argument.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Lier(Position portail);

// Neutralise le portail où se trouve votre agent.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Neutraliser();

// Ajoute un bouclier au portail sur lequel se trouve votre agent.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur AjouterBouclier();

// Renvoie la liste de tous les liens présents.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Lien[] ListeLiens();

// Renvoie la liste de tous les champs de contrôle.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Champ[] ListeChamps();

// Renvoie la liste de tous les portails de la carte.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] ListePortails();

// Renvoie la liste de tous les liens existants qui croisent un segment, entravant la création d'un lien.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Lien[] LiensBloquants(Position ext1, Position ext2);

// Prend les positions de deux portails, et renvoie un booléen indiquant s'ils sont reliés. Le résultat est `false` lorsque l'une des deux positions ne repère pas un portail.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool LienExiste(Position ext1, Position ext2);

// Renvoie un booléen indiquant si les 3 positions repèrent bien 3 portails tous reliés entre eux.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool ChampExiste(Position som1, Position som2, Position som3);

// Renvoie un booléen indiquant si la case ``pos`` se trouve dans un champ.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool CaseDansChamp(Position pos);

// Renvoie la liste des champs à l'intérieur desquels ``pos`` se trouve. Si la case est un portail, le résultat de ``case_champs`` sera disjoint de celui de ``champs_incidents_portail``.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Champ[] CaseChamps(Position pos);

// Renvoie le numéro du joueur correspondant au portail donné, -1 si le portail est neutre, -2 si la case n'est pas un portail. Vous pouvez utiliser cette fonction pour vérifier qu'une case donnée est bien un portail.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int PortailJoueur(Position portail);

// Renvoie le nombre de boucliers présents sur un portail (-2 si la case n'est pas un portail).
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int PortailBoucliers(Position portail);

// Renvoie la liste de tous les liens dont le portail donné est une extrémité.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Lien[] LiensIncidentsPortail(Position portail);

// Renvoie la liste de tous les champs dont le portail donné est un sommet.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Champ[] ChampsIncidentsPortail(Position portail);

// Renvoie la liste de tous les champs dont le lien donné est un côté. Si le segment n'est pas un lien présent, renvoie la liste de tous les champs que la création du lien ferait apparaître.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Champ[] ChampsIncidentsSegment(Position ext1, Position ext2);

// Renvoie la liste des portails capturés par votre adversaire au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistPortailsCaptures();

// Renvoie la liste des portails neutralisés par votre adversaire au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistPortailsNeutralises();

// Renvoie la liste des liens créés par votre adversaire au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Lien[] HistLiensCrees();

// Renvoie la liste des champs créés par votre adversaire au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Champ[] HistChampsCrees();

// Renvoie la liste des positions où votre adversaire a ajouté des boucliers au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistBoucliersAjoutes();

// Renvoie la distance de Manhattan entre deux positions.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Distance(Position pos1, Position pos2);

// Renvoie le nombre de points que rapporte(rait) chaque tour un champ existant ou hypothétique.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int ScoreTriangle(Position som1, Position som2, Position som3);

// Indique si deux segments se croisent. Cette fonction correspond exactement à la condition d'interférence entre liens, c'est-à-dire qu'elle renvoie ``false`` si l'intersection est une extrémité des deux segments.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool IntersectionSegments(Position a1, Position a2, Position b1, Position b2);

// Indique si un point se trouve à l'intérieur d'un triangle. Le critère coïncide avec celui de ``case_champs``.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool PointDansTriangle(Position p, Position som1, Position som2, Position som3);

// Renvoie votre numéro de joueur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Moi();

// Renvoie le numéro de votre adversaire.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Adversaire();

// Indique la position de l'agent du joueur désigné par le numéro ``id_joueur``.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position PositionAgent(int id_joueur);

// Indique votre nombre de points d'actions restants pour ce tour-ci.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int PointsAction();

// Indique votre nombre de points de déplacement restants pour ce tour-ci.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int PointsDeplacement();

// Renvoie le score du joueur désigné par le numéro ``id_joueur``.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Score(int id_joueur);

// Renvoie le numéro du tour actuel.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int TourActuel();

// Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool Annuler();

// Affiche le contenu d'une valeur de type erreur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherErreur(Erreur v);

// Affiche le contenu d'une valeur de type position
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPosition(Position v);

// Affiche le contenu d'une valeur de type lien
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherLien(Lien v);

// Affiche le contenu d'une valeur de type champ
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherChamp(Champ v);

	}
}
