#include "prologin.h"

static struct {
    int x, y;
} d[4] = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

static direction to[4] = {HAUT, BAS, GAUCHE, DROITE};
static int from[] = {
    [HAUT]      = 0,
    [BAS]       = 1,
    [GAUCHE]    = 2,
    [DROITE]    = 3,
};


/*
 * TODO Agresser les nains adverses lorsqu'on passe à proximité ("")
 * TODO Miner les minerais lorsqu'on passe à proximité (en évitant le négatif)
 * TODO Synchroniser la richesse minimale d'agression globale et locale
 * TODO Si le score est trop faible trop longtemps, abandonner l'offensive
 * TODO Focus les nains adverses s'ils sont proches en mode go_dig()
 * 
 *
 * TODO Rétablir le drapeau rouge
 */

static inline int my_abs(int x) { return x >= 0 ? x : -x; }
static inline int manhattan(struct position a, struct position b) { return my_abs(a.ligne - b.ligne) + my_abs(a.colonne - b.colonne); }


/* Profondeur sous une position donnée */
static inline int depth(struct position p) {
    struct position t = position_taverne(adversaire());
    int d = 0;

    /* La taverne ennemie se comporte comme un trou noir qui tue instantanément */
    if (p.ligne == t.ligne && p.colonne == t.colonne)
        goto BLACK_HOLE; /* Oh ! un goto ! */
    p.ligne++;
    while (type_case(p) == LIBRE) /* && nain_sur_case(p) != adversaire()) */ {
        if (p.ligne == t.ligne && p.colonne == t.colonne)
            goto BLACK_HOLE;
        p.ligne++, d++;
    }
    return d;

BLACK_HOLE:
    return 0xfffffff;
}

static inline bool try_release(int i, int max_fall) {
    if (depth(info_nain(moi(), i).pos) <= max_fall) {
        erreur e = lacher(i);

        return e == OK || e == PAS_ACCROCHE;
    }
    return false;
}

static int past_up[NB_NAINS] = {0};

/*
 * Version améliorée de deplacer() pour automatiquement s'agripper et utiliser
 * la gravité pour gagner du temps.
 */
static inline erreur move(int i, direction dir, int next_down) {
    struct position p = info_nain(moi(), i).pos;

    p.ligne += d[from[dir]].x, p.colonne += d[from[dir]].y;
    try_release(i, 0);
    switch (dir) {
        case HAUT:
            agripper(i);
            break;
    case BAS:
            if (next_down >= 1)
                try_release(i, 3);
            break;
        case GAUCHE:
        case DROITE: {
            if (next_down <= 1 || depth(p) >= 4)
                agripper(i);
            /* XXX Tirage d'une corde par le dernier nain s'il a besoin de descendre ou monter beaucoup */
            if (i == NB_NAINS - 1 && (next_down > 5 || past_up[i] > 5 || depth(p) > 5))
                poser_corde(i, dir);
            break;
        }
        default:
            return DIRECTION_INVALIDE;
    }

    struct position t = position_taverne(adversaire());
    erreur e = OK;

    /* On évite de se suicider sur la taverne ennemie */
    if (p.ligne != t.ligne || p.colonne != t.colonne)
        e = deplacer(i, dir);
    agripper(i);

    if (e == OK) {
        if (dir == HAUT)
            past_up[i]++;
        else
            past_up[i] = 0;
    }
    return e;
}

/*
 * Fonction utile pour parcourir « correctement » un chemin donné
 */
static inline void walk(int i, struct direction_array path) {
    /*
     * TODO Placer des cordes s'il faut descendre beaucoup à un moment
     * TODO Implémenter l'autosélection d'un nain proche d'une corde à
     * qui il reste des PAs lorsque le nain courant est sur une corde pour
     * faire marcher la poulie
     */
    for (int k = 0; k < path.length; k++) {
        int next_down = 0;

        for (int l = k+1; l < path.length && path.datas[l] == BAS; l++)
            next_down++;

        struct nain n = info_nain(moi(), i);

        /* Automatiquement tabasser les ennemis faibles à proximité */
        /* TODO Tenir compte de la multiplicité des nains sur une case, et entre autres les valeurs négatives */
        int max_enemy = -1, max_wealth = -1;

        for (int j = 0; j < NB_NAINS; j++) {
            struct nain m = info_nain(adversaire(), j);

            if (m.butin < 0)
                continue;
            /* XXX À partir de combien de coups c'est intéressant */
            if (manhattan(n.pos, m.pos) <= 1 && (m.vie <= DEGAT_PIOCHE || m.butin > BUTIN_MAX * .5 && m.vie <= 2 * DEGAT_PIOCHE))
                for (int _ = 0; _ < 4; _++) {
                    struct position p = {.ligne = n.pos.ligne + d[_].x, .colonne = n.pos.colonne + d[_].y};

                    if (p.ligne == m.pos.ligne && p.colonne == m.pos.colonne && m.butin > max_wealth)
                        max_enemy = _, max_wealth = m.butin;
                }
        }

        if (max_enemy != -1)
            miner(i, to[max_enemy]);

        /* Si on ne parvient pas à avancer */
        if (move(i, path.datas[k], next_down) != OK && info_nain(moi(), i).pm > 0) {
            struct position p = info_nain(moi(), i).pos;

            p.ligne += d[from[path.datas[k]]].x, p.colonne += d[from[path.datas[k]]].y;
            /* Si on ne peut ni avancer ni casser l'obstacle, arrêter */
            if (nain_sur_case(p) != moi() && miner(i, path.datas[k]) == PA_INSUFFISANTS)
                break;
            move(i, path.datas[k], next_down);
        }

        /* Miner au cas où, pour économiser des PA au tour suivant */
        if (info_nain(moi(), i).pm <= 0 && k < path.length - 1) {
            int avant = 0;

            for (int j = 0; j < NB_NAINS; j++)
                avant += info_nain(moi(), j).vie;
            if (miner(i, path.datas[k+1]) == OK) {
                int apres = 0;

                for (int j = 0; j < NB_NAINS; j++)
                    apres += info_nain(moi(), j).vie;
                /* Si on s'est blessé dans notre confusion */
                if (apres != avant)
                    annuler();
            }
            break;
        }

        /* Miner des minerais à proximité s'il reste des PAs */
        int max_ore = -1, max_value = -1;

        for (int _ = 0; _ < 4; _++) {
            struct position p = {.ligne = n.pos.ligne + d[_].x, .colonne = n.pos.colonne + d[_].y};
            struct minerai m = info_minerai(p);

            if (m.rendement > max_value)
                max_ore = _, max_value = m.rendement;
        }

        if (max_ore >= 0)
            miner(i, to[max_ore]);
    }
}


/*
 * TODO Ma propre fonction shortest_path() avec un Dijkstra en O(N^2) parce
 * que fornique sa matriarche les files à priorité en C
 */


/*
 * ... et ceux qui creusent. Toi, tu creuses !
 *
 * TODO Récolter du minerai négatif pour tromper l'ennemi et lui
 * infliger des malus (en particulier si la carte n'a que du négatif)
 *
 * TODO Utiliser une sorte de knapsack pour trouver une courte liste
 * de minerais proches mais intéressants à ramasser, puis utiliser
 * le voyageur du commerce pour trouver un chemin passant par tous
 *
 * TODO Implémenter une stratégie à 2 (ou plus) nain, où le fameux knapsack
 * trouve 2 * K minerais et un minerai sur deux va pour chaque nain
 *
 *      e.g. : si on trouve XXXXXX dans « l'ordre de distance » (à définir)
 *
 *              alors on a  X X X   -> nain 1
 *                           x X X  -> nain 2
 *
 * TODO Envisager d'aller agresser s'il n'y a rien d'intéressant à faire, ou
 * si le problème est trop symétrique
 */
static inline void go_dig(int i) {
    struct nain n = info_nain(moi(), i);

    if (n.vie <= 0)
        return;

    /* TODO TODO TODO NETTOYER CETTE MERDE (ET L'AMÉLIORER) */
    struct direction_array closest_path = {0};
    struct position closest_position = {.ligne = -1, .colonne = -1};
    struct position_array ores = liste_minerais();

    while (--ores.length) {
        if (info_minerai(ores.datas[ores.length]).rendement <= 1)
            continue;

        struct direction_array path = chemin(n.pos, ores.datas[ores.length]);

        if (closest_path.datas == NULL || path.length < closest_path.length) {
            free(closest_path.datas);
            closest_path = path;
            closest_position = ores.datas[ores.length];
        }
    }
    free(ores.datas);

    struct direction_array path;

    /*
     * TODO Autoriser le retour si n.butin < BUTIN_MAX si le minerai actuel
     * serait « gâché » dans un sens à définir
     */
    /* XXX Tours de sécurité pour rapatrier le butin + taux maximal d'enrichissement considéré */
    if ((tour_actuel() >= NB_TOURS - 20 && n.butin > 0) || n.butin == BUTIN_MAX)
        path = chemin(n.pos, position_taverne(moi()));
    else
        path = closest_path;

    walk(i, path);
    free(path.datas);
}

/*
 * Il y a deux types de personnes dans le monde : ceux qui tiennent le
 * pistolet ...
 */
static inline void go_fight(int i) {
    struct nain n = info_nain(moi(), i);

    if (n.vie <= 0)
        return;

    /* TODO Pondérer pour prioriser les proches (e.g. le voyageur de commerce) */
    int max_wealth = -1, max_index = -1;
    for (int j = 0; j < NB_NAINS; j++) {
        struct nain m = info_nain(adversaire(), j);

        if (m.butin > max_wealth)
            max_wealth = m.butin, max_index = j;
    }

    /* XXX Si les adversaires ne sont que des misérables sous un certain seuil */
    if (max_wealth <= 5)
        return go_dig(i);

    struct direction_array path = {0};

    /* TODO Retour intelligent à la taverne s'il ne reste plus de temps */
    /* XXX Tours de sécurité pour rapatrier le butin + taux maximal d'enrichissement considéré */
    if ((tour_actuel() >= NB_TOURS - 20 && n.butin > 0) || n.butin + max_wealth > BUTIN_MAX + BUTIN_MAX * .5)
        path = chemin(n.pos, position_taverne(moi()));
    else
        path = chemin(n.pos, info_nain(adversaire(), max_index).pos);

    /* S'il n'existe pas de chemin vers l'objectif fixé, on se barre creuser */
    if (path.length == 0) {
        free(path.datas);
        return go_dig(i);
    }

    walk(i, path);
    free(path.datas);

    /*
     * TODO Essayer le voyageur du commerce sur les nains adverses pour
     * minimiser la distance afin d'aller tous leur poutrer la figure
     *
     * TODO Répartir intelligemment les nains de telle sorte que ceux
     * qui n'ont littéralement pas les bourses pleines agressent en premier
     *
     * TODO TODO TODO Implémenter une stratégie d'évitement pour éviter de
     * se faire agresser collectivement lorsqu'un adversaire est proche
     */
}

void jouer_tour(void)
{
#if 0
    for (int x = 0; x < TAILLE_MINE; x++)
        for (int y = 0; y < TAILLE_MINE; y++)
            /* ¡Hasta la victoría siempre! */
            debug_afficher_drapeau((struct position){.ligne = x, .colonne = y}, DRAPEAU_ROUGE);
    /* TODO Une faucille et un marteau */
#endif

    /* Si on ne parvient pas à faire le moindre progrès, changer radicalement de stratégie */
    if (tour_actuel() >= 50 && score(moi()) == 0)
        for (int i = 0; i < NB_NAINS; i++)
            go_dig(i);
    else {
        for (int i = 0; i < NB_NAINS - 2; i++)
            go_fight(i);
        go_dig(NB_NAINS - 2);
        go_dig(NB_NAINS - 1);
    }
}

void partie_init(void){}
void partie_fin(void){}
