#include "prologin.h"

#define FIGHTING_RANGE      3


static struct {
    int x, y;
} d[4] = {{0, -1}, {0, 1}, {-1, 0}, {1, 0}};

static direction to[4] = {GAUCHE, DROITE, HAUT, BAS};
static int from[] = {
    [GAUCHE]    = 0,
    [DROITE]    = 1,
    [HAUT]      = 2,
    [BAS]       = 3,
};


/*
 * TODO Synchroniser la richesse minimale d'agression globale et locale
 * TODO Focus les nains adverses s'ils sont proches en mode go_dig()
 */

/*
 * TODO Ma propre fonction shortest_path() avec un Dijkstra en O(N^2) parce
 * que fornique sa matriarche les files à priorité en C
 *
 * TODO TODO TODO
 * TODO TODO TODO UN BFS 0-1 À DEUX FILES SUR LE NOMBRE DE TOURS NÉCESSAIRES
 * TODO TODO TODO
 *
 * TODO Du spawn kill si la taverne ennemie est proche de la mienne
 * TODO Creuser de haut en bas pour économiser des PMs
 */

static inline int my_abs(int x) { return x >= 0 ? x : -x; }
static inline int manhattan(struct position a, struct position b) { return my_abs(a.ligne - b.ligne) + my_abs(a.colonne - b.colonne); }


/* Profondeur sous une position donnée */
static inline int depth(struct position p) {
    struct position t = position_taverne(adversaire());
    int d = 0;

    /* La taverne ennemie se comporte comme un trou noir qui tue instantanément */
    if (p.ligne == t.ligne && p.colonne == t.colonne)
        goto BLACK_HOLE; /* Oh ! un goto ! */
    p.ligne++;
    while (type_case(p) == LIBRE) /* && nain_sur_case(p) != adversaire()) */ {
        if (p.ligne == t.ligne && p.colonne == t.colonne)
            goto BLACK_HOLE;
        p.ligne++, d++;
    }
    return d;

BLACK_HOLE:
    return 0xfffffff;
}

/*
 * Wrapper autour de lacher() pour éviter de ... lâcher si on est trop haut
 */
static inline bool try_release(int i, int max_fall) {
    if (depth(info_nain(moi(), i).pos) <= max_fall) {
        erreur e = lacher(i);

        return e == OK || e == PAS_ACCROCHE;
    }
    return false;
}

/*
 * Wrapper autour de miner() pour éviter de me blesser dans ma confusion
 */
static inline erreur try_dig(int i, direction dir) {
    struct position p = info_nain(moi(), i).pos;

    p.ligne += d[from[dir]].x, p.colonne += d[from[dir]].y;
    if (nain_sur_case(p) != moi())
        return miner(i, dir);
    return DIRECTION_INVALIDE;
}

/* Nombre de déplacements vers le haut passés */
static int past_up[NB_NAINS] = {0};

/*
 * Version améliorée de deplacer() pour automatiquement s'agripper et utiliser
 * la gravité pour gagner du temps.
 */
static inline erreur move(int i, direction dir, int next_down) {
    struct position p = info_nain(moi(), i).pos;

    p.ligne += d[from[dir]].x, p.colonne += d[from[dir]].y;
    try_release(i, 0);
    switch (dir) {
        case HAUT:
            agripper(i);
            break;
    case BAS:
            if (next_down >= 1)
                try_release(i, 3);
            break;
        case GAUCHE:
        case DROITE: {
            if (next_down <= 1 || depth(p) >= 4)
                agripper(i);
            /* XXX Tirage d'une corde par le dernier nain s'il a besoin de descendre ou monter beaucoup */
            if (i == NB_NAINS - 1 && (next_down >= 4 || past_up[i] >= 4 || depth(p) >= 4))
                poser_corde(i, dir);
            break;
        }
        default:
            return DIRECTION_INVALIDE;
    }

    struct position t = position_taverne(adversaire());
    erreur e = OK;

    /* On évite de se suicider sur la taverne ennemie */
    if (p.ligne != t.ligne || p.colonne != t.colonne)
        e = deplacer(i, dir);
    agripper(i);

    if (e == OK) {
        if (dir == HAUT)
            past_up[i]++;
        else
            past_up[i] = 0;
    }
    try_release(i, 0);
    return e;
}

/*
 * Fonction utile pour parcourir « correctement » un chemin donné
 */
static inline void walk(int i, struct direction_array path, int fighting_range) {
    for (int k = 0; k < path.length; k++) {
        int next_down = 0;

        for (int l = k+1; l < path.length && path.datas[l] == BAS; l++)
            next_down++;

        struct nain n = info_nain(moi(), i);

        /* Automatiquement tabasser les ennemis faibles à proximité */
        /* TODO Tenir compte de la multiplicité des nains sur une case, et entre autres les valeurs négatives */
        if (fighting_range >= 1) {
            int max_enemy = -1, max_wealth = -1, max_dist = 0xfffffff;

            for (int j = 0; j < NB_NAINS; j++) {
                struct nain m = info_nain(adversaire(), j);

                if (m.butin < 0)
                    continue;
                int dist = manhattan(n.pos, m.pos);
                if (dist <= fighting_range && ((m.vie <= DEGAT_PIOCHE && m.butin > max_wealth) || dist < max_dist))
                    max_enemy = j, max_wealth = m.butin, max_dist = dist;
            }

            if (max_enemy != -1) {
                struct direction_array enemy = chemin(info_nain(moi(), i).pos, info_nain(adversaire(), max_enemy).pos);

                /* fighting_range == 0 pour éviter les récursions infinies */
                walk(i, enemy, 0);
                free(enemy.datas);
            }
        }

        /* Si on ne parvient pas à avancer */
        if (move(i, path.datas[k], next_down) != OK && info_nain(moi(), i).pm > 0) {
            if (try_dig(i, path.datas[k]) == PA_INSUFFISANTS)
                break;
            move(i, path.datas[k], next_down);
        }

        /* Miner au cas où, pour économiser des PA au tour suivant */
        if (info_nain(moi(), i).pm <= 0 && k < path.length - 1) {
            try_dig(i, path.datas[k+1]);
            break;
        }

        /* Miner des minerais à proximité s'il reste des PAs */
        int max_ore = -1, max_value = -1;

        for (int _ = 0; _ < 4; _++) {
            struct position p = {.ligne = n.pos.ligne + d[_].x, .colonne = n.pos.colonne + d[_].y};
            struct minerai m = info_minerai(p);

            if (m.rendement > max_value)
                max_ore = _, max_value = m.rendement;
        }

        if (max_ore >= 0)
            try_dig(i, to[max_ore]);

        /* TODO Tirer une corde proche si tous les nains alliés dessus vont
         * dans la même direction
         * Si aucun nain allié n'est dessus (mais éventuellement un ennemi),
         * tirer la corde dans la direction opposée à la taverne ennemie.
         */
    }
}

static position focus[NB_NAINS] = {[0 ... NB_NAINS - 1] = {.ligne = -1, .colonne = -1}};

/*
 * ... et ceux qui creusent. Toi, tu creuses !
 *
 * TODO Récolter du minerai négatif pour tromper l'ennemi et lui
 * infliger des malus (en particulier si la carte n'a que du négatif)
 *
 * TODO Utiliser une sorte de knapsack pour trouver une courte liste
 * de minerais proches mais intéressants à ramasser, puis utiliser
 * le voyageur du commerce pour trouver un chemin passant par tous
 *
 * TODO Implémenter une stratégie à 2 (ou plus) nain, où le fameux knapsack
 * trouve 2 * K minerais et un minerai sur deux va pour chaque nain
 *
 *      e.g. : si on trouve XXXXXX dans « l'ordre de distance » (à définir)
 *
 *              alors on a  X X X   -> nain 1
 *                           x X X  -> nain 2
 *
 * TODO Envisager d'aller agresser s'il n'y a rien d'intéressant à faire, ou
 * si le problème est trop symétrique
 *
 * TODO TODO TODO Ventiler les minerais pour éviter que plusieurs nains focus
 * le même filon
 */

static int targeted[TAILLE_MINE][TAILLE_MINE] = {[0 ... TAILLE_MINE - 1] = {[0 ... TAILLE_MINE - 1] = -1}};

static inline int ore_depth(struct position p) {
    int d = 0;

    while (info_minerai(p).rendement > 0)
        d++, p.ligne++;
    return d;
}

static inline void go_dig(int i) {
    struct nain n = info_nain(moi(), i);
    int t = tour_actuel();

    if (n.vie <= 0)
        return;

    struct position_array ores = liste_minerais();
    int target_k = -1, target_length = 0xfffffff, last_positive = -1;

    for (int k = 0; k < ores.length; k++) {
        struct minerai m = info_minerai(ores.datas[k]);

        if (targeted[ores.datas[k].ligne][ores.datas[k].colonne] >= t || m.rendement <= 1) {
            if (m.rendement > 0)
                last_positive = k;
            continue;
        }

        struct direction_array path = chemin(n.pos, ores.datas[k]);

        if (path.length < target_length)
            target_k = k, target_length = path.length;
        free(path.datas);
    }

    if (target_k == -1)
        target_k = last_positive;

    int max_k = -1, max_value = -1;

    for (int k = 0; k < ores.length; k++) {
        struct minerai m = info_minerai(ores.datas[k]);
        int dx = ores.datas[k].ligne - ores.datas[target_k].ligne;

        if (dx > 0 && dx <= 2 && ore_depth(ores.datas[k]) >= 3 && m.rendement > max_value)
            max_k = k, max_value = m.rendement;
    }

    if (max_k != -1)
        target_k = max_k;

    struct direction_array path;

    /*
     * TODO Autoriser le retour si n.butin < BUTIN_MAX si le minerai actuel
     * serait « gâché » dans un sens à définir
     */
    /* XXX Tours de sécurité pour rapatrier le butin + taux maximal d'enrichissement considéré */
    if ((tour_actuel() >= NB_TOURS - 20 && n.butin > 0) || n.butin == BUTIN_MAX)
        path = chemin(n.pos, position_taverne(moi()));
    else
        path = chemin(n.pos, ores.datas[target_k]);
    free(ores.datas);

    walk(i, path, FIGHTING_RANGE);
    free(path.datas);
}

/*
 * Il y a deux types de personnes dans le monde : ceux qui tiennent le
 * pistolet ...
 */
static inline void go_fight(int i) {
    struct nain n = info_nain(moi(), i);

    if (n.vie <= 0)
        return;

    /* TODO Pondérer pour prioriser les proches (e.g. le voyageur de commerce) */
    int max_wealth = -1, max_index = -1;
    for (int j = 0; j < NB_NAINS; j++) {
        struct nain m = info_nain(adversaire(), j);

        if (m.butin > max_wealth)
            max_wealth = m.butin, max_index = j;
    }

    /* XXX Si les adversaires ne sont que des misérables sous un certain seuil */
    if (max_wealth <= 5)
        return go_dig(i);

    struct direction_array path = chemin(n.pos, position_taverne(moi()));

    /* TODO Retour intelligent  la taverne s'il ne reste plus de temps */
    /* XXX Tours de sécurité pour rapatrier le butin + taux maximal d'enrichissement */
    if (tour_actuel() + 20 < NB_TOURS && n.butin > 0 && n.butin + max_wealth > BUTIN_MAX * 1.5)
        free(path.datas), path = chemin(n.pos, info_nain(adversaire(), max_index).pos);

    /* S'il n'existe pas de chemin vers l'objectif fixé, on se barre creuser */
    if (path.length == 0) {
        free(path.datas);
        return go_dig(i);
    }

    walk(i, path, FIGHTING_RANGE);
    free(path.datas);

    /*
     * TODO Essayer le voyageur du commerce sur les nains adverses pour
     * minimiser la distance afin d'aller tous leur poutrer la figure
     *
     * TODO Répartir intelligemment les nains de telle sorte que ceux
     * qui n'ont littéralement pas les bourses pleines agressent en premier
     *
     * TODO TODO TODO Implémenter une stratégie d'évitement pour éviter de
     * se faire agresser collectivement lorsqu'un adversaire est proche
     */
}

void jouer_tour(void)
{
    /* Si on ne parvient pas à faire le moindre progrès, changer radicalement de stratégie */
    if (tour_actuel() >= NB_TOURS / 2 && score(moi()) == 0)
        for (int i = 0; i < NB_NAINS; i++)
            go_dig(i);
    else {
        for (int i = 0; i < NB_NAINS - 2; i++)
            go_fight(i);
        go_dig(NB_NAINS - 2);
        go_dig(NB_NAINS - 1);
    }

    /* Au cas où, on pose une corde là où il y a le plus de profondeur */
    /* TODO Éviter de donner un avantage à l'adversaire */
    int max_index = -1, max_dir = -1, max_depth = -1;

    for (int i = 0; i < NB_NAINS; i++)
        for (int _ = 0; _ < 4; _++) {
            struct position p = info_nain(moi(), i).pos;
            int current_depth;

            p.ligne += d[_].x, p.colonne += d[_].y;
            if (corde_sur_case(p))
                continue;
            current_depth = depth(p);
            if (current_depth > max_depth)
                max_index = i, max_dir = _, max_depth = current_depth;
        }
    poser_corde(max_index, max_dir);
}

void partie_init(void){}
void partie_fin(void){}
