#include "prologin.h"


static inline int manhattan(struct position a, struct position b) { return abs(a.ligne - b.ligne) + abs(a.colonne - b.colonne); }


/*
 * Version améliorée de deplacer() pour automatiquement s'agripper et utiliser
 * la gravité pour gagner du temps.
 */
erreur approcher(int i, direction dir) {
    switch (dir) {
        case HAUT:
            agripper(i);
            break;
        case BAS: {
            /* TODO Programmation plus fine afin d'éviter de tomber pour rien */
            int avant = info_nain(moi(), i).vie;

            if (lacher(i) != OK)
                break;
            /* XXX Dégâts maximum tolérés lorsqu'on se laisse chuter */
            if (avant - info_nain(moi(), i).vie > 0)
                annuler();
            break;
        }
        case GAUCHE:
        case DROITE: {
            struct position avant = info_nain(moi(), i).pos;

            if (type_case((struct position){.ligne = avant.ligne - 1, .colonne = avant.colonne}) != LIBRE) {
                printf("#%d : SOL DUR, Tentative de déplacement vers %d (lacher(i) == %d)...\n", i, dir, lacher(i));

                if (deplacer(i, dir) != OK)
                    break;
                int dist = manhattan(avant, info_nain(moi(), i).pos);

                annuler();
                /* XXX Profondeur maximale à laquelle on s'autorise de tomber lors d'un déplacement latéral */
                if (dist - 1 > 1)
                    agripper(i);
            }
            break;
        }
        default:
            return DIRECTION_INVALIDE;
    }
    return deplacer(i, dir);
}

void jouer_tour(void)
{
    if (tour_actuel() == 0) {
        for (int x = 0; x < TAILLE_MINE; x++)
            for (int y = 0; y < TAILLE_MINE; y++)
                /* ¡Hasta la victoría siempre! */
                debug_afficher_drapeau((struct position){.ligne = x, .colonne = y}, DRAPEAU_ROUGE);
        /* TODO Une faucille et un marteau */
    }

    for (int i = 0; i < NB_NAINS; i++) {
        struct nain n = info_nain(moi(), i);

        if (n.vie <= 0)
            continue;

        int max_wealth = -1, max_index = -1;
        for (int j = 0; j < NB_NAINS; j++) {
            struct nain m = info_nain(adversaire(), j);

            if (m.butin > max_wealth)
                max_wealth = m.butin, max_index = j;
        }

        struct direction_array path = {0};

        /* TODO Retour intelligent à la taverne s'il ne reste plus de temps */
        /* XXX Tours de sécurité pour rapatrier le butin + taux maximal d'enrichissement considéré */
        if (tour_actuel() >= NB_TOURS - 10 || n.butin + max_wealth > BUTIN_MAX + BUTIN_MAX * .5)
            path = chemin(n.pos, position_taverne(moi()));
        else
            path = chemin(n.pos, info_nain(adversaire(), max_index).pos);

        for (int k = 0; k < path.length; k++) {
            if (approcher(i, path.datas[k]) != OK) {
                /* Si on ne peut ni avancer ni casser l'obstacle, arrêter */
                if (miner(i, path.datas[k]) == PA_INSUFFISANTS)
                    break;
                approcher(i, path.datas[k]);
            }

            /* Miner au cas où, pour économiser des PA au tour suivant */
            if (info_nain(moi(), i).pm <= 0) {
                miner(i, path.datas[k]);
                break;
            }
        }
        free(path.datas);

        /*
         * TODO Essayer le voyageur du commerce sur les nains adverses pour
         * minimiser la distance afin d'aller tous leur poutrer la figure
         *
         * TODO Répartir intelligemment les nains de telle sorte que ceux
         * qui n'ont littéralement pas les bourses pleines agressent en premier
         *
         * TODO Implémenter une stratégie d'évitement pour éviter de se faire
         * agresser collectivement lorsqu'un adversaire est proche
         */
    }
}

void partie_init(void){}
void partie_fin(void){}
