/*!
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_c.rb
*/

#pragma once

#include <stdlib.h>
#include <stdbool.h>

/*!
** Taille de la mine (longueur et largeur).
*/
# define TAILLE_MINE               31

/*!
** Nombre de tours à jouer avant la fin de la partie.
*/
# define NB_TOURS                  100

/*!
** Nombre de points de déplacement par tour par nain (standard).
*/
# define NB_POINTS_DEPLACEMENT     5

/*!
** Nombre de points d'action par tour par nain (standard).
*/
# define NB_POINTS_ACTION          6

/*!
** Nombre de points de vie d'un nain (standard).
*/
# define VIE_NAIN                  10

/*!
** Nombre de joueurs.
*/
# define NB_JOUEURS                2

/*!
** Nombre de nains (standard) par joueur.
*/
# define NB_NAINS                  6

/*!
** Dégât infligé par un coup de pioche à un nain (standard).
*/
# define DEGAT_PIOCHE              3

/*!
** Valeur cumulée maximale des minerais qu'un nain (standard) peut emporter avec lui.
*/
# define BUTIN_MAX                 25

/*!
** Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case.
*/
# define COUT_DEPLACEMENT          1

/*!
** Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case lorsqu'il est agrippé.
*/
# define COUT_ESCALADER            2

/*!
** Nombre de points de déplacement pour qu'un nain (standard) se déplace vers une case occupée par une corde lorsqu'il est agrippé.
*/
# define COUT_ESCALADER_CORDE      1

/*!
** Nombre de points d'action pour qu'un nain (standard) mine un bloc.
*/
# define COUT_MINER                6

/*!
** Nombre de points d'action pour qu'un nain (standard) tire sur une corde.
*/
# define COUT_TIRER                1

/*!
** Nombre de points d'action pour qu'un nain (standard) lâche la paroi.
*/
# define COUT_LACHER               0

/*!
** Nombre de points d'action pour qu'un nain (standard) s'agrippe à la paroi.
*/
# define COUT_AGRIPPER             0

/*!
** Types de cases
*/
typedef enum case_type {
  LIBRE, /* <- Case libre, qui peut abriter une corde et des nains (standard) */
  GRANITE, /* <- Granite (standard), qui peut cacher du minerai */
  OBSIDIENNE, /* <- Obsidienne */
  ERREUR_CASE, /* <- Erreur */
} case_type;


/*!
** Direction
*/
typedef enum direction {
  HAUT, /* <- Direction : haut */
  BAS, /* <- Direction : bas */
  GAUCHE, /* <- Direction : gauche */
  DROITE, /* <- Direction : droite */
  ERREUR_DIRECTION, /* <- Erreur */
} direction;


/*!
** Erreurs possibles
*/
typedef enum erreur {
  OK, /* <- L'action s'est effectuée avec succès. */
  PA_INSUFFISANTS, /* <- Votre nain (standard) ne possède pas assez de points d'action pour réaliser cette action. */
  PM_INSUFFISANTS, /* <- Votre nain (standard) ne possède pas assez de points de déplacement pour réaliser ce déplacement. */
  HORS_LIMITES, /* <- L'action est en dehors des limites de la mine. */
  DIRECTION_INVALIDE, /* <- La direction spécifiée n'existe pas, ou vous n'êtes pas autorisé à cibler cette direction pour cette action. */
  ID_NAIN_INVALIDE, /* <- Le nain (standard) spécifié n'existe pas. */
  OBSTACLE_MUR, /* <- La position spécifiée est un mur. */
  OBSTACLE_NAIN, /* <- La position spécifiée est un nain (standard) adverse. */
  OBSTACLE_CORDE, /* <- Il y a déjà une corde dans la direction spécifiée. */
  PAS_DE_CIBLE, /* <- Il n'y a pas de nain (standard) ni de granite (standard) sur la position spécifiée. */
  NAIN_MORT, /* <- Le nain (standard) spécifié est mort. */
  PAS_ACCROCHE, /* <- Le nain (standard) n'est pas accroché. */
  DEJA_ACCROCHE, /* <- Le nain (standard) est déjà accroché. */
  PAS_DE_CORDE, /* <- Il n'y a pas de corde dans la direction spécifiée. */
  DRAPEAU_INVALIDE, /* <- Le drapeau spécifié n'existe pas. */
} erreur;


/*!
** Types d'actions
*/
typedef enum action_type {
  ACTION_DEPLACER, /* <- Action ``deplacer`` */
  ACTION_LACHER, /* <- Action ``lacher`` */
  ACTION_MINER, /* <- Action ``miner`` */
  ACTION_POSER_CORDE, /* <- Action ``poser_corde`` */
  ACTION_TIRER, /* <- Action ``tirer`` */
  ACTION_AGRIPPER, /* <- Action ``agripper`` */
} action_type;


/*!
** Types de drapeaux de débug
*/
typedef enum debug_drapeau {
  AUCUN_DRAPEAU, /* <- Aucun drapeau, enlève le drapeau présent */
  DRAPEAU_BLEU, /* <- Drapeau bleu */
  DRAPEAU_VERT, /* <- Drapeau vert */
  DRAPEAU_ROUGE, /* <- Drapeau rouge */
} debug_drapeau;


struct position;
struct minerai;
struct nain;
struct action_hist;

typedef struct direction_array {
  direction* datas;
  size_t length;
} direction_array;

typedef struct position_array {
  struct position* datas;
  size_t length;
} position_array;

typedef struct action_hist_array {
  struct action_hist* datas;
  size_t length;
} action_hist_array;

/*!
** Position dans la mine, donnée par deux coordonnées.
*/
typedef struct position {
  int ligne;  /* <- Coordonnée : ligne */
  int colonne;  /* <- Coordonnée : colonne */
} position;


/*!
** Minerai à récolter
*/
typedef struct minerai {
  int resistance;  /* <- Nombre de coups de pioches encore nécessaires avant que le bloc de minerais ne casse */
  int rendement;  /* <- Valeur marchande du bloc de minerai */
} minerai;


/*!
** Nain (standard)
*/
typedef struct nain {
  position pos;  /* <- Position actuelle du nain (standard) */
  int vie;  /* <- Point(s) de vie restant du nain (standard) */
  int pa;  /* <- Point(s) d'action restant du nain (standard) */
  int pm;  /* <- Point(s) de déplacement restant du nain (standard) */
  bool accroche;  /* <- Le nain (standard) est accroché à la paroi ou à une corde */
  int butin;  /* <- Valeur marchande totale que le nain (standard) possède */
} nain;


/*!
** Action de déplacement représentée dans l'historique.
*/
typedef struct action_hist {
  action_type atype;  /* <- Type de l'action */
  int id_nain;  /* <- Numéro du nain (standard) concerné par l'action */
  direction dir;  /* <- Direction visée par le nain (standard) durant le déplacement */
  direction sens;  /* <- Sens de l'action, utilisé uniquement pour préciser si l'on doit tirer une corde vers le bas ou vers le haut. Direction doit cibler la droite ou la gauche. */
} action_hist;


/*!
** Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
*/
direction_array chemin(position pos1, position pos2);

/*!
** Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
*/
erreur deplacer(int id_nain, direction dir);

/*!
** Le nain (standard) ``id_nain`` lâche la paroi.
*/
erreur lacher(int id_nain);

/*!
** Le nain (standard) ``id_nain`` s'agrippe à la paroi.
*/
erreur agripper(int id_nain);

/*!
** Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
*/
erreur miner(int id_nain, direction dir);

/*!
** Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
*/
erreur tirer(int id_nain, direction dir_corde, direction sens);

/*!
** Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
*/
erreur poser_corde(int id_nain, direction dir);

/*!
** Affiche le drapeau spécifié sur la case indiquée.
*/
erreur debug_afficher_drapeau(position pos, debug_drapeau drapeau);

/*!
** Renvoie le type d'une case donnée.
*/
case_type type_case(position pos);

/*!
** Renvoie la liste de toutes les positions occupées par une corde dans la mine.
*/
position_array liste_cordes(void);

/*!
** Indique si une corde se trouve sur une case donnée.
*/
bool corde_sur_case(position pos);

/*!
** Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
*/
int nain_sur_case(position pos);

/*!
** Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
*/
nain info_nain(int id_joueur, int id_nain);

/*!
** Renvoie la liste de tous les minerais dans la mine.
*/
position_array liste_minerais(void);

/*!
** Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
*/
minerai info_minerai(position pos);

/*!
** Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
*/
int cout_de_deplacement(int id_nain, direction dir);

/*!
** Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
*/
position position_taverne(int id_joueur);

/*!
** Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
*/
action_hist_array historique(void);

/*!
** Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
*/
int score(int id_joueur);

/*!
** Renvoie votre numéro de joueur.
*/
int moi(void);

/*!
** Renvoie le numéro de joueur de votre adversaire.
*/
int adversaire(void);

/*!
** Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
*/
bool annuler(void);

/*!
** Retourne le numéro du tour actuel.
*/
int tour_actuel(void);

/*!
** Affiche le contenu d'une valeur de type case_type
*/
void afficher_case_type(case_type v);

/*!
** Affiche le contenu d'une valeur de type direction
*/
void afficher_direction(direction v);

/*!
** Affiche le contenu d'une valeur de type erreur
*/
void afficher_erreur(erreur v);

/*!
** Affiche le contenu d'une valeur de type action_type
*/
void afficher_action_type(action_type v);

/*!
** Affiche le contenu d'une valeur de type debug_drapeau
*/
void afficher_debug_drapeau(debug_drapeau v);

/*!
** Affiche le contenu d'une valeur de type position
*/
void afficher_position(position v);

/*!
** Affiche le contenu d'une valeur de type minerai
*/
void afficher_minerai(minerai v);

/*!
** Affiche le contenu d'une valeur de type nain
*/
void afficher_nain(nain v);

/*!
** Affiche le contenu d'une valeur de type action_hist
*/
void afficher_action_hist(action_hist v);

/*!
** Fonction appelée au début de la partie.
*/
void partie_init(void);

/*!
** Fonction appelée à chaque tour.
*/
void jouer_tour(void);

/*!
** Fonction appelée à la fin de la partie.
*/
void partie_fin(void);

