#include "prologin.h"

static struct {
    int x, y;
} d[4] = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

static direction to[4] = {HAUT, BAS, GAUCHE, DROITE};


/*
 * TODO Agresser les nains adverses lorsqu'on passe à proximité ("")
 * TODO Miner les minerais lorsqu'on passe à proximité (en évitant le négatif)
 * TODO Synchroniser la richesse minimale d'agression globale et locale
 */

static inline int manhattan(struct position a, struct position b) { return abs(a.ligne - b.ligne) + abs(a.colonne - b.colonne); }

/*
 * Wrapper autour de lacher() pour éviter les actions douloureuses
 * TODO Envisager de renvoyer void
 */
static inline bool try_release(int i, int max_damage) {
    int avant = info_nain(moi(), i).vie;

    if (lacher(i) == OK) {
        int apres = info_nain(moi(), i).vie;

        /* XXX Dégâts maximum tolérés lorsqu'on se laisse chuter */
        if (apres <= 0 || abs(avant - info_nain(moi(), i).vie) > max_damage) {
            annuler();
            return false;
        }
        return true;
    }
    return false;
}


/*
 * Version améliorée de deplacer() pour automatiquement s'agripper et utiliser
 * la gravité pour gagner du temps.
 */
static inline erreur move(int i, direction dir) {
    switch (dir) {
        case HAUT:
            agripper(i);
            break;
        case BAS:
            /* TODO Programmation plus fine afin d'éviter de tomber pour rien */
            try_release(i, 0);
            break;
        case GAUCHE:
        case DROITE: {
            struct position avant = info_nain(moi(), i).pos;

            if (type_case((struct position){.ligne = avant.ligne - 1, .colonne = avant.colonne}) != LIBRE) {
                try_release(i, 0);

                if (deplacer(i, dir) != OK)
                    break;
                int dist = manhattan(avant, info_nain(moi(), i).pos);

                annuler();
                /* XXX Profondeur maximale à laquelle on s'autorise de tomber lors d'un déplacement latéral */
                if (dist - 1 > 2)
                    agripper(i);
            /* XXX Profondeur maximale à laquelle on s'autorise de tomber lors d'un déplacement latéral */
            } else if (!try_release(i, 0) || manhattan(avant, info_nain(moi(), i).pos) > 2)
                agripper(i);
            break;
        }
        default:
            return DIRECTION_INVALIDE;
    }

    if (deplacer(i, dir) == OK) {
        int vie = info_nain(moi(), i).vie;

        annuler();
        /*
         * Si le déplacement est mortel, on tente de s'agripper, sinon ne rien
         * faire (e.g taverne ennemie)
         */
        if (vie == -1)
            if (agripper(i) == OK) {
                if (deplacer(i, dir) == OK) {
                    vie = info_nain(moi(), i).vie;

                    annuler();
                    if (vie == -1)
                        return NAIN_MORT;
                }
                annuler();
            }
    }
    return deplacer(i, dir);
}

/*
 * Fonction utile pour parcourir « correctement » un chemin donné
 */
static inline void walk(int i, struct direction_array path) {
    /*
     * TODO Placer des cordes s'il faut descendre beaucoup à un moment
     * TODO Implémenter l'autosélection d'un nain proche d'une corde à
     * qui il reste des PAs lorsque le nain courant est sur une corde pour
     * faire marcher la poulie
     */
    for (int k = 0; k < path.length; k++) {
        if (move(i, path.datas[k]) != OK && info_nain(moi(), i).pm) {
            /* Si on ne peut ni avancer ni casser l'obstacle, arrêter */
            if (miner(i, path.datas[k]) == PA_INSUFFISANTS)
                break;
            move(i, path.datas[k]);
        }

        struct nain n = info_nain(moi(), i);

        /* Automatiquement tabasser les ennemis faibles à proximité */
        /* TODO Tenir compte de la multiplicité des nains sur une case, et entre autres les valeurs négatives */
        int max_enemy = -1, max_wealth = -1;

        for (int j = 0; j < NB_NAINS; j++) {
            struct nain m = info_nain(adversaire(), j);

            if (m.butin < 0)
                continue;
            /* XXX À partir de combien de coups c'est intéressant */
            if (manhattan(n.pos, m.pos) <= 1 && (m.vie <= DEGAT_PIOCHE || m.butin > BUTIN_MAX * .5 && m.vie <= 2 * DEGAT_PIOCHE))
                for (int _ = 0; _ < 4; _++) {
                    struct position p = {.ligne = n.pos.ligne + d[_].x, .colonne = n.pos.colonne + d[_].y};

                    if (p.ligne == m.pos.ligne && p.colonne == m.pos.colonne && m.butin > max_wealth)
                        max_enemy = _, max_wealth = m.butin;
                }
        }

        if (max_enemy != -1)
            miner(i, to[max_enemy]);

        /* Miner au cas où, pour économiser des PA au tour suivant */
        if (info_nain(moi(), i).pm <= 0 && k < path.length - 1) {
            int avant = 0;

            for (int j = 0; j < NB_NAINS; j++)
                avant += info_nain(moi(), j).vie;
            if (miner(i, path.datas[k+1]) == OK) {
                int apres = 0;

                for (int j = 0; j < NB_NAINS; j++)
                    apres += info_nain(moi(), j).vie;
                /* Si on s'est blessé dans notre confusion */
                if (apres != avant)
                    annuler();
            }
            break;
        }

        /* Miner des minerais à proximité s'il reste des PAs */
        int max_ore = -1, max_value = -1;

        for (int _ = 0; _ < 4; _++) {
            struct position p = {.ligne = n.pos.ligne + d[_].x, .colonne = n.pos.colonne + d[_].y};
            struct minerai m = info_minerai(p);

            if (m.rendement > max_value)
                max_ore = _, max_value = m.rendement;
        }

        if (max_ore >= 0)
            miner(i, to[max_ore]);
    }
}


/*
 * TODO Ma propre fonction shortest_path() avec un Dijkstra en O(N^2) parce
 * que fornique sa matriarche les files à priorité en C
 */


/*
 * ... et ceux qui creusent. Toi, tu creuses !
 *
 * TODO Récolter du minerai négatif pour tromper l'ennemi et lui
 * infliger des malus (en particulier si la carte n'a que du négatif)
 *
 * TODO Utiliser une sorte de knapsack pour trouver une courte liste
 * de minerais proches mais intéressants à ramasser, puis utiliser
 * le voyageur du commerce pour trouver un chemin passant par tous
 *
 * TODO Implémenter une stratégie à 2 (ou plus) nain, où le fameux knapsack
 * trouve 2 * K minerais et un minerai sur deux va pour chaque nain
 *
 *      e.g. : si on trouve XXXXXX dans « l'ordre de distance » (à définir)
 *
 *              alors on a  X X X   -> nain 1
 *                           x X X  -> nain 2
 *
 * TODO Envisager d'aller agresser s'il n'y a rien d'intéressant à faire, ou
 * si le problème est trop symétrique
 */
static inline void go_dig(int i) {
    struct nain n = info_nain(moi(), i);

    if (n.vie <= 0)
        return;

    /* TODO TODO TODO NETTOYER CETTE MERDE (ET L'AMÉLIORER) */
    struct direction_array closest_path = {0};
    struct position closest_position = {.ligne = -1, .colonne = -1};
    struct position_array ores = liste_minerais();

    while (--ores.length) {
        if (info_minerai(ores.datas[ores.length]).rendement <= 1)
            continue;

        struct direction_array path = chemin(n.pos, ores.datas[ores.length]);

        if (closest_path.datas == NULL || path.length < closest_path.length) {
            free(closest_path.datas);
            closest_path = path;
            closest_position = ores.datas[ores.length];
        }
    }
    free(ores.datas);

    struct direction_array path;

    /*
     * TODO Autoriser le retour si n.butin < BUTIN_MAX si le minerai actuel
     * serait « gâché » dans un sens à définir
     */
    /* XXX Tours de sécurité pour rapatrier le butin + taux maximal d'enrichissement considéré */
    if ((tour_actuel() >= NB_TOURS - 20 && n.butin > 0) || n.butin == BUTIN_MAX)
        path = chemin(n.pos, position_taverne(moi()));
    else
        path = closest_path;

    walk(i, path);
    free(path.datas);
}

/*
 * Il y a deux types de personnes dans le monde : ceux qui tiennent le
 * pistolet ...
 */
static inline void go_fight(int i) {
    struct nain n = info_nain(moi(), i);

    if (n.vie <= 0)
        return;

    /* TODO Pondérer pour prioriser les proches (e.g. le voyageur de commerce) */
    int max_wealth = -1, max_index = -1;
    for (int j = 0; j < NB_NAINS; j++) {
        struct nain m = info_nain(adversaire(), j);

        if (m.butin > max_wealth)
            max_wealth = m.butin, max_index = j;
    }

    /* XXX Si les adversaires ne sont que des misérables sous un certain seuil */
    if (max_wealth <= 5)
        return go_dig(i);

    struct direction_array path = {0};

    /* TODO Retour intelligent à la taverne s'il ne reste plus de temps */
    /* XXX Tours de sécurité pour rapatrier le butin + taux maximal d'enrichissement considéré */
    if ((tour_actuel() >= NB_TOURS - 20 && n.butin > 0) || n.butin + max_wealth > BUTIN_MAX + BUTIN_MAX * .5)
        path = chemin(n.pos, position_taverne(moi()));
    else
        path = chemin(n.pos, info_nain(adversaire(), max_index).pos);

    /* S'il n'existe pas de chemin vers l'objectif fixé, on se barre creuser */
    if (path.length == 0) {
        free(path.datas);
        return go_dig(i);
    }

    walk(i, path);
    free(path.datas);

    /*
     * TODO Essayer le voyageur du commerce sur les nains adverses pour
     * minimiser la distance afin d'aller tous leur poutrer la figure
     *
     * TODO Répartir intelligemment les nains de telle sorte que ceux
     * qui n'ont littéralement pas les bourses pleines agressent en premier
     *
     * TODO TODO TODO Implémenter une stratégie d'évitement pour éviter de
     * se faire agresser collectivement lorsqu'un adversaire est proche
     */
}

void jouer_tour(void)
{
#if 0
    for (int x = 0; x < TAILLE_MINE; x++)
        for (int y = 0; y < TAILLE_MINE; y++)
            /* ¡Hasta la victoría siempre! */
            debug_afficher_drapeau((struct position){.ligne = x, .colonne = y}, DRAPEAU_ROUGE);
    /* TODO Une faucille et un marteau */
#endif

    for (int i = 0; i < NB_NAINS - 1; i++)
        go_fight(i);
    go_dig(NB_NAINS - 1);
}

void partie_init(void){}
void partie_fin(void){}
