#include "prologin.h"


static inline int manhattan(struct position a, struct position b) { return abs(a.ligne - b.ligne) + abs(a.colonne - b.colonne); }


/*
 * Version améliorée de deplacer() pour automatiquement s'agripper et utiliser
 * la gravité pour gagner du temps.
 */
static inline erreur move(int i, direction dir) {
    switch (dir) {
        case HAUT:
            agripper(i);
            break;
        case BAS: {
            /* TODO Programmation plus fine afin d'éviter de tomber pour rien */
            int avant = info_nain(moi(), i).vie;

            if (lacher(i) == OK) {
                /* XXX Dégâts maximum tolérés lorsqu'on se laisse chuter */
                if (abs(avant - info_nain(moi(), i).vie) > 0)
                    annuler();
            }
            break;
        }
        case GAUCHE:
        case DROITE: {
            struct position avant = info_nain(moi(), i).pos;

            if (type_case((struct position){.ligne = avant.ligne - 1, .colonne = avant.colonne}) != LIBRE) {
                lacher(i);

                if (deplacer(i, dir) != OK)
                    break;
                int dist = manhattan(avant, info_nain(moi(), i).pos);

                annuler();
                /* XXX Profondeur maximale à laquelle on s'autorise de tomber lors d'un déplacement latéral */
                if (dist - 1 > 0)
                    agripper(i);
            } else
                agripper(i);
            break;
        }
        default:
            return DIRECTION_INVALIDE;
    }
    return deplacer(i, dir);
}

/*
 * Fonction utile pour parcourir « correctement » un chemin donné
 */
static inline erreur walk(int i, struct direction_array path) {
    /* On met path.length - 1 car on ne veut qu'être à côté */
    for (int k = 0; k < path.length - 1; k++) {
        if (move(i, path.datas[k]) != OK && info_nain(moi(), i).pm) {
            /* Si on ne peut ni avancer ni casser l'obstacle, arrêter */
            if (miner(i, path.datas[k]) == PA_INSUFFISANTS)
                break;
            move(i, path.datas[k]);
        }

        /* Miner au cas où, pour économiser des PA au tour suivant */
        if (info_nain(moi(), i).pm <= 0 && k < path.length - 1) {
            int avant = 0;

            for (int j = 0; j < NB_NAINS; j++)
                avant += info_nain(moi(), j).vie;
            if (miner(i, path.datas[k+1]) == OK) {
                int apres = 0;

                for (int j = 0; j < NB_NAINS; j++)
                    apres += info_nain(moi(), j).vie;
                /* Si on s'est blessé dans notre confusion */
                if (apres != avant)
                    annuler();
            }
            break;
        }
    }
}

void jouer_tour(void)
{
    for (int x = 0; x < TAILLE_MINE; x++)
        for (int y = 0; y < TAILLE_MINE; y++)
            /* ¡Hasta la victoría siempre! */
            debug_afficher_drapeau((struct position){.ligne = x, .colonne = y}, DRAPEAU_ROUGE);
    /* TODO Une faucille et un marteau */

    for (int i = 0; i < NB_NAINS - 1; i++) {
        struct nain n = info_nain(moi(), i);

        if (n.vie <= 0)
            continue;

        /* TODO Pondérer pour prioriser les proches (e.g. le voyageur de commerce) */
        int max_wealth = -1, max_index = -1;
        for (int j = 0; j < NB_NAINS; j++) {
            struct nain m = info_nain(adversaire(), j);

            if (m.butin > max_wealth)
                max_wealth = m.butin, max_index = j;
        }

        struct direction_array path = {0};

        /* TODO Retour intelligent à la taverne s'il ne reste plus de temps */
        /* XXX Tours de sécurité pour rapatrier le butin + taux maximal d'enrichissement considéré */
        if (tour_actuel() >= NB_TOURS - 20 || n.butin + max_wealth > BUTIN_MAX + BUTIN_MAX * .5)
            path = chemin(n.pos, position_taverne(moi()));
        else
            path = chemin(n.pos, info_nain(adversaire(), max_index).pos);

        walk(i, path);
        free(path.datas);

        /*
         * TODO Essayer le voyageur du commerce sur les nains adverses pour
         * minimiser la distance afin d'aller tous leur poutrer la figure
         *
         * TODO Répartir intelligemment les nains de telle sorte que ceux
         * qui n'ont littéralement pas les bourses pleines agressent en premier
         *
         * TODO TODO TODO Implémenter une stratégie d'évitement pour éviter de se faire
         * agresser collectivement lorsqu'un adversaire est proche
         */
    }


    /* TODO TODO TODO NETTOYER CETTE MERDE (ET L'AMÉLIORER) */

    struct direction_array closest_path = {0};
    struct position closest_position = {.ligne = -1, .colonne = -1};
    struct position_array ores = liste_minerais();
    struct nain n = info_nain(moi(), NB_NAINS - 1);

    while (--ores.length) {
        if (info_minerai(ores.datas[ores.length]).rendement <= 1)
            continue;

        struct direction_array path = chemin(n.pos, ores.datas[ores.length]);

        if (closest_path.datas == NULL || path.length < closest_path.length) {
            free(closest_path.datas);
            closest_path = path;
            closest_position = ores.datas[ores.length];
        }
    }
    free(ores.datas);

    struct direction_array path;

    if (tour_actuel() >= NB_TOURS - 10 || n.butin == BUTIN_MAX)
        path = chemin(n.pos, position_taverne(moi()));
    else
        path = closest_path;

    for (int k = 0; k < path.length; k++) {
        if (move(NB_NAINS - 1, path.datas[k]) != OK && info_nain(moi(), NB_NAINS - 1).pm) {
            /* Si on ne peut ni avancer ni casser l'obstacle, arrêter */
            if (miner(NB_NAINS - 1, path.datas[k]) == PA_INSUFFISANTS)
                break;
            move(NB_NAINS - 1, path.datas[k]);
        }

        /* Miner au cas où, pour économiser des PA au tour suivant */
        if (info_nain(moi(), NB_NAINS - 1).pm <= 0 && k < path.length - 1) {
            int avant = 0, apres;

            for (int j = 0; j < NB_NAINS; j++)
                avant += info_nain(moi(), j).vie;
            if (miner(NB_NAINS - 1, path.datas[k+1]) == OK) {
                int apres = 0;

                for (int j = 0; j < NB_NAINS; j++)
                    apres += info_nain(moi(), j).vie;
                /* Si on a honteusement agressé des nains alliés */
                if (apres != avant)
                    annuler();
            }
            break;
        }
    }
    free(path.datas);
}

void partie_init(void){}
void partie_fin(void){}
