#ifndef MESS_INCLUDED
#define MESS_INCLUDED

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

#include "prologin.h"


/* ///////////////////////////////////////////////////////////////////////// */

typedef position                    P;
typedef echantillon                 E;
typedef position_echantillon        PE;
typedef position_echantillon_array  PE_A;

typedef struct {
  PE    x;
  P     p;
  int   score;
  bool  non_vide;
} S;

typedef struct {
  P     p;
  int   score, element; 
  bool  non_vide;
} T;

/* ///////////////////////////////////////////////////////////////////////// */

#define $P(x,y) ((P){.ligne=(x),.colonne=(y)})
#define $(x)    $P((x)/6,(x)%6)
#define $_      $(_)

#define $E(a,b)     ((E){.element1=(a),.element2=(b)})
#define $S(_x,_p,s) ((S){.x=(_x),.p=(_p),.score=(s),.non_vide=true})
#define $T(e,_p,s)  ((T){.p=(_p),.score=(s),.element=(e),.non_vide=true})

/* ///////////////////////////////////////////////////////////////////////// */

static inline int
valeur(P p, int u)
{
  switch (propriete_case_type(type_case(p, u))) {
    case TRANSMUTABLE_OR:
      return quantite_transmutation_or(taille_region(p, u));
    case TRANSMUTABLE_CATALYSEUR:
      return quantite_transmutation_catalyseur_or(taille_region(p, u));
    default:
      return 0;
  }
}

static inline int
max(int a, int b)
{
  return a > b ? a : b;
}

static inline int
potentiel(P p, int u)
{
  return max(valeur(p, u), 0);
}

/* ///////////////////////////////////////////////////////////////////////// */

#define THE_GAME  void  jouer_tour  (void)
                  void  partie_init (void)  {}
                  void  partie_fin  (void)  {}

#endif /* MESS_INCLUDED */
