#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "prologin.h"

#define Position(X,Y)	((position){.x = X, .y = Y})


/* Ordre de parcours tordu, en partant du centre */
static int base[LONGUEUR_BASE] = { 19, 18, 20, 17, 21, 16, 22, 15, 23, 14, 24, 13, 25 };

/* Sommes-nous le joueur horizontal ou vertical ? */
static bool horizontal;

/* Quelles sont les bases ayant une vue encombrée ? */
static bool vue_encombree[LONGUEUR_BASE] = {false};


void partie_init(void)
{
	horizontal = proprietaire_base(Position(0, 13)) == moi();

	for (int x = 13; x <= 25; x++)
		for (int y = 1; y < 38; y++)
		{
			bool resultat;

			if (horizontal)
				resultat = type_case(Position(y, x)) == PULSAR;
			else
				resultat = type_case(Position(x, y)) == PULSAR;

			/* En gros, on regarde s'il y a un obstacle */
			vue_encombree[x - 13] = vue_encombree[x - 13]
			    || resultat;
		}
}


void jouer_tour(void)
{
	/* On cherche les bases ayant une vue dégagée en partant du centre */
	for (int _ = 0; _ < LONGUEUR_BASE; _++)
	{
		int x = base[_];

		if (!vue_encombree[x - 13])
		{
		for (int i = 0; !cout_prochaine_modification_aspiration() && i < LONGUEUR_BASE; i++)
			if (vue_encombree[i])
			{
				if (horizontal)
				{
					if (deplacer_aspiration(Position(0, i +
						13), Position(0, x)) != OK)
					deplacer_aspiration(Position(38, i +
						13), Position(38, x));
				}
				else
				{
					if (deplacer_aspiration(Position(i + 13,
						0), Position(x, 0)) != OK)
					deplacer_aspiration(Position(i + 13,
						38), Position(x, 38));
				}
			}

			for (int y = 1; y < 38; y++)
			{
				if (horizontal)
					construire(Position(y, x));
				else
					construire(Position(x, y));
			}
		}
	}
}

void partie_fin(void)
{
}
