// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb

using System.Runtime.CompilerServices;

namespace Prologin {
// Erreurs possibles
	public enum Erreur {
		OK, // <- L'action a été exécutée avec succès.
		PA_INSUFFISANTS, // <- Vous ne possédez pas assez de points d'action pour cette action.
		AUCUN_TUYAU, // <- Il n'y a pas de tuyau à la position spécifiée.
		POSITION_INVALIDE, // <- La position spécifiée est hors de la carte.
		PUISSANCE_INSUFFISANTE, // <- Vous ne possédez pas assez de puissance d'asipration sur cette partie de la base.
		DEPLACEMENT_INVALIDE, // <- Vous ne pouvez pas déplacer de la puissance d'aspiration d'une case à elle-même.
		PAS_DANS_BASE, // <- Cette case n'appartient pas à votre base.
		AMELIORATION_IMPOSSIBLE, // <- Il y a déjà un Super Tuyau™ sur cette case.
		CONSTRUCTION_IMPOSSIBLE, // <- Il est impossible de construire un tuyau à la position indiquée.
		DESTRUCTION_IMPOSSIBLE, // <- Il n'y a pas de tuyau à la position spécifiée.
		PAS_DE_PULSAR, // <- Il n'y a pas de pulsar à la position spécifiée.
		PAS_DE_DEBRIS, // <- Il n'y a pas de débris à la position spécifiée.
		CHARGE_INSUFFISANTE, // <- Vous ne possédez pas assez de plasma pour lancer une destruction.
		LIMITE_ASPIRATION_ATTEINTE, // <- Vous avez atteint la limite d'aspiration sur cette case.
	}

// Types de cases
	public enum CaseType {
		VIDE, // <- Case vide
		TUYAU, // <- Case contenant un tuyau
		SUPER_TUYAU, // <- Case contenant un Super Tuyau™
		DEBRIS, // <- Case contenant des débris à déblayer
		PULSAR, // <- Case contenant un pulsar
		BASE, // <- Case appartenant à une base d'un des joueurs
		INTERDIT, // <- Case où aucune action n'est possible
	}

// Position sur la carte, donnée par deux coordonnées.
	class Position {
		public Position() {
		}
		public int X; // <- Coordonnée en X
		public int Y; // <- Coordonnée en Y
	}

// Représente un pulsar existant.
	class PulsarInfo {
		public PulsarInfo() {
		}
		public int Periode; // <- Période de pulsation du pulsar
		public double Puissance; // <- Quantité de plasma émise par chaque pulsation dans chaque direction
		public int PulsationsRestantes; // <- Nombre de pulsations restantes
		public int PulsationsTotales; // <- Nombre total de pulsations au début de la partie
	}

	class Api {
// Taille du terrain (longueur et largeur).
		public const int TAILLE_TERRAIN = 39;

// Longueur de chacune de vos deux bases.
		public const int LONGUEUR_BASE = 13;

// Nombre de tours à jouer avant la fin de la partie.
		public const int NB_TOURS = 100;

// Nombre de points d'action par tour.
		public const int NB_POINTS_ACTION = 4;

// Nombre de points d'action que coûte la construction d'un tuyau.
		public const int COUT_CONSTRUCTION = 1;

// Nombre de points d'action que coûte l'amélioration d'un tuyau.
		public const int COUT_AMELIORATION = 1;

// Nombre de points d'action que coûte la destruction d'un tuyau.
		public const int COUT_DESTRUCTION = 3;

// Nombre de points d'action que coûte la destruction d'un Super Tuyau™.
		public const int COUT_DESTRUCTION_SUPER_TUYAU = 4;

// Charge en plasma nécessaire pour la destruction d'un tuyau ou d'un Super Tuyau™.
		public const double CHARGE_DESTRUCTION = 2.0;

// Nombre de points d'action que coûte le déblayage d'une case de débris.
		public const int COUT_DEBLAYAGE = 2;

// Nombre de points d'action que coûte le déplacement d'une unité de puissance d'aspiration de la base (la première modification de chaque tour est offerte).
		public const int COUT_MODIFICATION_ASPIRATION = 1;

// Limite de puissance d'aspiration sur une case de base.
		public const int LIMITE_ASPIRATION = 5;

// Vitesse du plasma dans un tuyau normal, en nombre de cases par tour.
		public const int VITESSE_TUYAU = 1;

// Multiplicateur de la vitesse du plasma dans un Super Tuyau™.
		public const int MULTIPLICATEUR_VITESSE_SUPER_TUYAU = 2;

// Construit un tuyau sur une case donnée.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Construire(Position pos);

// Améliore un tuyau en Super Tuyau™.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Ameliorer(Position pos);

// Détruit un tuyau sur une case donnée.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Detruire(Position pos);

// Déplace une unité de puissance d'aspiration d'une case de votre base vers une autre.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur DeplacerAspiration(Position source, Position destination);

// Déblaye une case de débris.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Deblayer(Position pos);

// Renvoie le type d'une case donnée.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern CaseType TypeCase(Position pos);

// Renvoie la liste de tous les pulsars présents.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] ListePulsars();

// Renvoie la liste des cases contenant du plasma.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] ListePlasmas();

// Renvoie la liste des cases contenant un tuyau ou Super Tuyau™.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] ListeTuyaux();

// Renvoie la liste des cases contenant un Super Tuyau™.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] ListeSuperTuyaux();

// Renvoie la liste des cases contenant des débris.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] ListeDebris();

// Renvoie vrai si et seulement si la case contient un pulsar.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool EstPulsar(Position pos);

// Renvoie vrai si et seulement si la case contient un tuyau ou un Super Tuyau™.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool EstTuyau(Position pos);

// Renvoie vrai si et seulement si la case contient un simple tuyau.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool EstSimpleTuyau(Position pos);

// Renvoie vrai si et seulement si la case contient un Super Tuyau™.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool EstSuperTuyau(Position pos);

// Renvoie vrai si et seulement si la case contient un débris.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool EstDebris(Position pos);

// Renvoie vrai si et seulement s'il est possible de construire sur cette case.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool EstLibre(Position pos);

// Renvoie les informations propres au pulsar à la position donnée.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern PulsarInfo InfoPulsar(Position pos);

// Renvoie la quantité de plasma sur une case donnée.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern double ChargesPresentes(Position pos);

// Renvoie le numéro du joueur ayant dernièrement construit ou amélioré un tuyau sur une case.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int ConstructeurTuyau(Position pos);

// Renvoie le numéro du propriétaire d'une case de base.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int ProprietaireBase(Position pos);

// Renvoie la liste des cases composant votre base.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] MaBase();

// Renvoie la liste des cases composant la base de votre ennemi.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] BaseEnnemie();

// Renvoie la puissance d'aspiration d'une case de base donnée. Renvoie -1 si la position n'est pas celle d'une base.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int PuissanceAspiration(Position pos);

// Renvoie pour une case donnée la liste des cases vers lesquelles le plasma se propagera. Renvoie la liste vide si la case n'est pas une case contenant un tuyau ou si elle n'est reliée à aucune base.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] DirectionsPlasma(Position pos);

// Renvoie la valeur du coût de la prochaine modification de vos puissances d'aspiration.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int CoutProchaineModificationAspiration();

// Renvoie la liste des tuyaux construits par votre adversaire au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistTuyauxConstruits();

// Renvoie la liste des tuyaux détruits par votre adversaire au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistTuyauxDetruits();

// Renvoie la liste des tuyaux améliorés par votre adversaire au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistTuyauxAmeliores();

// Renvoie la liste des débris déblayés par votre adversaire au dernier tour.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistDebrisDeblayes();

// Renvoie la liste des cases de base de votre adversaire qui ont reçu un point d'aspiration (une même case peut apparaître plusieurs fois).
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistPointsAspirationAjoutes();

// Renvoie la liste des cases de base de votre adversaire qui ont perdu un point d'aspiration (une même case peut apparaître plusieurs fois).
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] HistPointsAspirationRetires();

// Renvoie votre numéro de joueur.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Moi();

// Renvoie le numéro de votre adversaire.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Adversaire();

// Indique votre nombre de points d'actions restants pour ce tour-ci.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int PointsAction();

// Renvoie le score du joueur désigné par le numéro ``id_joueur``. Renvoie -1 si ``id_joueur`` est invalide.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Score(int id_joueur);

// Renvoie le numéro du tour actuel.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int TourActuel();

// Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool Annuler();

// Affiche le contenu d'une valeur de type erreur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherErreur(Erreur v);

// Affiche le contenu d'une valeur de type case_type
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherCaseType(CaseType v);

// Affiche le contenu d'une valeur de type position
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPosition(Position v);

// Affiche le contenu d'une valeur de type pulsar_info
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPulsarInfo(PulsarInfo v);

	}
}
