#include "macros.h"



void partie_init(void)
{
	/*TODO: Annoncer la couleur du joueur */
}


void jouer_tour(void)
{
	int valeur[39][39] = {0};


	/* On commence par évaluer la distance des cases aux bases */
	INITIALISER_FILE();
	{
		POUR_CHAQUE_BASE(b)
		{
			/*TODO: Coefficienter ou 6 - puissance_aspiration(b) */
			valeur[$(b)] = 1;
			ENFILER(b);
		}

		/* On effectue un BFS pour calculer les valeurs minimales */
		while (!FILE_VIDE())
		{
			position p = DEFILER();

			POUR_CHAQUE_VOISIN(p, v)
				if (valeur[$(v)] == 0)
				{
					valeur[$(v)] = valeur[$(p)] + 1;
					ENFILER(v);
				}
		}
	}


	/*TODO: Relaxer les distances un nombre de fois arbitraire */


	/* ... puis on ajuste les valeurs de chaque case */
	POUR_CHAQUE_CASE(p)
	{
		/* Ce sont des cases inaccessibles */
		if (est_pulsar(p))
			valeur[$(p)] = +INFNTY;

		/* En fait, on va évaluer les cases « à l'envers » */
		valeur[$(p)] = -valeur[$(p)];

		/* Les cases adjacentes à des pulsars sont intéressantes */
		POUR_CHAQUE_VOISIN(p, v)
			if (est_pulsar(v))
			{
				pulsar_info pulsar = info_pulsar(v);

				/*TODO: Coefficienter */
				valeur[$(p)] += pulsar.pulsations_restantes * pulsar.puissance / pulsar.periode;
			}
	}


	/* Il y a 8 dynamiques différents à effectuer selon le sens */
	COPIER(valeur, meilleur);
	{
	}


	/*TODO: Automatiquement réajuster la puissance d'aspiration */

	for (int x = 0; x < 39; x++)
	{
		for (int y = 0; y < 39; y++)
			if (valeur[x][y] < -INFNTY / 2)
				printf(" . ");
			else	printf("%2ld ", valeur[x][y]);
		putchar('\n');
	}
	putchar('\n');
}


void partie_fin(void)
{
}
