/*
 * C'EST LA PIQUETTE, JACK !
 *
 * L'algorithme est simplissime: si l'ennemi est susceptible d'avoir un meilleur
 * score, alors j'essaye de capturer le portail le plus éloigné de lui qui lui
 * appartient. Sinon, je me dirige vers le portail qui forme le plus petit
 * angle par rapport à ma trajectoire, pour construire une enveloppe convexe
 * dégueulasse.
 *
 * Soit N le nombre de portails, la complexité de jouer_tour() est O(N log N).
 */
#include <algorithm>
#include <vector>

using namespace std;

#include "prologin.hh"

#define	agent	position_agent(moi())



/* J'emmerde le C++, bordel */
bool operator != (const position& a, const position& b) { return a.x != b.x || a.y != b.y; }
bool operator == (const position& a, const position& b) { return !(a != b);		   }

/*
 * Pour trier par angle, on fait un produit vectoriel.
 * Bah oui. C'est tout con.
 */
bool
par_angle(const position& a, const position& b)
{
	return (a.x - agent.x) * (b.y - agent.y) < (b.x - agent.x) * (a.y - agent.y);
}



static vector<position> portails;
static position cible;


/*
 * Permet "d'approcher" une position donnée: la fonction appelle
 * utiliser_turbo() automatiquement si besoin.
 */
static void
approcher(position p)
{
	const position delta[4] = {{0, -1}, {-1, 0}, {1, 0}, {0, 1}};

	while (agent != p && (points_deplacement() > 0 || utiliser_turbo() == OK))
		/*
		 * On regarde les cases autour de nous: si une nous rapproche
		 * de la position, on y va.
		 */
		for (int i = 0; i < 4; i++)
		{
			position suivant;

			suivant = agent;
			suivant.x += delta[i].x;
			suivant.y += delta[i].y;
			if (distance(suivant, p) < distance(agent, p)
			    && deplacer(suivant) == OK)
				break;
		}
}

/*
 * Puisque les fonctions de l'API gèrent très bien les fails, on aboutit à
 * cette fonction très simple capturant le potentiel portail sur lequel on est.
 */
static void
conquerir()
{
	neutraliser();

	if (capturer() == OK)
	{
		vector<position> voisins = portails;

		/*
		 * On trie par angle pour pouvoir faire un maximum de triangles
		 * à la fin.
		 */
		sort(voisins.begin(), voisins.end(), par_angle);
		for (position v : voisins)
			lier(v);
	}

	while (ajouter_bouclier() == OK)
		;
}



void
partie_init()
{
	portails = liste_portails();
	cible = agent;
}

void
jouer_tour()
{
	/* Au cas où on commence sur un portail. */
	conquerir();

	/* 
	 * On répète la chose 6 fois, puisqu'on peut faire plus ou moins
	 * 6 actions "principales" en un tour.
	 */
	for (int pas = 0; pas < 6; pas++)
	{
		/* Si je n'ai plus de cible */
		if (cible == agent)
		{
			/* Si je suis tranquille au niveau du score, */
			if (score(moi()) >= score(adversaire()) * 2)
			{
				vector<position> voisins = portails;

				/*
				 * chercher le portail d'angle minimal par
				 * rapport à notre direction.
				 */
				sort(voisins.begin(), voisins.end(), par_angle);
				for (position v : voisins)
					if (portail_joueur(v) != moi() && v != agent)
						cible = v;
			}
			else
			{
				int maximum = 0;

				/*
				 * S'il est en train de nous défoncer, chercher
				 * le portail qui lui appartient le plus
				 * éloigné de lui, histoire de faire chier.
				 */
				for (position p : portails)
					if (portail_joueur(p) == adversaire() && p != agent)
					{
						int score;

						score = distance(position_agent(adversaire()), p);
						if (score >= maximum)
						{
							maximum = score;
							cible = p;
						}
					}
			}
		}


		position suivant = cible;

		/*
		 * Ce bout de code permet de trouver des portails
		 * intermédiaires qui n'allongent pas la durée du trajet
		 * nécessaire. Enfin je crois.
		 *
		 * Parmi tous ceux disponibles, on prend le plus proche.
		 */
		for (position p : portails)
			if (distance(agent, p) + distance(p, cible) == distance(agent, cible)
			    && distance(agent, p) <= distance(agent, suivant)
			    && portail_joueur(p) == adversaire())
				suivant = p;

		/* Amen & Attack */
		approcher(suivant);
		conquerir();
	}
}

void
partie_fin()
{
	/*
	 * Ouais.
	 * Pour la firme.
	 *
	 * Vous avez perdu.
	 */
	if (score(moi()) > score(adversaire()))
		puts("THE GAME");
}

