#include <algorithm>
#include <vector>

using namespace std;

#include "prologin.hh"

#define agent	position_agent(moi())


bool operator != (const position& a, const position& b) { return a.x != b.x || a.y != b.y; }
bool operator == (const position& a, const position& b) { return !(a != b);		   }

bool
par_angle(const position& a, const position& b)
{
	return (a.x - agent.x) * (b.y - agent.y) < (b.x - agent.x) * (a.y - agent.y);
}



static vector<position> portails;
static position cible;


static void
approcher(position p)
{
	const position delta[4] = {{0, -1}, {-1, 0}, {1, 0}, {0, 1}};

	while (agent != p && (points_deplacement() > 0 || utiliser_turbo() == OK))
		for (int i = 0; i < 4; i++)
		{
			position suivant;

			suivant = agent;
			suivant.x += delta[i].x;
			suivant.y += delta[i].y;
			if (distance(suivant, p) < distance(agent, p)
			    && deplacer(suivant) == OK)
				break;
		}
}

static void
conquerir()
{
	neutraliser();

	if (capturer() == OK)
	{
		vector<position> voisins = portails;

		sort(voisins.begin(), voisins.end(), par_angle);
		for (position v : voisins)
			lier(v);
	}

	while (ajouter_bouclier() == OK)
		;
}



void
partie_init()
{
	portails = liste_portails();
	cible = agent;
}

void
jouer_tour()
{
	conquerir();

	for (int i = 0; i < 4; i++)
	{
		if (cible == agent)
		{
			int maximum = 0;

			for (position p : portails)
				if (portail_joueur(p) != moi() && p != agent)
				{
					int score;

					score = liens_incidents_portail(p).size();
					if (score >= maximum)
					{
						maximum = score;
						cible = p;
					}
				}
		}


		position suivant = cible;
		int maximum = 0;

		for (position p : portails)
		{
			int score;

			score = liens_incidents_portail(p).size();
			if (distance(agent, p) + distance(p, cible) == distance(agent, cible)
			    && distance(agent, p) <= 8
			    && portail_joueur(p) != moi()
			    && score >= maximum)
			{
				maximum = score;
				suivant = p;
			}
		}

		approcher(suivant);
		conquerir();
	}
}

void
partie_fin()
{
}

