///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_caml.rb
//

#include <vector>
#include <string>
///
// Information sur les cases
//
typedef enum case_info {
  CASE_SIMPLE, /* <- Case simple */
  CASE_TOURELLE, /* <- Tourelle */
  CASE_BASE, /* <- Base du joueur */
  CASE_FONTAINE, /* <- Fontaine magique */
  CASE_ARTEFACT, /* <- Artefact magique */
  CASE_ERREUR, /* <- Erreur */
} case_info;


///
// Erreurs possibles
//
typedef enum erreur {
  OK, /* <- L'action s'est effectuée avec succès */
  ANNULER_IMPOSSIBLE, /* <- Aucune action à annuler */
  CASE_IMPOSSIBLE, /* <- Cette case n'existe pas */
  CASE_ADVERSE, /* <- Vous ne contrôlez pas cette case */
  CASE_UTILISEE, /* <- Cette case n'est pas libre */
  CASE_VIDE, /* <- Cette case est vide */
  VALEUR_INVALIDE, /* <- Cette valeur est invalide */
  MAGIE_INSUFFISANTE, /* <- Vous n'avez pas assez de magie */
  SORCIERS_INSUFFISANTS, /* <- Vous n'avez pas assez de sorciers */
  ATTAQUE_INSUFFISANTE, /* <- Vous n'avez pas assez de points d'attaque */
  PHASE_INCORRECTE, /* <- Cette action ne peut pas être utilisée lors de cette phase du jeu. */
  PORTEE_INSUFFISANTE, /* <- Vous n'avez pas assez de portée pour effectuer cette action */
  PERDANT, /* <- Vous avez perdu et ne pouvez pas effectuer d'actions */
} erreur;


///
// Représente la position sur la carte
//
typedef struct position {
  int x;  /* <- Coordonnée en X */
  int y;  /* <- Coordonnée en Y */
} position;


///
// Représente une tourelle
//
typedef struct tourelle {
  position pos;  /* <- Position de la tourelle */
  int portee;  /* <- Portée de la tourelle */
  int joueur;  /* <- Joueur qui possède la tourelle */
  int vie;  /* <- Nombre de points de vie de la tourelle */
  int attaque;  /* <- Nombre de points d'attaque de la tourelle */
} tourelle;


///
// Retourne le type de la case à l'emplacement `pos`
//
extern "C" case_info api_info_case(position pos);

///
// Retourne la liste des tourelles qui appartiennent au joueur ``joueur``
//
extern "C" std::vector<tourelle> api_tourelles_joueur(int joueur);

///
// Retourne la magie que possède le joueur ``joueur``
//
extern "C" int api_magie(int joueur);

///
// Retourne le nombre de sorciers du joueur ``joueur`` sur la case ``pos``
//
extern "C" int api_nb_sorciers(position pos, int joueur);

///
// Retourne le nombre de sorciers du joueur ``joueur`` déplacables sur la case ``pos``
//
extern "C" int api_nb_sorciers_deplacables(position pos, int joueur);

///
// Retourne le numéro du joueur qui contrôle la case ``pos``
//
extern "C" int api_joueur_case(position pos);

///
// Retourne la tourelle située sur la case ``pos``
//
extern "C" tourelle api_tourelle_case(position pos);

///
// Retourne la position de la base du joueur ``joueur``
//
extern "C" position api_base_joueur(int joueur);

///
// Retourne vrai si l'on peut construire sur la case ``pos``
//
extern "C" bool api_constructible(position pos, int joueur);

///
// Retourne la liste des positions constituant le plus court chemin allant de la case ``pos1`` à la case ``pos2``. Attention : Cette fonction est lente.
//
extern "C" std::vector<position> api_chemin(position pos1, position pos2);

///
// Construire une tourelle à la position ``pos``
//
extern "C" erreur api_construire(position pos, int portee);

///
// Supprimer une tourelle à la position ``pos``
//
extern "C" erreur api_supprimer(position pos);

///
// Tirer avec ``pts`` points de dégats depuis la tourelles ``tourelle`` sur la position ``cible``
//
extern "C" erreur api_tirer(int pts, position tourelle, position cible);

///
// Créer ``nb`` sorciers dans la base
//
extern "C" erreur api_creer(int nb);

///
// Déplace ``nb`` sorciers de la position ``depart`` jusqu'à la position ``arrivee``.
//
extern "C" erreur api_deplacer(position depart, position arrivee, int nb);

///
// Attaquer la tourelle à la position ``cible`` depuis la position ``pos``
//
extern "C" erreur api_assieger(position pos, position cible, int nb_sorciers);

///
// Retourne le numéro de votre joueur
//
extern "C" int api_moi();

///
// Retourne la liste des numéros de vos adversaires
//
extern "C" std::vector<int> api_adversaires();

///
// Retourne le numéro du tour actuel
//
extern "C" int api_tour_actuel();

///
// Retourne la distance entre deux positions
//
extern "C" int api_distance(position depart, position arrivee);

///
// Annule la dernière action
//
extern "C" erreur api_annuler();

///
// Affiche le contenu d'une valeur de type case_info
//
extern "C" void api_afficher_case_info(case_info v);

///
// Affiche le contenu d'une valeur de type erreur
//
extern "C" void api_afficher_erreur(erreur v);

///
// Affiche le contenu d'une valeur de type position
//
extern "C" void api_afficher_position(position v);

///
// Affiche le contenu d'une valeur de type tourelle
//
extern "C" void api_afficher_tourelle(tourelle v);

///
// Fonction appelée au début de la partie
//
extern "C" void partie_debut();

///
// Fonction appelée pendant la phase de construction
//
extern "C" void phase_construction();

///
// Fonction appelée pendant la phase de déplacement
//
extern "C" void phase_deplacement();

///
// Fonction appelée pendant la phase de tirs des tourelles
//
extern "C" void phase_tirs();

///
// Fonction appelée pendant la phase de siège des tourelles
//
extern "C" void phase_siege();

///
// Fonction appelée à la fin de la partie
//
extern "C" void partie_fin();

