#include <cstdlib>
#include <algorithm>
#include <vector>
#include "api.hh"
#include "alea.hh"
#include "misc.hh"

using namespace std;


vector<Position> objectifs;

void Debut()
{
    srand(time(0) ^ (SEED * SEED));
    
    for (int x = 0; x < TAILLE_TERRAIN; x++)
    {
        for (int y = 0; y < TAILLE_TERRAIN; y++)
        {
            int type = Case(x, y);
            
            if (type == CASE_FONTAINE || type == CASE_ARTEFACT 
            || (type == CASE_BASE && x != Base(ID).x && y != Base(ID).y))
                objectifs.push_back((Position) {x, y});
        }
    }
    sort(objectifs.begin(), objectifs.end());
}

void Construction()
{
    vector<Tourelle> tourelles = Liste_Tourelles(ID);
    
    if (tourelles.empty())
    {
        vector<Position> alentours = Alentours(Base(ID), PORTEE_CONSTRUCTION - 1);
        vector<Position> eligible;
        
        for (int index = 0; index < alentours.size(); index++)
            if (Constructible(alentours[index]))
                eligible.push_back(alentours[index]);
        if (eligible.empty())
        {
            Creer_Sorciers(MAGIE / COUT_SORCIER);
        }
        else
        {
            int portee, index = Aleatoire(0, eligible.size() - 1);
            
            for (portee = PORTEE_TOURELLE; 
                 COUT_AMELIORATION(portee+1) <= MAGIE; portee++);
            Creer_Tourelle(eligible[index], portee); 
        }
    }
    else
    {
        int choix = Bernouilli(3. / 5, 2. / 5);
        
        if (choix)
        {
            Creer_Sorciers(MAGIE / COUT_SORCIER);
        }
        else
        {
            vector<Evenement> possibles;
            Position base = Base(ID);
            double total = 0;
            
            for (int index = 0; index < tourelles.size(); index++)
            {
                possibles.push_back(Evenement(index,
                    (double) Distance_Carre(tourelles[index].pos, base)
                           * Distance_Carre(tourelles[index].pos,
                             Plus_Proche(objectifs, tourelles[index].pos))));
                total += possibles.back().probabilite;
            }
            for (int index = 0; index < tourelles.size(); index++)
                possibles[index].probabilite /= total;
            while (MAGIE >= COUT_TOURELLE)
            {
                int nouvelle = Choisir(possibles);
                vector<Position> alentours = Alentours(tourelles[nouvelle].pos, 
                                                       PORTEE_CONSTRUCTION);
                vector<Position> eligible;
                Position pos = tourelles[nouvelle].pos;

                for (int index = 0; index < alentours.size(); index++)
                    if (Constructible(alentours[index]))
                        eligible.push_back(alentours[index]);
                if (eligible.empty())
                {
                    Creer_Sorciers(MAGIE / COUT_SORCIER);
                }
                else
                {
                    Position position = eligible[Aleatoire(0, eligible.size() - 1)];
                    Creer_Tourelle(position, PORTEE_CONSTRUCTION);

                    vector<Position> voisins = Alentours(position, 1);
                    for (int index = 0; index < voisins.size(); index++)
                        Detruire_Tourelle(voisins[index]);
                }
            }
            Creer_Sorciers(MAGIE / COUT_SORCIER);
        }
    }
}

void Deplacement()
{
}

void Tirs()
{
}

void Siege()
{
}

void Fin()
{
}

