<?php
/*
 * Taille du terrain (longueur et largeur)
 */
define('TAILLE_TERRAIN', 31);

/*
 * Nombre de joueurs dans la partie
 */
define('NB_JOUEURS', 4);

/*
 * Nombre maximum de tours à jouer avant la fin de la partie
 */
define('MAX_TOUR', 100);

/*
 * Magie gagnée à chaque tour
 */
define('MAGIE_TOUR', 20);

/*
 * Magie gagnée à chaque tour pour chaque fontaine possédée
 */
define('MAGIE_FONTAINES', 15);

/*
 * Magie gagnée à chaque sorcier tué
 */
define('MAGIE_COMBAT', 1);

/*
 * Magie récupérée à chaque tourelle supprimée
 */
define('MAGIE_SUPPRESSION', 10);

/*
 * Nombre de points de magie par sorcier
 */
define('COUT_SORCIER', 2);

/*
 * Nombre de points de magie par tourelle
 */
define('COUT_TOURELLE', 20);

/*
 * Coût exponentiel pour chaque case de portée supplémentaire
 */
define('COUT_PORTEE', 4);

/*
 * Nombre maximum de cases qu'un sorcier peut franchir à chaque tour.
 */
define('PORTEE_SORCIER', 4);

/*
 * Portée de base d'une tourelle
 */
define('PORTEE_TOURELLE', 3);

/*
 * Portée de construction des tourelles
 */
define('CONSTRUCTION_TOURELLE', 3);

/*
 * Points de vie d'une tourelle à sa création
 */
define('VIE_TOURELLE', 10);

/*
 * Points d'attaque d'une tourelle au début d'un tour
 */
define('ATTAQUE_TOURELLE', 10);

/*
 * Points gagnés pour avoir survécu à la fin de la partie
 */
define('POINTS_SURVIVRE', 1);

/*
 * Points gagnés pour avoir vaincu un adversaire
 */
define('POINTS_VAINQUEUR', 1);

/*
 * Points gagnés pour contrôler une fontaine à la fin de la partie
 */
define('POINTS_CONTROLE_FONTAINE', 1);

/*
 * Points gagnés pour contrôler un artefact à la fin de la partie
 */
define('POINTS_CONTROLE_ARTEFACT', 4);

/*
 * Information sur les cases
 */
define('CASE_SIMPLE', 0); // Case simple
define('CASE_TOURELLE', 1); // Tourelle
define('CASE_BASE', 2); // Base du joueur
define('CASE_FONTAINE', 3); // Fontaine magique
define('CASE_ARTEFACT', 4); // Artefact magique
define('CASE_ERREUR', 5); // Erreur

/*
 * Erreurs possibles
 */
define('OK', 0); // L'action s'est effectuée avec succès
define('ANNULER_IMPOSSIBLE', 1); // Aucune action à annuler
define('CASE_IMPOSSIBLE', 2); // Cette case n'existe pas
define('CASE_ADVERSE', 3); // Vous ne contrôlez pas cette case
define('CASE_UTILISEE', 4); // Cette case n'est pas libre
define('CASE_VIDE', 5); // Cette case est vide
define('VALEUR_INVALIDE', 6); // Cette valeur est invalide
define('MAGIE_INSUFFISANTE', 7); // Vous n'avez pas assez de magie
define('SORCIERS_INSUFFISANTS', 8); // Vous n'avez pas assez de sorciers
define('ATTAQUE_INSUFFISANTE', 9); // Vous n'avez pas assez de points d'attaque
define('PHASE_INCORRECTE', 10); // Cette action ne peut pas être utilisée lors de cette phase du jeu.
define('PORTEE_INSUFFISANTE', 11); // Vous n'avez pas assez de portée pour effectuer cette action
define('PERDANT', 12); // Vous avez perdu et ne pouvez pas effectuer d'actions

?>
