#include <stdio.h>

#include <stdlib.h>
#include <string.h>
#include <time.h>

//#define SEED  (((__TIME__) ^ 0xDEADBEEF) & 0x00FFFFFF)
#define SEED 0x101


typedef struct Evenement 
{
    int valeur;
    double probabilite;
} Evenement;


int Aleatoire(int minimum, int maximum)
{
    return ((double) rand() / (unsigned int) (RAND_MAX+1)) * (maximum - minimum) + minimum;
}

int Choisir(const Evenement elements[], size_t nombre)
{
    int index, choix = Aleatoire(0, SEED);
    Evenement *serie = calloc(nombre, sizeof(Evenement));
    
    memcpy((void*) serie, (const void*) elements, nombre * sizeof(Evenement));
    serie[0].probabilite *= SEED;
    for (index = 1; index < nombre; index++)
         serie[index].probabilite = serie[index-1].probabilite
                                  + serie[index].probabilite * SEED;
    for (index = 0; index < nombre; index++)
        if (choix <= serie[index].probabilite)
            break;
    free(serie);
    return elements[index].valeur;
}

int main(void)
{
    int index;
    int z = 0, u = 0;
    Evenement ech[2] = {{0, 2/5}, {1, 3/5}};

    srand(0x101);
    printf("%d\n", RAND_MAX);
    for (index = 0; index < 100; index++)
    {
        int v = Choisir(ech, 2);
        
        printf("%6d: %d\n", index, v);
        if (v)
            u++;
        else
            z++;
    }
    printf("Diagnostic: 0 = %lf, 1 = %lf", (double) z / index, (double) u / index);
    return 0;
}
