#include "alea.hh"


int Aleatoire(int min, int max)
{
    return ((double) rand() / RAND_MAX) * (max - min) + min;
}

int Bernouilli(double a, double b)
{
    int choix = Aleatoire(0, SEED);
    
    return (choix <= (a * SEED)) ? 0 : 1;
}

int Choisir(vector<Evenement> serie)
{
    int choix = Aleatoire(0, SEED);
    vector<Evenement> cumul = serie;
    
    cumul[0].probabilite *= SEED;
    for (size_t index = 1; index < cumul.size(); index++)
        cumul[index].probabilite = cumul[index].probabilite * SEED 
                                 + cumul[index-1].probabilite;
    for (size_t index = 0; index < cumul.size(); index++)
        if (choix <= cumul[index].probabilite)
            return cumul[index].valeur;
    return cumul.back().valeur;
}
