#ifndef API_INCLUDED
#define API_INCLUDED
#include "prologin.hh"

#define Debut         partie_debut
#define Construction  phase_construction
#define Deplacement   phase_deplacement
#define Tirs          phase_tirs
#define Siege         phase_siege
#define Fin           partie_fin

#define JOUEURS              NB_JOUEURS
#define PORTEE_CONSTRUCTION  CONSTRUCTION_TOURELLE

#define TOURELLES_MAX        9
#define PORTEE_MAX           7
#define ECHEANCE_FIN         8
#define LIMITE_OBJECTIF      3

#define Case(x, y)                        info_case((Position) {x, y})
#define Liste_Tourelles(id)               tourelles_joueur(id)
#define Magie(id)                         magie(id)
#define Sorciers_Places(position, id)     nb_sorciers(position, id)
#define Tourelle_Placee(position)         tourelle_case(position)
#define Base(id)                          base_joueur(id)
#define Constructible(position)           constructible(position, ID)
#define Creer_Tourelle(position, portee)  construire(position, portee)
#define Detruire_Tourelle(position)       supprimer(position)
#define Tirer(origine, cible, nombre)     tirer(nombre, origine, cible)
#define Creer_Sorciers(nombre)            creer(nombre)
#define Migrer(origine, cible, nombre)    deplacer(origine, cible, nombre)
#define Attaquer(origine, cible, nombre)  assieger(origine, cible, nombre)
#define Adversaires()                     adversaires()


#define ID      moi()
#define TOUR    tour_actuel()
#define MAGIE   Magie(ID)

#define COUT_AMELIORATION(portee)  (COUT_TOURELLE + COUT_PORTEE \
                                                  + (portee) * (portee))
                                                  

typedef position Position;
typedef tourelle Tourelle;


#endif /* API_INCLUDED */
