#include "alea.h"


int Aleatoire(int minimum, int maximum)
{
    return ((double) rand() / (RAND_MAX+1)) * (maximum - minimum) + minimum;
}

int Choisir(const Evenement elements[], size_t nombre)
{
    int index, choix = Aleatoire(0, SEED);
    Evenement *serie = calloc(nombre, sizeof(Evenement));
    
    memcpy((void*) serie, (const void*) elements, nombre * sizeof(Evenement));
    serie[0].probabilite *= SEED;
    for (index = 1; index < nombre; index++)
         serie[index].probabilite = serie[index-1].probabilite
                                  + serie[index].probabilite * SEED;
    for (index = 0; index < nombre; index++)
        if (choix <= serie[index].probabilite)
            break;
    free(serie);
    return elements[index].valeur;
}
