(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

(*
** Taille du terrain (longueur et largeur)
*)
let taille_terrain = 31

(*
** Nombre de joueurs dans la partie
*)
let nb_joueurs = 4

(*
** Nombre maximum de tours à jouer avant la fin de la partie
*)
let max_tour = 100

(*
** Magie gagnée à chaque tour
*)
let magie_tour = 20

(*
** Magie gagnée à chaque tour pour chaque fontaine possédée
*)
let magie_fontaines = 15

(*
** Magie gagnée à chaque sorcier tué
*)
let magie_combat = 1

(*
** Magie récupérée à chaque tourelle supprimée
*)
let magie_suppression = 10

(*
** Nombre de points de magie par sorcier
*)
let cout_sorcier = 2

(*
** Nombre de points de magie par tourelle
*)
let cout_tourelle = 20

(*
** Coût exponentiel pour chaque case de portée supplémentaire
*)
let cout_portee = 4

(*
** Nombre maximum de cases qu'un sorcier peut franchir à chaque tour.
*)
let portee_sorcier = 4

(*
** Portée de base d'une tourelle
*)
let portee_tourelle = 3

(*
** Portée de construction des tourelles
*)
let construction_tourelle = 3

(*
** Points de vie d'une tourelle à sa création
*)
let vie_tourelle = 10

(*
** Points d'attaque d'une tourelle au début d'un tour
*)
let attaque_tourelle = 10

(*
** Points gagnés pour avoir survécu à la fin de la partie
*)
let points_survivre = 1

(*
** Points gagnés pour avoir vaincu un adversaire
*)
let points_vainqueur = 1

(*
** Points gagnés pour contrôler une fontaine à la fin de la partie
*)
let points_controle_fontaine = 1

(*
** Points gagnés pour contrôler un artefact à la fin de la partie
*)
let points_controle_artefact = 4

(*
** Information sur les cases
*)
type case_info =
| Case_simple (* <- Case simple *)
| Case_tourelle (* <- Tourelle *)
| Case_base (* <- Base du joueur *)
| Case_fontaine (* <- Fontaine magique *)
| Case_artefact (* <- Artefact magique *)
| Case_erreur (* <- Erreur *)


(*
** Erreurs possibles
*)
type erreur =
| Ok (* <- L'action s'est effectuée avec succès *)
| Annuler_impossible (* <- Aucune action à annuler *)
| Case_impossible (* <- Cette case n'existe pas *)
| Case_adverse (* <- Vous ne contrôlez pas cette case *)
| Case_utilisee (* <- Cette case n'est pas libre *)
| Case_vide (* <- Cette case est vide *)
| Valeur_invalide (* <- Cette valeur est invalide *)
| Magie_insuffisante (* <- Vous n'avez pas assez de magie *)
| Sorciers_insuffisants (* <- Vous n'avez pas assez de sorciers *)
| Attaque_insuffisante (* <- Vous n'avez pas assez de points d'attaque *)
| Phase_incorrecte (* <- Cette action ne peut pas être utilisée lors de cette phase du jeu. *)
| Portee_insuffisante (* <- Vous n'avez pas assez de portée pour effectuer cette action *)
| Perdant (* <- Vous avez perdu et ne pouvez pas effectuer d'actions *)


(*
** Représente la position sur la carte
*)
type position = (int * int)

(*
** Représente une tourelle
*)
type tourelle = {
  pos : position ; (* <- Position de la tourelle *)
  portee : int ; (* <- Portée de la tourelle *)
  joueur : int ; (* <- Joueur qui possède la tourelle *)
  vie : int ; (* <- Nombre de points de vie de la tourelle *)
  attaque : int ; (* <- Nombre de points d'attaque de la tourelle *)
}

(*
** Retourne le type de la case à l'emplacement `pos`
*)
external info_case : position -> case_info = "ml_info_case"
(*
** Retourne la liste des tourelles qui appartiennent au joueur ``joueur``
*)
external tourelles_joueur : int -> tourelle array = "ml_tourelles_joueur"
(*
** Retourne la magie que possède le joueur ``joueur``
*)
external magie : int -> int = "ml_magie"
(*
** Retourne le nombre de sorciers du joueur ``joueur`` sur la case ``pos``
*)
external nb_sorciers : position -> int -> int = "ml_nb_sorciers"
(*
** Retourne le nombre de sorciers du joueur ``joueur`` déplacables sur la case ``pos``
*)
external nb_sorciers_deplacables : position -> int -> int = "ml_nb_sorciers_deplacables"
(*
** Retourne le numéro du joueur qui contrôle la case ``pos``
*)
external joueur_case : position -> int = "ml_joueur_case"
(*
** Retourne la tourelle située sur la case ``pos``
*)
external tourelle_case : position -> tourelle = "ml_tourelle_case"
(*
** Retourne la position de la base du joueur ``joueur``
*)
external base_joueur : int -> position = "ml_base_joueur"
(*
** Retourne vrai si l'on peut construire sur la case ``pos``
*)
external constructible : position -> int -> bool = "ml_constructible"
(*
** Retourne la liste des positions constituant le plus court chemin allant de la case ``pos1`` à la case ``pos2``. Attention : Cette fonction est lente.
*)
external chemin : position -> position -> position array = "ml_chemin"
(*
** Construire une tourelle à la position ``pos``
*)
external construire : position -> int -> erreur = "ml_construire"
(*
** Supprimer une tourelle à la position ``pos``
*)
external supprimer : position -> erreur = "ml_supprimer"
(*
** Tirer avec ``pts`` points de dégats depuis la tourelles ``tourelle`` sur la position ``cible``
*)
external tirer : int -> position -> position -> erreur = "ml_tirer"
(*
** Créer ``nb`` sorciers dans la base
*)
external creer : int -> erreur = "ml_creer"
(*
** Déplace ``nb`` sorciers de la position ``depart`` jusqu'à la position ``arrivee``.
*)
external deplacer : position -> position -> int -> erreur = "ml_deplacer"
(*
** Attaquer la tourelle à la position ``cible`` depuis la position ``pos``
*)
external assieger : position -> position -> int -> erreur = "ml_assieger"
(*
** Retourne le numéro de votre joueur
*)
external moi : unit -> int = "ml_moi"
(*
** Retourne la liste des numéros de vos adversaires
*)
external adversaires : unit -> int array = "ml_adversaires"
(*
** Retourne le numéro du tour actuel
*)
external tour_actuel : unit -> int = "ml_tour_actuel"
(*
** Retourne la distance entre deux positions
*)
external distance : position -> position -> int = "ml_distance"
(*
** Annule la dernière action
*)
external annuler : unit -> erreur = "ml_annuler"
(*
** Affiche le contenu d'une valeur de type case_info
*)
external afficher_case_info : case_info -> unit = "ml_afficher_case_info"
(*
** Affiche le contenu d'une valeur de type erreur
*)
external afficher_erreur : erreur -> unit = "ml_afficher_erreur"
(*
** Affiche le contenu d'une valeur de type position
*)
external afficher_position : position -> unit = "ml_afficher_position"
(*
** Affiche le contenu d'une valeur de type tourelle
*)
external afficher_tourelle : tourelle -> unit = "ml_afficher_tourelle"
