from api import *
from heapq import heapify, heappop, heappush
import itertools as it
from time import time
from sys import stderr

LIBRE = 0
J1 = 1
J2 = 2
MUR = 3
# ALIEN = 4

# Les déplacements :
MARCHE = 0
GLISSE = 1
POUSSE = 2
PROTEGE = 3

PTS_ACTION = [1, 3, 5]

# ACTIVER LA PROTECTION ANTI TIMEOUT
TEMPS = {"debut": -1, "max": 0.8, "timedout": False}

# Les données partagées des dijkstras
distances_moi = {}
distances_pousse = {}
dirfroms = {}
deplfroms = {}
comefroms = {}

agents_sur_aliens = []
def reinit_agents_aliens():
    global agents_sur_aliens
    agents_sur_aliens = []

def reinit_dijkstra_infos():
    global distances_moi
    global distances_pousse
    global dirfroms
    global deplfroms
    global comefroms
    distances_moi = {}
    distances_pousse = {}
    dirfroms = {}
    deplfroms = {}
    comefroms = {}

def timed(f):
    def my_f(*args, **kwargs):
        if time() > TEMPS["debut"] + TEMPS["max"]:
            print("--TIMEDOUT--", file=stderr)
            TEMPS["timedout"] = True
            raise TimeoutException

        return f(*args, **kwargs)

    return my_f

class TimeoutException(Exception):
    pass

# Les constantes pour mes heuristiques :
constantes = {"a": 0.9, "b": 4, "c": 0.95, "d": 0.6,
              "protec2": 4, "protec1": 1.2}

tuple_to_dir = {(-1, 0): direction.NORD,
                (1, 0): direction.SUD,
                (0, 1): direction.EST,
                (0, -1): direction.OUEST}
all_dirs = [(0, 1), (1, 0), (-1, 0), (0, -1)]

def get_board_description():
    """On renvoie une description customisée du plateau."""
    board = [[0] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]
    for i in range(TAILLE_BANQUISE):
        for j in range(TAILLE_BANQUISE):
            if type_case((i, j)) == case_type.MUR:
                board[i][j] = MUR
            elif agent_sur_case((i, j)) == -1:
                board[i][j] = LIBRE
            elif agent_sur_case((i, j)) == 1:
                board[i][j] = J1
            else:
                assert(agent_sur_case((i, j)) == 2)
                board[i][j] = J2

    return board

def my_depl(agent, dir, board):
    x, y = position_agent(moi(), agent)
    board[x][y] = LIBRE
    err = deplacer(agent, tuple_to_dir[dir])
    x, y = position_agent(moi(), agent)
    board[x][y] = moi()

    return err

def my_glisse(agent, dir, board):
    x, y = position_agent(moi(), agent)
    board[x][y] = LIBRE
    err = glisser(agent, tuple_to_dir[dir])
    x, y = position_agent(moi(), agent)
    board[x][y] = moi()

    return err

def agent_numero(joueur, case):
    for i in range(NB_AGENTS):
        if position_agent(joueur, i) == case:
            return i

def my_pousse(agent, dir, board):
    dx, dy = dir
    x1, y1 = position_agent(moi(), agent)
    x2, y2 = x1+dx, y1+dy

    # debug
    ennemi = agent_numero(adversaire(), (x2, y2))
    err = pousser(agent, tuple_to_dir[dir])
    x3, y3 = position_agent(adversaire(), ennemi)
    board[x2][y2] = LIBRE
    board[x3][y3] = adversaire()

    return err

def get_neigh(pos):
    (x, y) = pos
    for (dx, dy) in all_dirs:
        nx, ny = x+dx, y+dy
        if 0 <= nx < TAILLE_BANQUISE and 0 <= ny < TAILLE_BANQUISE:
            yield (dx, dy), (nx, ny)

def glissade(pos, dir, board):
    """Essaie de faire une glissade depuis pos, dans la direction dir
    (un tuple). Renvoie la case d'arrivée."""
    x, y = pos
    dx, dy = dir
    nb_cases = 0
    while 1:
        nx, ny = x+dx, y+dy
        if 0 <= nx < TAILLE_BANQUISE and 0 <= ny < TAILLE_BANQUISE and \
           board[nx][ny] == LIBRE:
            x, y = nx, ny
            nb_cases += 1
            continue
        return nb_cases, (x, y)

def reconstitue_chemin(agent, pos2):
    pos1 = position_agent(moi(), agent)
    deplfrom = deplfroms[agent]
    dirfrom = dirfroms[agent]
    comefrom = comefroms[agent]
    if pos1 != pos2 and dirfrom[pos2[0]][pos2[1]] is None:
        return None
    liste = []
    while pos2 != pos1:
        x, y = pos2
        liste.append((deplfrom[x][y], dirfrom[x][y]))
        pos2 = comefrom[x][y]

    liste.reverse()
    return liste

@timed
def dijkstra(agent, board):
    pos1 = position_agent(moi(), agent)
    # print(f"dijkstra : {agent} en position {pos1}")
    pts_init = NB_POINTS_ACTION - points_action_agent(agent)
    visite = [[False] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]

    all_dists = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]
    pousse_dists = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]
    comefrom = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]
    deplfrom = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]
    dirfrom = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]

    my_heap = [((0, pts_init), pos1, None, None, None)]

    while my_heap != []:
        dist, pos, source, depl, dir = heappop(my_heap)

        x, y = pos
        if visite[x][y]:
            continue
        visite[x][y] = True
        comefrom[x][y] = source
        deplfrom[x][y] = depl
        dirfrom[x][y] = dir
        if depl == POUSSE:
            pousse_dists[x][y] = dist
        else:
            all_dists[x][y] = dist

        for dir, (nx, ny) in get_neigh(pos):
            if board[nx][ny] == adversaire() and \
               poussable(pos, (nx, ny), board):
                ndist = next_turn(*dist, 5)
                heappush(my_heap,
                         (ndist, (nx, ny), pos, POUSSE, dir))
            if board[nx][ny] != LIBRE:
                continue
            ndist = next_turn(*dist, 1)
            heappush(my_heap,
                     (ndist, (nx, ny), pos, MARCHE, dir))

        for dir in all_dirs:
            dx, dy = dir
            nb_cases, dest =  glissade(pos, dir, board)
            if nb_cases <= 1:
                continue
            ndist = next_turn(*dist, 3)
            heappush(my_heap,
                     (ndist, dest, pos, GLISSE, dir))

    distances_moi[agent] = all_dists
    distances_pousse[agent] = pousse_dists
    dirfroms[agent] = dirfrom
    deplfroms[agent] = deplfrom
    comefroms[agent] = comefrom

@timed
def dijkstra_allarache(pos1, target, max_dist, board):
    # print(f"dijkstra : {agent} en position {pos1}")
    visite = [[False] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]

    all_dists = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]
    comefrom = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]
    deplfrom = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]
    dirfrom = [[None] * TAILLE_BANQUISE for _ in range(TAILLE_BANQUISE)]

    my_heap = [(0, pos1, None, None, None)]

    while my_heap != []:
        dist, pos, source, depl, dir = heappop(my_heap)
        if dist > max_dist:
            continue

        x, y = pos
        if visite[x][y]:
            continue

        if poussable(pos, target, board):
            return (comefrom, deplfrom, dirfrom)

        visite[x][y] = True
        comefrom[x][y] = source
        deplfrom[x][y] = depl
        dirfrom[x][y] = dir
        all_dists[x][y] = dist

        for dir, (nx, ny) in get_neigh(pos):
            if board[nx][ny] != LIBRE:
                continue
            ndist = dist + 1
            heappush(my_heap,
                     (ndist, (nx, ny), pos, MARCHE, dir))

        for dir in all_dirs:
            dx, dy = dir
            nb_cases, dest =  glissade(pos, dir, board)
            if nb_cases <= 1:
                continue
            ndist = dist + 3
            heappush(my_heap,
                     (ndist, dest, pos, GLISSE, dir))

    return None

def est_protege(pos, dir):
    x, y = pos
    dx, dy = dir
    next = x+dx, y+dy
    return type_case(next) != case_type.LIBRE

def protection(pos):
    p = 0
    if est_protege(pos, (1, 0)) or est_protege(pos, (-1, 0)):
        p += 1
    if est_protege(pos, (0, 1)) or est_protege(pos, (0, -1)):
        p += 1
    return p

def next_turn(turn, act, incr):
    if act + incr <= NB_POINTS_ACTION:
        return (turn, act + incr)
    return (turn + 1, incr)

def pos_diff(x1, x2, y1, y2):
    return x2 - x1, y2 - y1

def poussable(pos1, pos2, board):
    """On regarde si on peut pousser le manchot en pos2 depuis la pos1."""
    x1, y1 = pos1
    x2, y2 = pos2
    dx, dy = x2 - x1, y2 - y1
    if abs(dx) + abs(dy) != 1:
        return False

    # On a besoin que cette case à une distance 1 soit libre
    x3, y3 = x2 + dx, y2 + dy
    return 0 <= x3 < TAILLE_BANQUISE and 0 <= y3 < TAILLE_BANQUISE and \
           board[x3][y3] == LIBRE

def est_atteignable(a, mes_agents, board):
    # pour chaque alien, on regarde qui de l'adversaire ou du joueur peut
    # l'atteindre en premier.
    # if a.tour_invasion + a.duree_invasion < tour_actuel() + NB_TOURS_CAPTURE:
    #    return None

    if a.capture_en_cours == NB_TOURS_CAPTURE:
        return None
    x, y = a.pos

    tour_1 = 1000
    agent_1 = None
    pousse_1 = False
    for agent in mes_agents:
        pos = position_agent(moi(), agent)
        res = distances_moi[agent][x][y]
        if pos == a.pos:
            t = -a.capture_en_cours
            pousse = False
        else:
            r1 = distances_moi[agent][x][y]
            r2 = distances_pousse[agent][x][y]
            if r1 is not None:
                t, _ = r1
                pousse = False
            elif r2 is not None:
                t, _ = r2
                pousse = True
            else:
                continue

        if (not pousse) and t > (a.tour_invasion + a.duree_invasion -
            tour_actuel() - NB_TOURS_CAPTURE):
            continue
        t = max(t, a.tour_invasion - tour_actuel())
        if t < tour_1:
            tour_1 = t
            agent_1 = agent
            pousse_1 = pousse

    if tour_1 == 1000:
        return None

    return tour_1, agent_1, pousse_1

def heuristique(valeurs):
    (nb_tours, agent, pousse), alien = valeurs

    if alien.points_capture <= 0:
        return -1000
    if pousse:
        #return -1000
        tours_avant_depart = (alien.duree_invasion + alien.tour_invasion -
                                tour_actuel() - 2)
        tours_avant_prise = max(alien.tour_invasion + 3 - tour_actuel(),
                                 3 - alien.capture_en_cours)
        if tours_avant_prise <= nb_tours:
            return -1000

        res = constantes["b"] * alien.points_capture * \
                (constantes["c"] ** tours_avant_depart) * \
                (constantes["a"] ** tours_avant_prise) * \
                (constantes["d"] ** nb_tours)

    else:
        res = alien.points_capture * (constantes["a"] ** nb_tours)

    if protection(alien.pos) == 2:
        res *= constantes["protec2"]

    elif protection(alien.pos) == 1:
        res *= constantes["protec1"]

    return res

def est_attaquable(agent, board):
    target = position_agent(moi(), agent)
    for a in range(4):
        pos_a = position_agent(adversaire(), a)
        if dijkstra_allarache(pos_a, target, 3, board) is not None:
            return True

    return False

def est_protegeable(agent, allie, board):
    target = position_agent(moi(), agent)
    pos_allie = position_agent(moi(), allie)
    d = dijkstra_allarache(pos_allie, target, points_action_agent(allie),
                           board)
    if d is not None:
        print(f"l'agent {allie} fera l'affaire")
        return d

    return None

def meilleur_cible(aliens, mes_agents, board):
    global distances_moi
    global distances_pousse
    global comefroms
    global deplfroms
    global dirfroms

    atteignables = []

    #distance_moi = {}
    #distances_pousse = {}
    #comefroms = {}
    #dirfroms = {}
    #deplfroms = {}
    for agent in mes_agents:
        # pos = position_agent(moi(), agent)
        # distance_moi[agent] = dijkstra_atteinte(pos, board,
        #                                         points_action_agent(agent))
        # distances_pousse[agent] = dijkstra_pousse(pos, board,
        #                                           points_action_agent(agent))
        if TEMPS["timedout"]:
            break
        try:
            dijkstra(agent, board)
        except TimeoutException:
            break


    for a in aliens:
        t = est_atteignable(a, mes_agents, board)
        if t is not None:
            atteignables.append((t, a))

    for agent_1 in agents_sur_aliens:
        pos_1 = position_agent(moi(), agent_1)
        if protection(pos_1) != 1 or not est_attaquable(agent_1, board):
            continue
        print(f"l'agent {agent_1} est attaquable")
        for allie in mes_agents:
            if allie == agent_1:
                continue

            if est_protegeable(agent_1, allie, board):
                atteignables.append((0, ))

    if atteignables == []:
        return None

    m = max(atteignables, key=heuristique)
    if heuristique(m) == -1000:
        return None
    return m

def follow_path(agent, path, board):
    for depl, dir in path:
        if points_action_agent(agent) < PTS_ACTION[depl]:
            # print(f"Je suis l'agent {agent}, il me reste {points_action_agent(agent)} "
            #       f"points d'action, je ne peux pas effectuer l'action {depl}")
            return False

        if depl == MARCHE:
            diditwork = my_depl(agent, dir, board)
        elif depl == GLISSE:
            diditwork = my_glisse(agent, dir, board)
        else:
            diditwork = my_pousse(agent, dir, board)

        if diditwork != erreur.OK:
            print("Échec")
            return False

    if path == [] or depl != POUSSE:
        agents_sur_aliens.append(agent)
        print(f"l'agent {agent} est sur un alien")

    return True
