from api import *

from random import choice
from collections import Counter

tous_les_elements = range(1, 6)

def positions_adjacentes(pos):
    """Itère sur les cases adjacentes à une position."""
    x, y = pos
    for (dx, dy) in [(0, 1), (0, -1), (1, 0), (-1, 0)]:
        nx, ny = x+dx, y+dy
        if 0 <= nx < 6 and 0 <= ny < 6:
            yield (nx, ny)

def est_vide(position, id_apprenti):
    return type_case(position, id_apprenti) == case_type.VIDE

def libertes(pos, id_apprenti):
    """Renvoie le nombre de cases vides adjactentes."""
    return len([p for p in positions_adjacentes(pos)
                if est_vide(p, id_apprenti)])

def est_isolee(position, id_apprenti):
    """On définit une position isolée comme une position vide dont toutes
    les cases adjacentes sont remplies. Il faut faire attention à ce genre de
    case sur laquelle on ne peut pas placer d'échantillon."""
    for adj in positions_adjacentes(position):
        if est_vide(adj, id_apprenti):
            return False
    return True

def transmutable_or(position, id_apprenti):
    return propriete_case(position, id_apprenti) == \
           element_propriete.TRANSMUTABLE_OR

def get_plateau(id_apprenti):
    """Renvoie tous les types des cases du plateau sous la forme d'un
    tableau bidimensionnel 6*6."""
    return [[type_case((x, y), id_apprenti) for y in range(6)]
            for x in range(6)]

def regions(id_apprenti):
    """Renvoie la liste des régions et des informations à propos."""
    explore = [[False] * 6 for _ in range(6)]
    regions = []
    for x in range(6):
        for y in range(6):
            if est_vide((x, y), id_apprenti) or explore[x][y]:
                continue
            infos = {}
            infos['case'] = (x, y)
            infos['libertes'] = set() #l'ensemble des cases avec libres
                                      #non isolées adjacentes à la région.
            cases = positions_region((x, y), id_apprenti)
            taille_region = len(cases)
            infos['taille'] = taille_region
            if transmutable_or((x, y), id_apprenti):
                infos['or'] = quantite_transmutation_or(taille_region)
                infos['catalyseur'] = 0
            else:
                infos['or'] = \
                    quantite_transmutation_catalyseur_or(taille_region)
                infos['catalyseur'] = \
                    quantite_transmutation_catalyseur(taille_region)
            for (i, j) in cases:
                explore[i][j] = True
                for adj in positions_adjacentes((i, j)):
                    if est_vide(adj, id_apprenti) and \
                       (not est_isolee(adj, id_apprenti)):
                        infos['libertes'].add(adj)

            regions.append(infos)
    
    return regions

def heuristique0(id_apprenti):
    """Renvoie la quanité d'or obtenue si on transmute toutes les régions
    composées de plus d'une case."""
    res = 0
    for region in regions(id_apprenti):
        res += max(region['or'], 0)
    return res

def heuristique1(pos_echantillon):
    echantillon = echantillon_tour()
    res = 0
    for i in range(2):
        for adj in positions_adjacentes(pos_echantillon[i]):
            if est_vide(adj, moi()):
                pass
##                if libertes(adj, moi()) == 1:
                    #on essaie de ne pas créer de case isolée.
##                    res -= 10
            elif type_case(adj, moi()) == echantillon[i]:
                res += 10
            else:
                res -= 10

    return res

def heuristique2(id_apprenti):
    res = 0
    les_regions = regions(id_apprenti)
    res -= 10 * len(les_regions)
    for r in les_regions:
        res += r['taille'] ** 2
        if r['taille'] == 1 and len(r['libertes']) <= 4:
            res -= 10
##        elif r['taille'] == 2 and r['libertes'] == set():
##            res -= 5
    for x in range(6):

        for y in range(6):
            if est_vide((x, y), id_apprenti) and \
               est_isolee((x, y), id_apprenti):
                res -= 20

    return res

def centre(pos_echant):
    """Une heuristique qui est grande lorsque la position de l'échantillon
    est au centre."""
    def manhattan(pos):
        """Une sorte de distance de manhattan d'une position du plateau à la
        bordure."""
        x, y = pos
        return min(x, 5 - x) + min(y, 5 - y)
    return manhattan(pos_echant[0]) + manhattan(pos_echant[1])

def nb_elements(id_apprenti):
    """Dénombre les éléments présents sur le plateau d'un apprenti."""
    c = Counter()
    for ligne in get_plateau(id_apprenti):
        for elem in ligne:
            c[elem] += 1

    return c

def singletons(id_apprenti):
    return [r['case'] for r in regions(id_apprenti) if r['taille'] == 1]

def elem_adjacents(pos, id_apprenti):
    """Renvoie les éléments adajacents à pos."""
    elements = set()
    for adj in positions_adjacentes(pos):
        if not est_vide(adj, id_apprenti):
            elements.add(type_case(adj, moi()))

    return elements

class Historique:
    """Une classe permettant de stocker des informations sur l'historique.
    """
    LIMITE_ZONE = 5
    LIMITE_TEMPS = 3
    def __init__(self):
        self.zone_presente = []
        self.zone_transmutee = []
        self.nb_recordings = 0
    
    def nouveau_tour(self):
        self.transmutee_tour = False

    def transmute(self, region):
        self.transmutee_tour |= region['taille'] >= self.LIMITE_ZONE

    def fin_tour(self):
        self.zone_transmutee.append(self.transmutee_tour)
        b = (max([region['taille'] for region in regions(moi())]) >=
             self.LIMITE_ZONE)
        self.zone_presente.append(b)
        self.nb_recordings += 1

    def bloque(self):
        """On dit qu'on est bloqué s'il existe des régions de taille
        supérieure à la limite depuis un nombre de tour supérieur à la
        limite et qu'aucune de ces zones n'est transmutée."""
        return (self.nb_recordings >= self.LIMITE_TEMPS and \
            all(self.zone_presente[-self.LIMITE_TEMPS:]) and \
            all([not b for b in self.zone_transmutee[-self.LIMITE_TEMPS:]]))


def transmutable(region):
    return (len(region['libertes']) == 0 and region['taille'] > 1) or \
           (len(region['libertes']) == 1 and region['taille'] >= 5)
#Les fonctions effectuant des actions :
def transmute(mon_historique):
    #on liste les régions avec aucune liberté et plus d'une case.
    l = []
    for region in regions(moi()):
        if transmutable(region):
            l.append(region)

    if l == []:
        #on attend qu'il y ait une région sans liberté avant de la transmuter.
        return False

    region = max(l, key=lambda r: (r['or'], r['catalyseur']))
    transmuter(region['case'])
    mon_historique.transmute(region)

    return True

def transmute_plus_grande_region(mon_historique):
    mes_regions = regions(moi())
    region = max(mes_regions, key=lambda r: r['taille'])
    assert region['taille'] > 1
    transmuter(region['case'])
    mon_historique.transmute(region)

def utilise_catalyseur():
    """On va catalyser tous les singletons tant qu'il en reste et que l'on
    possède des catalyseurs."""
    if nombre_catalyseurs() == 0:
        pass

    s = [(pos, elem) for pos in singletons(moi())
                     for elem in elem_adjacents(pos, moi())]
    def eval(arg):
        pos, elem = arg
        assert catalyser(pos, moi(), elem) == erreur.OK
        r = heuristique2(moi())
        annuler()
        return r

    while s != [] and nombre_catalyseurs() > 0:
        pos, elem = max(s, key=eval)
        assert catalyser(pos, moi(), elem) == erreur.OK
        print('catalyse')
        s = [(pos, elem) for pos in singletons(moi())
                         for elem in elem_adjacents(pos, moi())]

    if nombre_catalyseurs() > 0:
        print("pas catalyse")


def libere_echantillon():
    """Procédure d'urgence : s'il n'y a aucune place pour placer l'échantillon
    suivant, on libère la plus grande région jusqu'à qu'on puisse placer
    l'échantillon."""
    print("PROCÉDURE D'URGENCE LANCÉE.")
    while placements_possible_echantillon(echantillon_tour(), moi()) == []:
        region = max(regions(moi()), key=lambda r: r['taille'])
        transmuter(region['case'])
    print("PROCÉDURE D'URGENCE ACHEVÉE AVEC SUCCÈS.")
    
def place_premier_tour():
    """Place l'échantillon au centre pour le premier tour."""
    
def place_echantillon():
    echantillon = echantillon_tour()
    possible = placements_possible_echantillon(echantillon, moi())
    if possible == []:
        libere_echantillon()
        possible = placements_possible_echantillon(echantillon, moi())

    def eval(pos_echantillon):
        h = heuristique1(pos_echantillon)
        placer_echantillon(*pos_echantillon)
        h += heuristique2(moi())
        annuler()
        return h

    possible.sort(key=lambda p:(eval(p), centre(p)))
    choix = choice(possible[-3:])
    placer_echantillon(*choix)

def envoie_echantillon():
    """Choisis et envoie un échantillon à l'adversaire.
    On choisit l'échantillon tel que les deux éléments soient les moins
    présents chez l'adversaire. On évite également de donner un doublon
    à l'adversaire."""
    echantillon = echantillon_tour()
    elements_adv = nb_elements(adversaire())
    #On choisit l'élément de l'échantillon actuel le moins présent chez
    #l'adversaire.
    elem_1 = min(echantillon, key=lambda e:elements_adv[e])
    #On choisit maintenant l'élément (non forcément dans l'échantillon)
    #le moins présent chez l'adversaire différent de elem_1.
    elem_2 = min([e for e in tous_les_elements if e != elem_1],
                 key=lambda e:elements_adv[e])
    donner_echantillon((elem_1, elem_2))
