// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

// Types de cases
enum CaseType {
  VIDE, // <- Case vide
  PLOMB, // <- Plomb ; transmutable en or
  FER, // <- Fer ; transmutable en or
  CUIVRE, // <- Cuivre ; transmutable en or
  SOUFRE, // <- Soufre ; transmutable en catalyseur
  MERCURE, // <- Mercure ; transmutable en catalyseur
}

// Types de propriétés des éléments
enum ElementPropriete {
  AUCUNE, // <- Les cases vides ne contiennent pas d’élément, et n’ont donc aucune propriété
  TRANSMUTABLE_OR, // <- Élement transmutable en or
  TRANSMUTABLE_CATALYSEUR, // <- Élément transmutable en catalyseur
}

// Erreurs possibles
enum Erreur {
  OK, // <- L’action a été exécutée avec succès
  POSITION_INVALIDE, // <- La position spécifiée n’est pas sur l’établi
  PLACEMENT_INVALIDE, // <- Les deux positions ne correspondent pas à des cases adjacentes
  PLACEMENT_IMPOSSIBLE, // <- Les cases ciblées ne sont pas vides
  PLACEMENT_INCORRECT, // <- Un des deux éléments de l'échantillon doit être placé adjacent à un élément du même type déjà présent sur l'établi
  CASE_VIDE, // <- La case ciblée est vide
  ECHANTILLON_INCOMPLET, // <- L’échantillon doit contenir deux éléments.
  ECHANTILLON_INVALIDE, // <- L’échantillon doit contenir au moins un des éléments de l’échantillon reçu auparavant
  AUCUN_CATALYSEUR, // <- Aucun catalyseur disponible
  CATALYSE_INVALIDE, // <- L'élément de destination ne peut pas être vide.
  DEJA_POSE, // <- L’échantillon a déjà été posé ce tour-ci
  DEJA_DONNE, // <- L’échantillon a déjà été donné ce tour-ci
}

// Types d’actions
enum ActionType {
  ACTION_PLACER, // <- Action ``placer_echantillon``
  ACTION_TRANSMUTER, // <- Action ``transmuter``
  ACTION_CATALYSER, // <- Action ``catalyser``
  ACTION_DONNER_ECHANTILLON, // <- Action ``donner_echantillon``
}

// Position sur la carte, donnée par deux coordonnées
class Position {
  public int ligne; // Coordonnée : ligne
  public int colonne; // Coordonnée : colonne
}

// Échantillon, défini par deux types d’éléments
class Echantillon {
  public CaseType element1; // Élément 1
  public CaseType element2; // Élément 2
}

// Position d’un échantillon, donnée par deux positions adjacentes
class PositionEchantillon {
  public Position pos1 = new Position(); // Position de l’élément 1 de l’échantillon
  public Position pos2 = new Position(); // Position de l’élément 2 de l’échantillon
}

// Action représentée dans l’historique. L’action ``placer_echantillon`` utilise ``pos1`` et ``pos2``. L’action ``transmuter`` utilise ``pos1``. L’action ``catalyser`` utilise ``pos1``, ``id_apprenti`` et ``nouvelle_case``. L’action ``donner_echantillon`` n’est pas représentée dans l’historique, car ``echantillon_tour`` donne l’information.
class ActionHist {
  public ActionType atype; // Type de l’action
  public Position pos1 = new Position(); // Position, pour les actions placer (1er élément), transmuter et catalyser
  public Position pos2 = new Position(); // Position, pour l’action placer (2e élément)
  public int id_apprenti; // ID de l’apprenti, pour l’action catalyser
  public CaseType nouvelle_case; // Élément pour l’action catalyser
}

public class Interface
{
  // Taille de l’établi de travail (longueur et largeur)
  public static final int TAILLE_ETABLI = 6;

  // Nombre de tours à jouer avant la fin de l’affrontement
  public static final int NB_TOURS = 150;

  // Taille de l’énumération ``case_type``
  public static final int NB_TYPE_CASES = 6;

// Place l’échantillon du tour sur l’établi, avec les coordonnées de deux cases adjacentes.
  public static native Erreur placer_echantillon(Position pos1, Position pos2);

// Provoque la transformation chimique de l’élément à la case ciblée, ainsi que tous les éléments adjacents du même type, ceux du même type adjacents à ces derniers, etc. Ils disparaissent alors tous dans leur transmutation en or ou en catalyseur.
  public static native Erreur transmuter(Position pos);

// Utilise un catalyseur sur la case ciblée de l'apprenti indiqué. Transforme l’ancien élément en l’élément indiqué.
  public static native Erreur catalyser(Position pos, int id_apprenti, CaseType terrain);

// Définit l’échantillon que l’adversaire recevra à son prochain tour.
  public static native Erreur donner_echantillon(Echantillon echantillon_donne);

// Renvoie le type d’une case donnée, ou 0 si la case est invaide.
  public static native CaseType type_case(Position pos, int id_apprenti);

// Indique si une case donnée est vide ou contient un élément. Renvoie faux en cas d'erreur.
  public static native boolean est_vide(Position pos, int id_apprenti);

// Renvoie la propriété de l’élément sur une case donnée. Un élément invalide n'a pas de propriété.
  public static native ElementPropriete propriete_case(Position pos, int id_apprenti);

// Renvoie la propriété d’un type de case donné.
  public static native ElementPropriete propriete_case_type(CaseType ctype);

// Renvoie la taille de la région à laquelle appartient un élément. Renvoie -1 si la position est invalide.
  public static native int taille_region(Position pos, int id_apprenti);

// Renvoie la liste des positions des cases composant la région à laquelle appartient un élément donné. Renvoie une liste vide en cas d'erreur.
  public static native Position[] positions_region(Position pos, int id_apprenti);

// Détermine si le placement d’un échantillon est valide.
  public static native boolean placement_possible_echantillon(Echantillon echantillon_a_placer, Position pos1, Position pos2, int id_apprenti);

// Renvoie la liste des placements possibles pour un échantillon donné sur l’établi d’un apprenti donné. Renvoie une liste vide en cas d'erreur.
  public static native PositionEchantillon[] placements_possible_echantillon(Echantillon echantillon_a_placer, int id_apprenti);

// Renvoie la liste des actions jouées par l’adversaire pendant son tour, dans l’ordre chronologique.
  public static native ActionHist[] historique();

// Renvoie votre numéro d’apprenti.
  public static native int moi();

// Renvoie le numéro d’apprenti de votre adversaire.
  public static native int adversaire();

// Renvoie la quantité d’or amassée par l’apprenti désigné par le numéro ``id_apprenti``. Renvoie 0 si ``id_apprenti`` est invalide (attention, le score d’un apprenti valide peut aussi être 0).
  public static native int score(int id_apprenti);

// Renvoie le numéro du tour actuel.
  public static native int tour_actuel();

// Annule la dernière action. Renvoie ``false`` quand il n’y a pas d’action à annuler ce tour-ci.
  public static native boolean annuler();

// Indique le nombre de catalyseurs en votre possession.
  public static native int nombre_catalyseurs();

// Indique l’échantillon reçu pour ce tour.
  public static native Echantillon echantillon_tour();

// Indique si l’échantillon reçu pour ce tour a déjà été posé.
  public static native boolean a_pose_echantillon();

// Indique si un échantillon a déjà été donné ce tour.
  public static native boolean a_donne_echantillon();

// Renvoie la quantité d’or (et donc le score) obtenue par la transmutation de ``taille_region`` éléments transmutables en or.
  public static native int quantite_transmutation_or(int taille_region);

// Renvoie la quantité de catalyseurs obtenue par la transmutation de ``taille_region`` éléments transmutables en catalyseur.
  public static native int quantite_transmutation_catalyseur(int taille_region);

// Renvoie la quantité d’or obtenue par la transmutation de ``taille_region`` éléments transmutables en catalyseur.
  public static native int quantite_transmutation_catalyseur_or(int taille_region);

// Indique l’échantillon par défaut lors du premier tour
  public static native Echantillon echantillon_defaut_premier_tour();

// Affiche l'état actuel des deux établis dans la console.
  public static native void afficher_etablis();

// Affiche le contenu d'une valeur de type case_type
  public static native void afficher_case_type(CaseType v);

// Affiche le contenu d'une valeur de type element_propriete
  public static native void afficher_element_propriete(ElementPropriete v);

// Affiche le contenu d'une valeur de type erreur
  public static native void afficher_erreur(Erreur v);

// Affiche le contenu d'une valeur de type action_type
  public static native void afficher_action_type(ActionType v);

// Affiche le contenu d'une valeur de type position
  public static native void afficher_position(Position v);

// Affiche le contenu d'une valeur de type echantillon
  public static native void afficher_echantillon(Echantillon v);

// Affiche le contenu d'une valeur de type position_echantillon
  public static native void afficher_position_echantillon(PositionEchantillon v);

// Affiche le contenu d'une valeur de type action_hist
  public static native void afficher_action_hist(ActionHist v);

}
