from api import *

from random import random
from collections import Counter
from itertools import product

tous_les_elements = range(1, 6)
elements_catalysables = [4, 5]

def choice(a, p=None):
    """Effectue un choix parmi une liste.
    Si un argument p est donné : effectue un choix pondéré."""
    if p is None:
        p = [1] * len(a)
    p = [x / sum(p) for x in p]
    x = random()
    i = 0
    s = p[0]
    while s < x: 
        i += 1
        s += p[i]
    return a[i]

def positions_adjacentes(pos):
    """Itère sur les cases adjacentes à une position."""
    x, y = pos
    for (dx, dy) in [(0, 1), (0, -1), (1, 0), (-1, 0)]:
        nx, ny = x+dx, y+dy
        if 0 <= nx < 6 and 0 <= ny < 6:
            yield (nx, ny)

def est_vide(position, id_apprenti):
    """Renvoie True si la position est vide."""
    return type_case(position, id_apprenti) == case_type.VIDE

def libertes(pos, id_apprenti):
    """Renvoie le nombre de cases vides adjactentes."""
    return len([p for p in positions_adjacentes(pos)
                if est_vide(p, id_apprenti)])

def est_isolee(position, id_apprenti):
    """On définit une position isolée comme une position vide dont toutes
    les cases adjacentes sont remplies. Il faut faire attention à ce genre de
    case sur laquelle on ne peut pas placer d'échantillon."""
    for adj in positions_adjacentes(position):
        if est_vide(adj, id_apprenti):
            return False
    return True

def transmutable_or(position, id_apprenti):
    return propriete_case(position, id_apprenti) == \
           element_propriete.TRANSMUTABLE_OR

def get_plateau(id_apprenti):
    """Renvoie tous les types des cases du plateau sous la forme d'un
    tableau bidimensionnel 6*6."""
    return [[type_case((x, y), id_apprenti) for y in range(6)]
            for x in range(6)]

def regions(id_apprenti):
    """Renvoie la liste des régions et des informations à propos."""
    explore = [[False] * 6 for _ in range(6)]
    regions = []
    for x in range(6):
        for y in range(6):
            if est_vide((x, y), id_apprenti) or explore[x][y]:
                continue
            infos = {}
            infos['case'] = (x, y)
            infos['element'] = type_case((x, y), id_apprenti)
            infos['libertes'] = set() #l'ensemble des cases avec libres
                                      #non isolées adjacentes à la région.
            cases = positions_region((x, y), id_apprenti)
            infos['liste cases'] = cases
            taille_region = len(cases)
            infos['taille'] = taille_region
            if transmutable_or((x, y), id_apprenti):
                infos['or'] = quantite_transmutation_or(taille_region)
                infos['catalyseur'] = 0
            else:
                infos['or'] = \
                    quantite_transmutation_catalyseur_or(taille_region)
                infos['catalyseur'] = \
                    quantite_transmutation_catalyseur(taille_region)
            for (i, j) in cases:
                explore[i][j] = True
                for adj in positions_adjacentes((i, j)):
                    if est_vide(adj, id_apprenti) and \
                       (not est_isolee(adj, id_apprenti)):
                        infos['libertes'].add(adj)

            regions.append(infos)
    
    return regions

def heuristique1(pos_echantillon):
    echantillon = echantillon_tour()
    res = 0
    for i in range(2):
        for adj in positions_adjacentes(pos_echantillon[i]):
            if est_vide(adj, moi()):
                pass
##                if libertes(adj, moi()) == 1:
                    #on essaie de ne pas créer de case isolée.
##                    res -= 10
            elif type_case(adj, moi()) == echantillon[i]:
                res += 10
            else:
                res -= 10

    return res

def heuristique2(id_apprenti):
    """La somme des carrés des tailles des régions."""
    res = 0
    les_regions = regions(id_apprenti)
    res -= 10 * len(les_regions)
    for r in les_regions:
        res += r['taille'] ** 2
        if r['taille'] == 1 and len(r['libertes']) <= 4:
            res -= 10
##        elif r['taille'] == 2 and r['libertes'] == set():
##            res -= 5
    for x in range(6):

        for y in range(6):
            if est_vide((x, y), id_apprenti) and \
               est_isolee((x, y), id_apprenti):
                res -= 20

    return res

def distance_case(case_1, case_2):
    return abs(case_1[0] - case_2[0]) + abs(case_1[1] - case_2[1])

def distance_region(region1, region2):
    """Renvoie la distance minimal entre deux cases de la région,
    et la liste des couples (c1, c2) de cases minimisant cette distance.
    """
    d = min([distance_case(c1, c2) for (c1, c2) in
             product(region1['liste cases'], region2['liste cases'])])
    couples = [(c1, c2) for (c1, c2)
                in product(region1['liste cases'], region2['liste cases'])
                if distance_case(c1, c2) == d]
    return (d, couples)

def catalysation_possible(id_apprenti):
    les_regions = regions(id_apprenti)
    regions_soufre = [r for r in les_regions if r['element'] == 4]
    regions_mercure = [r for r in les_regions if r['element'] == 5]
    #on recherche s'il existe une région d'au moins 3 cases de cuivre
    #ou de mercure :
    regions_catalysables = []
    regions_presque_catalysables = []
    paires_regions = []
    for r in regions_soufre + regions_mercure:
        if r['taille'] >= 3:
            regions_catalysables.append(r)
        elif r['taille'] == 2:
            regions_presque_catalysables.append(r)
    
    zones_catalysables = {}
    for rs in [regions_soufre, regions_mercure]:
        #on parcourt chaque pair de région une unique fois :
        for i in range(len(rs)):
            for j in range(i, len(rs)):
                r1, r2 = rs[i], rs[j]
                if distance_region(r1, r2) == 2:
                    paires_regions.append((r1, r2))
    
    return (regions_catalysables, regions_presque_catalysables,
            paires_regions)


def centre(pos_echant):
    """Une heuristique qui est grande lorsque la position de l'échantillon
    est au centre."""
    def manhattan(pos):
        """Une sorte de distance de manhattan d'une position du plateau à la
        bordure."""
        x, y = pos
        return min(x, 5 - x) + min(y, 5 - y)
    return manhattan(pos_echant[0]) + manhattan(pos_echant[1])

def nb_elements(id_apprenti):
    """Dénombre les éléments présents sur le plateau d'un apprenti."""
    c = Counter()
    for ligne in get_plateau(id_apprenti):
        for elem in ligne:
            c[elem] += 1

    return c

def singletons(id_apprenti):
    return [r['case'] for r in regions(id_apprenti) if r['taille'] == 1]

def elem_adjacents(pos, id_apprenti):
    """Renvoie les éléments adajacents à pos."""
    elements = set()
    for adj in positions_adjacentes(pos):
        if not est_vide(adj, id_apprenti):
            elements.add(type_case(adj, moi()))

    return elements

class Historique:
    """Une classe permettant de stocker des informations sur l'historique.
    """
    LIMITE = 12
    def __init__(self):
        self.regions = []
        self.nb_recordings = 0
    
    def nouveau_tour(self):
        pass

    def transmute(self, region):
        #self.transmutee_tour |= region['taille'] >= self.LIMITE_ZONE
        pass

    def fin_tour(self):
        new_val = []

        mes_regions = regions(moi())
        for (k, r0) in self.regions:
            present = False
            for r1 in mes_regions:
                if set(r0['liste cases']) == set(r1['liste cases']):
                    present = True
                    break


            if present:
                new_val.append((k+1, r1))
                mes_regions.remove(r1)

        self.regions = new_val + [(1, r) for r in mes_regions]

    def bloquees(self):
        """On dit qu'on est bloqué s'il existe des régions de taille
        supérieure à la limite depuis un nombre de tour supérieur à la
        limite et qu'aucune de ces zones n'est transmutée."""
        return [r for (k, r) in self.regions if k >= self.LIMITE]


def transmutable(region):
    return (len(region['libertes']) == 0 and region['taille'] > 1) or \
           (len(region['libertes']) == 1 and region['taille'] >= 5)


def transmutable(region):
    return (len(region['libertes']) == 0 and region['taille'] > 1) or \
           (len(region['libertes']) == 1 and region['taille'] >= 5)
#Les fonctions effectuant des actions :
def transmute():
    #on liste les régions avec aucune liberté et plus d'une case.
    l = []
    for region in regions(moi()):
        if transmutable(region):
            l.append(region)

    if l == []:
        #on attend qu'il y ait une région sans liberté avant de la transmuter.
        return False

    region = max(l, key=lambda r: (r['or'], r['catalyseur']))
    transmuter(region['case'])

    return True

def transmute_plus_grande_region():
    mes_regions = regions(moi())
    region = max(mes_regions, key=lambda r: r['taille'])
    assert region['taille'] > 1
    transmuter(region['case'])

def repare():
    """On va catalyser tous les singletons tant qu'il en reste et que l'on
    possède des catalyseurs."""

    s = [(pos, elem) for pos in singletons(moi())
                     for elem in elem_adjacents(pos, moi())]
    def eval(arg):
        pos, elem = arg
        assert catalyser(pos, moi(), elem) == erreur.OK
        r = heuristique2(moi())
        annuler()
        return r

    pos, elem = max(s, key=eval)
    assert catalyser(pos, moi(), elem) == erreur.OK
    print('réparation')

def attaque():
    les_regions = regions(adversaire())
    m = max([r['taille'] for r in les_regions])
    #on prend une région de taille maximale :
    region = choice([r for r in les_regions if r['taille'] == m])
    saccage_region(region)
    print('saccage')

def detruit_catalyseur(regions):
    print("détruit catalyseur")
    r = choice(regions)
    saccage_region(r)

def utilise_un_catalyseur():
    """"""
    actions = []
    s = [(pos, elem) for pos in singletons(moi())
                     for elem in elem_adjacents(pos, moi())]
    if s != []:
        actions.append(('repare', s, 2))
    #les régions adverses avec plus de deux cases :
    r = [r for r in regions(adversaire()) if r['taille'] >= 2]
    if r != []:
        actions.append(('attaque', r, 4))
    #les catalyseurs adverses dangereux :
    (regions_catalysables, regions_presque_catalysables,
     paires_regions) = catalysation_possible(adversaire())
    r = regions_catalysables + regions_presque_catalysables + \
        [r1 for (r1, r2) in paires_regions] + \
        [r2 for (r1, r2) in paires_regions]

    if r != []:
        actions.append(('catalyseurs adverses', r, 1))

    if actions == []:
        print('pas catalyse')
        return False

    a, r = choice([(a, r) for (a, r, p) in actions],
                  p=[p for (a, r, p) in actions])
    if a == 'repare':
        repare()
    elif a == 'attaque':
        attaque()
    else:
        detruit_catalyseur(r)
    return True

def utilise_catalyseur():
    while nombre_catalyseurs() > 0 and utilise_un_catalyseur():
        continue

def libere_echantillon():
    """Procédure d'urgence : s'il n'y a aucune place pour placer l'échantillon
    suivant, on libère la plus grande région jusqu'à qu'on puisse placer
    l'échantillon."""
    print("PROCÉDURE D'URGENCE LANCÉE.")
    while placements_possible_echantillon(echantillon_tour(), moi()) == []:
        region = max(regions(moi()), key=lambda r: r['taille'])
        transmuter(region['case'])
    print("PROCÉDURE D'URGENCE ACHEVÉE AVEC SUCCÈS.")
    
def place_premier_tour():
    """Place l'échantillon au centre pour le premier tour."""
    
def place_echantillon():
    echantillon = echantillon_tour()
    possible = placements_possible_echantillon(echantillon, moi())
    if possible == []:
        libere_echantillon()
        possible = placements_possible_echantillon(echantillon, moi())

    def eval(pos_echantillon):
        h = heuristique1(pos_echantillon)
        placer_echantillon(*pos_echantillon)
        h += heuristique2(moi())
        annuler()
        return h

    possible.sort(key=lambda p:(eval(p), centre(p)))
    choix = choice(possible[-3:])
    placer_echantillon(*choix)

def envoie_echantillon(ne_pas_envoyer):
    """Choisis et envoie un échantillon à l'adversaire.
    On choisit l'échantillon tel que les deux éléments soient les moins
    présents chez l'adversaire. On évite également de donner un doublon
    à l'adversaire.
    
    On considère également un ensemble d'éléments à éviter d'envoyer."""
    echantillon = echantillon_tour()
    #les éléments de l'échantillon envoyable :
    echantillon_envoyable = [e for e in echantillon if e not in ne_pas_envoyer]
    elements_adv = nb_elements(adversaire())
    if len(echantillon_envoyable) == 1:
        #si seul un élément de l'échantillon est envoyable :
        elem_1 = echantillon_envoyable[0]
    else:
        #On choisit l'élément de l'échantillon actuel le moins présent chez
        #l'adversaire.
        elem_1 = min(echantillon, key=lambda e:elements_adv[e])
    #On choisit maintenant l'élément (non forcément dans l'échantillon)
    #le moins présent chez l'adversaire différent de elem_1.
    elem_2 = min([e for e in tous_les_elements
                  if e != elem_1 and e not in ne_pas_envoyer],
                 key=lambda e:elements_adv[e])
    donner_echantillon((elem_1, elem_2))

def saccage_region(region):
    #on recherche la case de la région adjacent au plus de case de la
    #même région.
    print('SACCAGE')
    def nb_adjacents(pos):
        return len([p for p in positions_adjacentes(pos)
                    if type_case(p, adversaire()) == region['element']])

    position = max(region['liste cases'], key=nb_adjacents)

    #on cherche en quoi on peut catalyser cette case.
    catalyse_possible = {1, 2, 3, 4, 5}
    for adj in positions_adjacentes(position):
        #on retire l'élément de la case adjacente de l'ensemble :
        catalyse_possible.difference_update({type_case(adj, adversaire())})
    #on prend le plus petit élément possible, de façon à éviter
    #si possible de transmuter en un élément catalysable.
    elem = min(catalyse_possible)
    err = catalyser(position, adversaire(), elem)
    assert err == erreur.OK, err

def test_catalysable():
    (regions_catalysables, regions_presque_catalysables,
     paires_regions) = catalysation_possible(adversaire())
    if regions_catalysables != []:
        while True:
            mes_regions = catalysation_possible(moi())[0]
            if nombre_catalyseurs() == 0:
                if mes_regions == []:
                    break
                r = max(mes_regions, key=lambda r: r['taille'])
                transmuter(r['case'])

            r = max(regions_catalysables, key=lambda r: r['taille'])
            saccage_region(r)
            (regions_catalysables, regions_presque_catalysables,
             paires_regions) = catalysation_possible(adversaire())
            if regions_catalysables == []:
                break

    #on renvoie la liste des éléments qu'il ne faut pas envoyer à
    #l'adversaire.
    pas_possible = set()
    for r in regions_presque_catalysables:
        pas_possible.update({r['element']})
    for (r1, r2) in paires_regions:
        pas_possible.update({r['element']})
    return pas_possible

