# coding: utf-8 # This file has been generated, if you wish to
# modify it in a permanent way, please refer
# to the script file : gen/generator_python.rb
"""
README

On fait en sorte que l'adversaire n'utilise JAMAIS de catalyseur. Si il
possède une région pouvant donner un catalyseur, on la détuit. Si il
possède deux cases pouvant formé une région transmutable en catalyseur, on évite
de lui donner un élément de cette région.

C'est tout bénef si l'adversaire nous donne des catalyseurs sans en
recevoir.

Si une région possède 2 cases ou plus et ne peut être agrandie, on la
transmute. Si elle ne bouge pas depuis 12 tours, on la transmute.

Pour choisir où placer sa case, on utilise des heuristique sommant les
carrés des régions après, auquel on applique des malus."""
from api import *

from fonctions import *

# Fonction appelée au début de la partie.
def partie_init():
    global mon_historique
    mon_historique = Historique()

def dernier_tour():
    """Fonction appelée au dernier tour : on vide tout !"""
    r = [region for region in regions(moi()) if region['taille'] > 1]
    while r != []:
        transmute_plus_grande_region()
        utilise_catalyseur()
        r = [region for region in regions(moi()) if region['taille'] > 1]

    place_echantillon()

    r = [region for region in regions(moi()) if region['taille'] > 1]
    while r != []:
        transmute_plus_grande_region()
        utilise_catalyseur()
        r = [region for region in regions(moi()) if region['taille'] > 1]

    envoie_echantillon([])


def jouer_tour():
    global mon_historique
    if tour_actuel() >= 149:
        print("dernier tour")
        dernier_tour()
        return

    ne_pas_envoyer = test_catalysable()

    while transmute():
        utilise_catalyseur()
    place_echantillon()
    #on utilise nos catalyseurs tant qu'on en a :
    cat_regions = [r for r in regions(moi()) if
                   r['element'] in (4, 5) and r['taille'] >= 3]
    while cat_regions != []:
        r = max(cat_regions, key=lambda r: r['taille'])
        transmuter(r['case'])
        utilise_catalyseur()
        cat_regions = [r for r in regions(moi()) if
                       r['element'] in (4, 5) and r['taille'] >= 3]
        print(cat_regions)

    envoie_echantillon(ne_pas_envoyer)

    mon_historique.fin_tour()

    for r in mon_historique.bloquees():
        if r['taille'] > 1:
            print('Libération')
            transmuter(r['case'])

# Fonction appelée à la fin de la partie.
def partie_fin():
    pass

