# coding: utf-8
# This file has been generated, if you wish to
# modify it in a permanent way, please refer
# to the script file : gen/generator_python.rb

from api import *


from collections import defaultdict


def base(joueur):
    if joueur == moi():
        return ma_base()
    return base_ennemie()

def adjacentes(case):
    for d in (0, 1), (0, -1), (1, 0), (-1, 0):
        c = case[0]+d[0], case[1]+d[1]
        if 0 < c[0] < TAILLE_TERRAIN - 1 and \
           0 < c[1] < TAILLE_TERRAIN - 1:
               yield c

def cout_tuyau(case):
    """Le cout pour mettre un tuyau sur une case."""
    if est_pulsar(case):
        raise ValueError("Cette case est un pulsar.")
    if est_tuyau(case):
        return 0
    if est_libre(case):
        return 1
    if est_debris(case):
        return 3
    raise ValueError("Erreur : case {}".format(case))


def placer_tuyau(position):
    if est_tuyau(position):
        return
    elif est_debris(position):
        deblayer(position)
    construire(position)

def estimation(pulsar, t, a, b, lambd):
    """Estimation du nombre de p charges que peut rapporter un pulsar au
    temps t, entre les instants a et b,
    avec lambda le coefficient de ..."""
    info = info_pulsar(pulsar)
    valeur = 0
    for i in range(info.pulsations_totales):
        t_puls = i * info.periode
        if a <= t_puls <= b:
            valeur += info.puissance * lambd ** (t_puls - t)
    return valeur

def dijkstra(joueur):
    """Renvoie le tableau des distances à la base du joueur pour
    chaque case."""
    cases = [[None] * TAILLE_TERRAIN for i in range(TAILLE_TERRAIN)]
    suivantes = {}
    for c in base(joueur):
        suivantes[c] = (-puissance_aspiration(c), [])
    while suivantes:
        c, v = min(suivantes.items(), key=lambda i:i[1][0])
        del suivantes[c]
        cases[c[0]][c[1]] = v
        for s in adjacentes(c):
            if est_pulsar(s) or cases[s[0]][s[1]] is not None:
                continue
            if est_tuyau(s):
                s_value = v
            else:
                s_value = (v[0] + cout_tuyau(s),
                           v[1] + [s])
            if s not in suivantes or \
               s_value[0] < suivantes[s][0]:
                suivantes[s] = s_value
    return cases

# Fonction appelée au début de la partie.
def partie_init():
    # Place ton code ici
    global voisins, puls_of_voisin
    print("lambda")
    voisins = set() #Les cases voisines d'un pulsar.
    puls_of_voisin = defaultdict(list)
    for p in liste_pulsars():
        for c in adjacentes(p):
            if not est_pulsar(c):
                voisins.add(c)
                puls_of_voisin[c].append(p)

def jouer_tour():
    lambd = 1
    t = tour_actuel()
    dist_joueur = dijkstra(moi())
    dist_advers = dijkstra(3 - moi())
    best = -100000
    chemin = []
    for v in voisins:
        if est_tuyau(v):
            continue
        infos_j = dist_joueur[v[0]][v[1]]
        infos_adv = dist_advers[v[0]][v[1]]
        if infos_j[0] > infos_adv[0]:
            #La case est plus proche de la base de l'adversaire :
            continue
        val = 0
        for p in puls_of_voisin[v]:
            val +=estimation(p,  t, t+infos_j[0], 100-infos_j[0],
                             lambd)
        if val > best:
            best, chemin = val, infos_j[1]

    for case in chemin:
        placer_tuyau(case)

# Fonction appelée à la fin de la partie.
def partie_fin():
    # Place ton code ici
    pass



