# coding: utf-8
# This file has been generated, if you wish to
# modify it in a permanent way, please refer
# to the script file : gen/generator_python.rb

from api import *


from collections import namedtuple
class Manager:
    """La classe qui fait tout."""
    def __init__(self):
        self.num = moi()
        self.ma_base = ma_base()
        self.base_ennemie = base_ennemie()

    def chemin(self):
        """Lance un dijkstra pour savoir quoi jouer."""
        cases = {}
        suivantes = {}
        for c in self.ma_base:
            suivantes[c] = (0, [])

        while suivantes:
            c, v = min(suivantes.items(), key=lambda i:i[1][0])
            del suivantes[c]
            cases[c] = v
            if c in voisins and not est_tuyau(c):
                return v[1]
            for s in adjacentes(c):
                if est_pulsar(s):
                    continue
                if s in cases:
                    continue
                if est_tuyau(s):
                    s_value = v
                else:
                    s_value = (v[0] + cout_tuyau(s),
                               v[1] + [s])
                if s not in suivantes or \
                   s_value[0] < suivantes[s][0]:
                    suivantes[s] = s_value
        return []

Pulsar = namedtuple("Pulsar",
                    ("position", "periode", "puissance",
                     "pulsations_restantes"))

def adjacentes(case):
    for d in (0, 1), (0, -1), (1, 0), (-1, 0):
        c = case[0]+d[0], case[1]+d[1]
        if 0 < c[0] < TAILLE_TERRAIN - 1 and \
           0 < c[1] < TAILLE_TERRAIN - 1:
               yield c

def cout_tuyau(case):
    """Le cout pour mettre un tuyau sur une case."""
    if est_pulsar(case):
        raise ValueError("Cette case est un pulsar.")
    if est_tuyau(case):
        return 0
    if est_libre(case):
        return 1
    if est_debris(case):
        return 3
    raise ValueError("Erreur : case {}".format(case))
voisins = set() #Les cases voisines d'un pulsar.
for p in liste_pulsars():
    for c in adjacentes(p):
        if not est_pulsar(c):
            voisins.add(c)

manager = Manager()

def placer_tuyau(position):
    if est_tuyau(position):
        return
    elif est_debris(position):
        deblayer(position)
    construire(position)

# Fonction appelée au début de la partie.
def partie_init():
    # Place ton code ici
    print("prologin0)

# Fonction appelée à chaque tour.
def jouer_tour():
    # Place ton code ici
    print(42)
    chemin = manager.chemin()
    print(chemin)
    for case in chemin:
        placer_tuyau(case)
    print("Ça marche !!!")

# Fonction appelée à la fin de la partie.
def partie_fin():
    # Place ton code ici
    pass

