"""Ce programme marche comme suit :
    À chaque tour, il jout parmi un panel de 3 actions :
    - rejoidre un pulsar
    -détruire des tuyaux pour gêner l'adversaire
    -consolider ses acquis.
Il estime quel est le coup qui augmente le plus la différence de points en
sa faveur."""

from api import *

from collections import defaultdict
from itertools import product
from random import choice

puls_of_voisin = defaultdict(list)


def adjacentes(case):
    """Les cases dans le terrain à côté de la case passée en argument."""
    for d in (0, 1), (0, -1), (1, 0), (-1, 0):
        c = case[0]+d[0], case[1]+d[1]
        if 0 < c[0] < TAILLE_TERRAIN - 1 and \
           0 < c[1] < TAILLE_TERRAIN - 1:
               yield c

def cout_tuyau(case):
    """Le cout pour mettre un tuyau sur une case, quel que soit l'état de
    la case."""
    if est_pulsar(case):
        raise ValueError("Cette case est un pulsar.")
    if est_tuyau(case):
        return 0
    if est_libre(case):
        return 1
    if est_debris(case):
        return 3
    raise ValueError("Erreur : case {}".format(case))


def placer_tuyau(position):
    """On place un tuyau sur cette case, quel que soit son état."""
    if est_tuyau(position):
        return
    elif est_debris(position):
        deblayer(position)
    construire(position)

def estimation(pulsar, a, b, k):
    """Estimation du nombre de p charges que peut rapporter un pulsar entre
    les tours a et b. k est une constante du programme."""
    info = info_pulsar(pulsar)
    valeur = 0
    for i in range(info.pulsations_totales):
        t_puls = i * info.periode
        if a <= t_puls <= b:
            valeur += info.puissance
    return valeur * k

def dijkstra(depart, depart_init, cout):
    """Renvoie le tableau des distances à la base du joueur pour
    chaque case."""
    cases = [[None] * TAILLE_TERRAIN for i in range(TAILLE_TERRAIN)]
    suivantes = {}
    for c in depart:
        suivantes[c] = (depart_init(c), [])
    while suivantes:
        c, v = min(suivantes.items(), key=lambda i:i[1][0])
        del suivantes[c]
        cases[c[0]][c[1]] = v
        for s in adjacentes(c):
            if est_pulsar(s) or cases[s[0]][s[1]] is not None:
                continue
            s_value = (v[0] + cout(s),
                       v[1] + [s])
            if s not in suivantes or \
               s_value[0] < suivantes[s][0]:
                suivantes[s] = s_value
    return cases

def distance_base(base):
    """Renvoie pour chaque case sa distance à l'une des deux bases, en
    terme de puissance d'aspiration. Permet d'estimer si une case est plus
    proche du camp du joueur ou de l'adversaire."""
    tuyaux = {c for c in product(range(1, TAILLE_TERRAIN - 1), repeat=2)
              if est_tuyau(c)}
    accessibles = connexes(tuyaux, base)
    cout = lambda x: 1 if x in accessibles else float("inf")
    distance_tuyaux = dijkstra(base, lambda x: -puissance_aspiration(x),
                               cout)
    def distb(case):
        if case in base:
            return 0
        return distance_tuyaux[case[0]][case[1]][0]
    dij_res =  dijkstra(accessibles.union(base), distb,
                    lambda x: 1)
    return {c:dij_res[c[0]][c[1]][0]
            for c in product(range(TAILLE_TERRAIN), repeat=2)
            if dij_res[c[0]][c[1]] is not None}

def connexes(tuyaux=None, depart=ma_base()+base_ennemie()):
    if tuyaux is None:
        tuyaux = {c for c in product(range(1, TAILLE_TERRAIN - 1), repeat=2)
              if est_tuyau(c)}
    connexe = set()
    attente = []
    for c in depart:
        for a in adjacentes(c):
            if a in tuyaux:
                attente.append(a)
                connexe.add(a)
    while attente:
        c = attente.pop()
        for a in adjacentes(c):
            if a in tuyaux and a not in connexe:
                attente.append(a)
                connexe.add(a)
    return connexe

def dependances(base):
    """Pour chaque tuyau, renvoie la liste des tuyaux qu'il suffit de
    détruire pour que la case en question ne soit plus connéctée à aucune
    base."""
    tuyaux = {c for c in product(range(1, TAILLE_TERRAIN - 1), repeat=2)
              if est_tuyau(c)}
    accessibles = connexes(tuyaux, base)
    dependances = {}
    for case in accessibles:
        tuyaux_sans_case = accessibles - {case}
        dependances[case] = accessibles - connexes(tuyaux_sans_case, base)
    return dependances

def signe(x):
    if x < 0:
        return -1
    if x > 0:
        return 1
    return 0

def puls_ejections():
    """Revoie la liste des cases qui vont être couvertes par une éjection
    de pulsar."""
    liste = []
    for v, puls in puls_of_voisin.items():
        for p in puls:
            if tour_actuel() % info_pulsar(p).periode == 0:
                liste.append((v, info_pulsar(p).puissance))
    return liste

def partie_init():
    # Place ton code ici
    for p in liste_pulsars():
        for c in adjacentes(p):
            if not est_pulsar(c):
                puls_of_voisin[c].append(p)

def jouer_tour():
    k = K1 if moi() == 1 else K2
    coups_possibles = []

    #La distance de 
    dist_ma_base = distance_base(ma_base())
    dist_base_enn = distance_base(base_ennemie())
    #Le chemin de coût minimal :
    chemin_coutmin = dijkstra(ma_base(), lambda x:0, cout_tuyau)
    atteignables = connexes(depart=ma_base())

    pts_charge = {}
    for c in liste_plasmas():
        pts_charge[c] = charges_presentes(c)
    pts_expulsions = defaultdict(int)
    for c, pts in puls_ejections():
        pts_expulsions[c] += pts

    #On regarde les destructions possibles.
    for case, dep in dependances(base_ennemie()).items():
        pts_suppression = 0
        for c in dep:
            if c in pts_charge and c != case:
                pts_suppression += pts_charge[c] *\
                     (1-signe(dist_ma_base[c]-dist_base_enn[c]))/2
            if c in pts_expulsions:
                pts_suppression += pts_expulsions[c] *\
                     (1-signe(dist_ma_base[c]-dist_base_enn[c]))/2
        if pts_suppression > 2 and score(moi()) >= 2:
            coups_possibles.append(("d", case, pts_suppression - 2))

    for case, dep in dependances(ma_base()).items():
        pts_suppression = 0
        for c in dep:
            if c in pts_charge and c != case:
                pts_suppression += pts_charge[c] *\
                     (1+signe(dist_ma_base[c]-dist_base_enn[c]))/2
            if c in pts_expulsions:
                pts_suppression += pts_expulsions[c] *\
                     (1+signe(dist_ma_base[c]-dist_base_enn[c]))/2
        if pts_suppression > 2 and score(3 - moi()) >= 2:
            coups_possibles.append(("p", case, pts_suppression - 2))


    #Maintenant, on regarde les pulsars à atteindre :
    for case in puls_of_voisin:
        if case in atteignables:
            continue
        valeur = 0
        mult = signe(dist_ma_base[case] - dist_base_enn[case])/2 + 0.5
        for p in puls_of_voisin[case]:
            valeur += estimation(p, tour_actuel(), 100, k) * mult
        if valeur > 0:
            coups_possibles.append(("v", case, valeur))

    #On trie les coups raisonnables par ordre de gain potentiel.
    #coup : de la forme (a, b, c)
    #a décrit si c'est une destruction, un visage de pulsar ou une protection
    #b décrit la case sur laquelle se produit l'action.
    #c décrit le nb de points estimés.
    coups_possibles.sort(key=lambda t: t[2])
    while coups_possibles and points_action() > 0:
        coup = coups_possibles.pop()
        if coup[0] == "d":
            detruire(coup[1])
        if coup[0] == "v":
            chemin = chemin_coutmin[coup[1][0]][coup[1][1]]
            for case in chemin[1]:
                placer_tuyau(case)
        if coup[0] == "p":
            for c in adjacentes(coup[1]):
                placer_tuyau(c)

    #enfin, on gère les aspirtions :
    liste_utiles = []
    liste_inutiles = []
    for case in ma_base():
        for a in adjacentes(case):
            if est_tuyau(a) and puissance_aspiration(case) < 5:
                liste_utiles.append(case)
            if not est_tuyau(a) and puissance_aspiration(case) > 0:
                liste_inutiles.append(case)

    if liste_utiles and liste_inutiles:
        a = choice(liste_utiles)
        b = choice(liste_inutiles)
        deplacer_aspiration(b, a)

# Fonction appelée à la fin de la partie.

def partie_fin():
    # Place ton code ici
    pass

