// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb

using System.Runtime.CompilerServices;

namespace Prologin {
// Information sur les cases
	public enum CaseInfo {
		CASE_SIMPLE, // <- Case simple
		CASE_TOURELLE, // <- Tourelle
		CASE_BASE, // <- Base du joueur
		CASE_FONTAINE, // <- Fontaine magique
		CASE_ARTEFACT, // <- Artefact magique
		CASE_ERREUR, // <- Erreur
	}

// Erreurs possibles
	public enum Erreur {
		OK, // <- L'action s'est effectuée avec succès
		ANNULER_IMPOSSIBLE, // <- Aucune action à annuler
		CASE_IMPOSSIBLE, // <- Cette case n'existe pas
		CASE_ADVERSE, // <- Vous ne contrôlez pas cette case
		CASE_UTILISEE, // <- Cette case n'est pas libre
		CASE_VIDE, // <- Cette case est vide
		VALEUR_INVALIDE, // <- Cette valeur est invalide
		MAGIE_INSUFFISANTE, // <- Vous n'avez pas assez de magie
		SORCIERS_INSUFFISANTS, // <- Vous n'avez pas assez de sorciers
		ATTAQUE_INSUFFISANTE, // <- Vous n'avez pas assez de points d'attaque
		PHASE_INCORRECTE, // <- Cette action ne peut pas être utilisée lors de cette phase du jeu.
		PORTEE_INSUFFISANTE, // <- Vous n'avez pas assez de portée pour effectuer cette action
		PERDANT, // <- Vous avez perdu et ne pouvez pas effectuer d'actions
	}

// Représente la position sur la carte
	class Position {
		public Position() {
		}
		public int X; // <- Coordonnée en X
		public int Y; // <- Coordonnée en Y
	}

// Représente une tourelle
	class Tourelle {
		public Tourelle() {
		}
		public Position Pos; // <- Position de la tourelle
		public int Portee; // <- Portée de la tourelle
		public int Joueur; // <- Joueur qui possède la tourelle
		public int Vie; // <- Nombre de points de vie de la tourelle
		public int Attaque; // <- Nombre de points d'attaque de la tourelle
	}

	class Api {
// Taille du terrain (longueur et largeur)
		public const int TAILLE_TERRAIN = 31;

// Nombre de joueurs dans la partie
		public const int NB_JOUEURS = 4;

// Nombre maximum de tours à jouer avant la fin de la partie
		public const int MAX_TOUR = 100;

// Magie gagnée à chaque tour
		public const int MAGIE_TOUR = 20;

// Magie gagnée à chaque tour pour chaque fontaine possédée
		public const int MAGIE_FONTAINES = 15;

// Magie gagnée à chaque sorcier tué
		public const int MAGIE_COMBAT = 1;

// Magie récupérée à chaque tourelle supprimée
		public const int MAGIE_SUPPRESSION = 10;

// Nombre de points de magie par sorcier
		public const int COUT_SORCIER = 2;

// Nombre de points de magie par tourelle
		public const int COUT_TOURELLE = 20;

// Coût exponentiel pour chaque case de portée supplémentaire
		public const int COUT_PORTEE = 4;

// Nombre maximum de cases qu'un sorcier peut franchir à chaque tour.
		public const int PORTEE_SORCIER = 4;

// Portée de base d'une tourelle
		public const int PORTEE_TOURELLE = 3;

// Portée de construction des tourelles
		public const int CONSTRUCTION_TOURELLE = 3;

// Points de vie d'une tourelle à sa création
		public const int VIE_TOURELLE = 10;

// Points d'attaque d'une tourelle au début d'un tour
		public const int ATTAQUE_TOURELLE = 10;

// Points gagnés pour avoir survécu à la fin de la partie
		public const int POINTS_SURVIVRE = 1;

// Points gagnés pour avoir vaincu un adversaire
		public const int POINTS_VAINQUEUR = 1;

// Points gagnés pour contrôler une fontaine à la fin de la partie
		public const int POINTS_CONTROLE_FONTAINE = 1;

// Points gagnés pour contrôler un artefact à la fin de la partie
		public const int POINTS_CONTROLE_ARTEFACT = 4;

// Retourne le type de la case à l'emplacement `pos`
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern CaseInfo InfoCase(Position pos);

// Retourne la liste des tourelles qui appartiennent au joueur ``joueur``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Tourelle[] TourellesJoueur(int joueur);

// Retourne la magie que possède le joueur ``joueur``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Magie(int joueur);

// Retourne le nombre de sorciers du joueur ``joueur`` sur la case ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int NbSorciers(Position pos, int joueur);

// Retourne le nombre de sorciers du joueur ``joueur`` déplacables sur la case ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int NbSorciersDeplacables(Position pos, int joueur);

// Retourne le numéro du joueur qui contrôle la case ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int JoueurCase(Position pos);

// Retourne la tourelle située sur la case ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Tourelle TourelleCase(Position pos);

// Retourne la position de la base du joueur ``joueur``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position BaseJoueur(int joueur);

// Retourne vrai si l'on peut construire sur la case ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool Constructible(Position pos, int joueur);

// Retourne la liste des positions constituant le plus court chemin allant de la case ``pos1`` à la case ``pos2``. Attention : Cette fonction est lente.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] Chemin(Position pos1, Position pos2);

// Construire une tourelle à la position ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Construire(Position pos, int portee);

// Supprimer une tourelle à la position ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Supprimer(Position pos);

// Tirer avec ``pts`` points de dégats depuis la tourelles ``tourelle`` sur la position ``cible``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Tirer(int pts, Position tourelle, Position cible);

// Créer ``nb`` sorciers dans la base
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Creer(int nb);

// Déplace ``nb`` sorciers de la position ``depart`` jusqu'à la position ``arrivee``.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Deplacer(Position depart, Position arrivee, int nb);

// Attaquer la tourelle à la position ``cible`` depuis la position ``pos``
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Assieger(Position pos, Position cible, int nb_sorciers);

// Retourne le numéro de votre joueur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Moi();

// Retourne la liste des numéros de vos adversaires
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int[] Adversaires();

// Retourne le numéro du tour actuel
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int TourActuel();

// Retourne la distance entre deux positions
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int Distance(Position depart, Position arrivee);

// Annule la dernière action
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Annuler();

// Affiche le contenu d'une valeur de type case_info
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherCaseInfo(CaseInfo v);

// Affiche le contenu d'une valeur de type erreur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherErreur(Erreur v);

// Affiche le contenu d'une valeur de type position
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPosition(Position v);

// Affiche le contenu d'une valeur de type tourelle
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherTourelle(Tourelle v);

	}
}
