/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <iostream>
#include <queue>
#include <chrono>

#define GROS_NOMBRE 10000
#define PROFONDEUR_EXP_MAX 16
#define L std::cout << __LINE__ << std::endl
#define V(a) std::cout << #a << ":" << a << std::endl
#define P(a) std::cout << a << std::endl
#define P_POS(a) std::cout << #a << ":" << a.ligne << ", " << a.colonne << std::endl
#define T_B std::clock_t begin = std::clock()
#define T_E double elapsed_time = (double)(std::clock() - begin)/CLOCKS_PER_SEC; V(elapsed_time)

typedef struct agent{
    int id_agent;
    position pos;
    int points_action;
} agent;

typedef struct mouvement{
    action_hist action;
    position pos;
} mouvement;

typedef struct tour_jeu{
    std::vector<alien_info> aliens;
    int tour;
    int joeure;
    std::array<agent, NB_AGENTS> agents_j1;
    std::array<agent, NB_AGENTS> agents_j2;
} tour_jeu;

double temps_tour[100];


void imprimer_movouvement(mouvement move){
    return;
    std::cout << "position d'arrive" << move.pos.ligne << ", " << move.pos.colonne << " type action : " << move.action.atype << ", " << move.action.dir << " agent : "
              << move.action.id_agent << std::endl;
}

void imprimer_deplacement(std::vector<mouvement> deplacement){
    for (mouvement move : deplacement){
        imprimer_movouvement(move);
    }
}

std::array<std::array<std::array<int, TAILLE_BANQUISE>, TAILLE_BANQUISE>, NB_TOURS> valeur_case;
std::array<std::array<case_type, TAILLE_BANQUISE>, TAILLE_BANQUISE > carte;

void initialiser_case(){
    for (alien_info alien : liste_aliens()){
        if (alien.duree_invasion < 3){
            continue;
        }
        for (int i = alien.tour_invasion - 1; i > 0 && i <= alien.tour_invasion + alien.duree_invasion; i++){
            valeur_case[i][alien.pos.ligne][alien.pos.colonne] = alien.points_capture;
        }

    }
}


void partie_init()
{
    // fonction a completer
    position pos;
    for (int i = 0; i < TAILLE_BANQUISE; i++){
        for (int k = 0; k < TAILLE_BANQUISE; k++){
            pos.ligne = i;
            pos.colonne = k;
            carte[i][k] = type_case(pos);
            if (type_case(pos) != LIBRE && type_case(pos) != MUR){
                std::cout << "case a une valeur inattendue" << std::endl;
            }
        }
    }
}

bool case_libre(position pos, const tour_jeu &etat ){
    if (pos.ligne < 0 || pos.ligne >= TAILLE_BANQUISE || pos.colonne < 0 || pos.colonne >= TAILLE_BANQUISE){
        return false;
    }
    if (carte[pos.ligne][pos.colonne] != LIBRE){
        return false;
    }
    for (agent manchot: etat.agents_j1){
        if (manchot.pos == pos){
            return false;
        }
    }
    for (agent manchot: etat.agents_j2){
        if (manchot.pos == pos){
            return false;
        }
    }
    return true;
}

std::vector<mouvement> mouvements_pos(tour_jeu etat, position posi,int ide_agent){
    std::vector<mouvement> mouvements;
    int ligne = posi.ligne;
    int colonne = posi.colonne;
    //SUD
    if (ligne <= TAILLE_BANQUISE - 2){
        if (case_libre(etat, {ligne + 1, colonne})){
            mouvements.push_back({{ACTION_DEPLACER, ide_agent, SUD}, {ligne + 1, colonne}});

            bool pas_break = true;
            for (int i = ligne + 1; i < TAILLE_BANQUISE - 1; i++){
                if (!case_libre(etat, {i + 1, colonne})){
                    mouvements.push_back({{ACTION_GLISSER, ide_agent, SUD}, {i, colonne}});
                    pas_break = false;
                    break;
                }
            }
            if (pas_break){
                mouvements.push_back({{ACTION_GLISSER, ide_agent, SUD}, {TAILLE_BANQUISE - 1, colonne}});
            }
        }
    }
    //NORD
    if (ligne >= 1){
        if (case_libre(etat, {ligne - 1, colonne})){
            mouvements.push_back({{ACTION_DEPLACER, ide_agent, NORD}, {ligne - 1, colonne}});

            bool pas_break = true;
            for (int i = ligne - 1; i >= 1; i--){
                if (!case_libre(etat, {i - 1, colonne})){
                    mouvements.push_back({{ACTION_GLISSER, ide_agent, NORD}, {i, colonne}});
                    pas_break = false;
                    break;
                }
            }
            if (pas_break){
                mouvements.push_back({{ACTION_GLISSER, ide_agent, NORD}, {0, colonne}});
            }
        }
    }
    //EST
    if (colonne <= TAILLE_BANQUISE - 2){
        if (case_libre(etat, {ligne, colonne + 1})){
            mouvements.push_back({{ACTION_DEPLACER, ide_agent, EST}, {ligne , colonne + 1}});

            bool pas_break = true;
            for (int i = colonne + 1; i < TAILLE_BANQUISE - 1; i++){
                if (!case_libre(etat, {ligne, i + 1})){
                    mouvements.push_back({{ACTION_GLISSER, ide_agent, EST}, {ligne, i}});
                    pas_break = false;
                    break;
                }
            }
            if (pas_break){
                mouvements.push_back({{ACTION_GLISSER, ide_agent, EST}, {ligne, TAILLE_BANQUISE - 1}});
            }
        }
    }
    //OUEST
    if (colonne >= 1){
        if (case_libre(etat, {ligne , colonne - 1})){
            mouvements.push_back(mouvement {{ACTION_DEPLACER, ide_agent, OUEST}, {ligne, colonne - 1}});

            bool pas_break = true;
            for (int i = colonne - 1; i >= 1; i--){
                if (!case_libre(etat, {ligne, i - 1})){
                    mouvements.push_back(mouvement {{ACTION_GLISSER, ide_agent, OUEST}, {ligne, i}});
                    pas_break = false;
                    break;
                }
            }
            if (pas_break){
                mouvements.push_back(mouvement {{ACTION_GLISSER, ide_agent, OUEST}, {ligne, 0}});
            }
        }
    }
    return mouvements;




}

int cout(mouvement move){
    switch (move.action.atype){
        case ACTION_DEPLACER:
            return 1;
        case ACTION_GLISSER:
            return 3;
        case ACTION_POUSSER:
            return 5;
    }
    return 1000;
}

int cout(std::vector<mouvement> deplacement){
    int somme = 0;
    for (mouvement move : deplacement){
        somme += cout(move);
    }
    return somme;
}


typedef struct valeur_et_pos{
    position pos;
    int valeur;
} valeur_et_pos;
bool operator<(const valeur_et_pos& a, const valeur_et_pos& b) {
  //parfois il faut tricher un petit peu
  if (a.valeur > b.valeur) return true;
  return false;
}

void imprimer_alien(alien_info alien){
    P_POS(alien.pos);
    V(alien.capture_en_cours);
    V(alien.duree_invasion);
    V(alien.points_capture);
    V(alien.tour_invasion);
}

void imprimer_agent(agent manchot){
    V(manchot.id_agent);
    V(manchot.points_action);
    P_POS(manchot.pos);
}

void imprimer_etat(const tour_jeu &etat){
    V(etat.tour);
    V(etat.joeure);
    P("aliens : ");
    for (alien_info alien : etat.aliens){
        imprimer_alien(alien);
    }

    P("agents j1");
    for (agent manchot : etat.agents_j1){
        imprimer_agent(manchot);
    }
    P("agents j2");
    for (agent manchot : etat.agents_j2){
        imprimer_agent(manchot);
    }

}

std::vector<mouvement> djikstra(const tour_jeu &etat, position initial, position final, int ide_agent){
    T_B;
    std::cout << "debut djikstra" << std::endl;
    P_POS(final);
    std::array<std::array<bool, TAILLE_BANQUISE>, TAILLE_BANQUISE > exp;
    for (int i = 0; i < TAILLE_BANQUISE; i++){
        for (int k = 0; k < TAILLE_BANQUISE; k++){
            exp[i][k] = false;
        }
    }
    std::array<std::array<int, TAILLE_BANQUISE>, TAILLE_BANQUISE > graph_pa;
    for (int i = 0; i < TAILLE_BANQUISE; i++){
        for (int k = 0; k < TAILLE_BANQUISE; k++){
            graph_pa[i][k] = GROS_NOMBRE;
        }
    }

    std::array<std::array<std::vector<mouvement>, TAILLE_BANQUISE>, TAILLE_BANQUISE > graph_valeurs;
    std::priority_queue<valeur_et_pos > prio;
    prio.push(valeur_et_pos {initial, 0});
    valeur_et_pos pivot;
    while (true) {
        if (prio.size() > GROS_NOMBRE){
            std::cout << "file de prio overflow" << std::endl;
            break;
        }
        if (prio.size() == 0){
            std::cout << "file de prio vide" << std::endl;
            break;
        }
        pivot = prio.top();
        //std::cout << "pivot : " << pivot.pos.ligne << ", " << pivot.pos.colonne << " taille : " << prio.size() <<std::endl;
        prio.pop();
        if (pivot.valeur > PROFONDEUR_EXP_MAX){
            std::cout << "valeur trop grande " << pivot.valeur << std::endl;
            break;
        }
        if (pivot.pos == final){
            std::cout << "attein le sommet final " << std::endl;
            break;
        }
        if (exp[pivot.pos.ligne][pivot.pos.colonne]){
            for (std::array<bool, TAILLE_BANQUISE> table : exp){
                for (auto el : table){
                    //std::cout << el;
                }
                //std::cout<< std::endl;
            }
            //std::cout << "continue" << std::endl;
            continue;
        }
        exp[pivot.pos.ligne][pivot.pos.colonne] = true;
        //std::cout << "pas de move ?" << std::endl;
        for (mouvement move : mouvements_pos(etat, pivot.pos, ide_agent)){
            //std::cout << "destination : " << final.ligne << ", " << final.colonne << std::endl;
            //imprimer_movouvement(move);
            //std::cout << "val :  " << graph_pa[move.pos.ligne][move.pos.colonne] << std::endl;
            if (graph_pa[move.pos.ligne][move.pos.colonne] > cout(move) + pivot.valeur){
                //std::cout << "condition dans djikstra " << std::endl;

                graph_pa[move.pos.ligne][move.pos.colonne] = cout(move) + pivot.valeur;
                prio.push(valeur_et_pos {move.pos, cout(move) + pivot.valeur});
                //copie du vecteur

                graph_valeurs[move.pos.ligne][move.pos.colonne] = graph_valeurs[pivot.pos.ligne][pivot.pos.colonne];
                //std::cout << std::endl << "deplacement avant pushback" << std::endl;
                //imprimer_deplacement(graph_valeurs[move.pos.ligne][move.pos.colonne]);
                graph_valeurs[move.pos.ligne][move.pos.colonne].push_back(move);

                graph_valeurs[move.pos.ligne][move.pos.colonne] = graph_valeurs[move.pos.ligne][move.pos.colonne];
                if (move.pos == final){
                    std::cout << std::endl << "deplacement aprés pushback" << std::endl;
                    imprimer_deplacement(graph_valeurs[move.pos.ligne][move.pos.colonne]);
                }
            }
        }
    }
    T_E;
    V("fin djikstra, resultat : ");
    imprimer_deplacement(graph_valeurs[final.ligne][final.colonne]);
    return graph_valeurs[final.ligne][final.colonne];
}

bool alien_sur_case2(position pos, const tour_jeu &etat){
    for (alien_info alien : etat.aliens){
        if (alien.pos == pos){
            return true;
        }
    }
    return false;
}

int agent_sur_alien(position pos, const tour_jeu &etat){
    //fonction tres mal nomme elle test juste siu un agent est present a la case donne
    for(agent manchot : etat2.agents_j1){
        if (manchot.pos == pos){
            return 1;
        }
    }
    for(agent manchot : etat2.agents_j2){
        if (manchot.pos == pos){
            return 2;
        }
    }
    return 0;
}

std::pair<int, int> agent_sur_case2(position pos, const tour_jeu &etat){
    for(agent manchot : etat2.agents_j1){
        if (manchot.pos == pos){
            return make_pair(1, manchot.id_agent);
        }
    }
    for(agent manchot : etat2.agents_j2){
        if (manchot.pos == pos){
            return make_pair(2, manchot.id_agent);
        }
    }
    return make_pair(0, 0);
}

erreur efectuer_action(action_hist action){
    switch (action.atype) {
    case ACTION_GLISSER:
        //std::cout << "glisse (agent, dir): " << action.id_agent << ", " << action.dir << std::endl;
        return glisser(action.id_agent, action.dir);
        break;
    case ACTION_DEPLACER:
        //std::cout << "marche (agent, dir): " << action.id_agent << ", " << action.dir << std::endl;
        return deplacer(action.id_agent, action.dir);
        break;
    case ACTION_POUSSER:
        return pousser(action.id_agent, action.dir);
        break;
    default:
        std::cout << "wtf" << std::endl;
        return DRAPEAU_INVALIDE;
        break;
    }
}

void agir_pousser(const mouvement &move, tour_jeu &etat){
    switch (move.action.dir) {
    case EST:

        break;
    case OUEST:
        break;
    default:
        break;
    }
}


tour_jeu actualiser(tour_jeu etat, std::vector<mouvement> actions){
    std::cout << "actualisation en cours" << std::endl << std::endl;
    imprimer_deplacement(actions);
    tour_jeu n_etat = etat;
    //P("vieux etat");
    //imprimer_etat(n_etat);
    if (n_etat.joeure == 1) {
        for (mouvement move : actions){
            //std::cout << "mouvements lances" << std::endl;
            if (cout(move) > n_etat.agents_j1[move.action.id_agent].points_action){
                break;
            }
            n_etat.agents_j1[move.action.id_agent].points_action =  n_etat.agents_j1[move.action.id_agent].points_action - cout(move);
            n_etat.agents_j1[move.action.id_agent].pos = move.pos;

            //std::cout << efectuer_action(move.action) << ", ligne :" << position_agent(1, move.action.id_agent).ligne << std::endl ;
            std::cout << efectuer_action(move.action);
        }
        std::cout << std::endl;
    }
    else {
        for (mouvement move : actions){
            if (cout(move) > n_etat.agents_j2[move.action.id_agent].points_action){
                break;
            }
            n_etat.agents_j2[move.action.id_agent].points_action =  n_etat.agents_j2[move.action.id_agent].points_action - cout(move);
            n_etat.agents_j2[move.action.id_agent].pos = move.pos;
            std::cout << efectuer_action(move.action) << ", ";
        }
        std::cout << std::endl;
    }
    //P("nouveau etat");
    //imprimer_etat(n_etat);
    return n_etat;
}


std::vector<std::vector<mouvement> > depalement_interessant(agent manchot, const tour_jeu &etat){
    std::vector<std::vector<mouvement> > reponse;
    if (etat.joeure == 1){
        //peut on poussser autour de nous ?

        if (agent_sur_alien(position {manchot.pos.ligne, manchot.pos.colonne - 1}, etat)){
            std::vector<mouvement> to;
            to.push-back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, OUEST}, manchot.pos});
            reponse.push_back(to);
        }
        if (agent_sur_alien(position {manchot.pos.ligne, manchot.pos.colonne + 1}, etat)){
            std::vector<mouvement> to;
            to.push-back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, EST}, manchot.pos});
            reponse.push_back(to);
        }
        if (agent_sur_alien(position {manchot.pos.ligne + 1, manchot.pos.colonne }, etat)){
            std::vector<mouvement> to;
            to.push-back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, SUD}, manchot.pos});
            reponse.push_back(to);
        }
        if (agent_sur_alien(position {manchot.pos.ligne - 1, manchot.pos.colonne }, etat)){
            std::vector<mouvement> to;
            to.push-back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, NORD}, manchot.pos});
            reponse.push_back(to);
        }
        //on ne bouge pas si on est sur un alien
        if (agent_sur_alien(manchot.pos, etat)){
            return reponse;
        }

        for (alien_info alien : etat.aliens){
            switch (agent_sur_case(alien.pos)) {
            case 2:

                if (case_libre(position {alien.pos.ligne, alien.pos.colonne - 1}, etat)){
                    t = djikstra(etat, manchot.pos, position {alien.pos.ligne, alien.pos.colonne - 1}, manchot.id_agent);
                    t.push_back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, OUEST}, t.back().pos});
                    reponse.push_back(t);

                }
                if (case_libre(position {alien.pos.ligne, alien.pos.colonne + 1}, etat)){
                    t = djikstra(etat, manchot.pos, position {alien.pos.ligne, alien.pos.colonne + 1}, manchot.id_agent);
                    t.push_back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, EST}, t.back().pos});
                    reponse.push_back(t);

                }
                if (case_libre(position {alien.pos.ligne + 1, alien.pos.colonne }, etat)){
                    t = djikstra(etat, manchot.pos, position {alien.pos.ligne + 1, alien.pos.colonne}, manchot.id_agent);
                    t.push_back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, SUD}, t.back().pos});
                    reponse.push_back(t);

                }
                if (case_libre(position {alien.pos.ligne - 1, alien.pos.colonne }, etat)){
                    t = djikstra(etat, manchot.pos, position {alien.pos.ligne - 1, alien.pos.colonne}, manchot.id_agent);
                    t.push_back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, NORD}, t.back().pos});
                    reponse.push_back(t);

                }
                break;
            case 1:
                break;
            default:
                reponse.push_back(djikstra(etat, manchot.pos, position {alien.pos.ligne, alien.pos.colonne}, manchot.id_agent));
                break;
            }
        }
    }
    else {
        for (alien_info alien : etat.aliens){
            switch (agent_sur_case(alien.pos)) {
            case 1:

                if (case_libre(position {alien.pos.ligne, alien.pos.colonne - 1}, etat)){
                    t = djikstra(etat, manchot.pos, position {alien.pos.ligne, alien.pos.colonne - 1}, manchot.id_agent);
                    t.push_back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, OUEST}, t.back().pos});
                    reponse.push_back(t);

                }
                if (case_libre(position {alien.pos.ligne, alien.pos.colonne + 1}, etat)){
                    t = djikstra(etat, manchot.pos, position {alien.pos.ligne, alien.pos.colonne + 1}, manchot.id_agent);
                    t.push_back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, EST}, t.back().pos});
                    reponse.push_back(t);

                }
                if (case_libre(position {alien.pos.ligne + 1, alien.pos.colonne }, etat)){
                    t = djikstra(etat, manchot.pos, position {alien.pos.ligne + 1, alien.pos.colonne}, manchot.id_agent);
                    t.push_back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, SUD}, t.back().pos});
                    reponse.push_back(t);

                }
                if (case_libre(position {alien.pos.ligne - 1, alien.pos.colonne }, etat)){
                    t = djikstra(etat, manchot.pos, position {alien.pos.ligne - 1, alien.pos.colonne}, manchot.id_agent);
                    t.push_back(mouvement {action_hist {ACTION_POUSSER, manchot.id_agent, NORD}, t.back().pos});
                    reponse.push_back(t);

                }
                break;
            case 2:
                break;
            default:
                reponse.push_back(djikstra(etat, manchot.pos, position {alien.pos.ligne, alien.pos.colonne}, manchot.id_agent));
                break;
            }
        }
    }

}

 tour_jeu update_tour(tour_jeu etat ){
    std::cout << "actualisation du tour : " << etat.tour << std::endl;
    tour_jeu etat2 = etat;
    if (etat2.joeure == 1){
        long unsigned int j = 0;
        while (j < etat2.aliens.size()){
            alien_info alien = etat2.aliens[j];
            j++;
            if (alien.pos.ligne < 0 || alien.pos.ligne >= TAILLE_BANQUISE || alien.pos.colonne < 0 || alien.pos.colonne >= TAILLE_BANQUISE){
                P("WT5FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
            }
            if (agent_sur_alien(alien.pos, etat)){
                continue;
            }
            int min = GROS_NOMBRE;
            std::vector<mouvement> actions_a_effectuer;
            for(agent manchot : etat2.agents_j1){
                if (manchot.points_action == 8 && !alien_sur_case2(manchot.pos, etat)){
                    if (alien.pos.ligne < 0 || alien.pos.ligne >= TAILLE_BANQUISE || alien.pos.colonne < 0 || alien.pos.colonne >= TAILLE_BANQUISE){
                        P("WT5FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
                        imprimer_alien(alien);
                    }
                    auto deplacement = djikstra(etat2, manchot.pos, alien.pos, manchot.id_agent);
                    if (cout(deplacement) < min){
                        min = cout(deplacement);
                        P("sur le point de assigner actions a effectuer");
                        actions_a_effectuer = deplacement;
                    }
                }
            }
            etat2 = actualiser(etat2, actions_a_effectuer);




        }
    }
    else {
        long unsigned int j = 0;
        while (j < etat2.aliens.size()){
            alien_info alien = etat2.aliens[j];
            j++;
            if (alien.pos.ligne < 0 || alien.pos.ligne >= TAILLE_BANQUISE || alien.pos.colonne < 0 || alien.pos.colonne >= TAILLE_BANQUISE){
                P("WT5FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
            }
            for(agent manchot : etat2.agents_j1){
                if (manchot.pos == alien.pos){
                    continue;
                }
            }
            for(agent manchot : etat2.agents_j2){
                if (manchot.pos == alien.pos){
                    continue;
                }
            }
            int min = GROS_NOMBRE;
            std::vector<mouvement> actions_a_effectuer;
            for(agent manchot : etat2.agents_j2){
                if (manchot.points_action == 8 && !alien_sur_case2(manchot.pos, etat)){
                    if (alien.pos.ligne < 0 || alien.pos.ligne >= TAILLE_BANQUISE || alien.pos.colonne < 0 || alien.pos.colonne >= TAILLE_BANQUISE){
                        P("WT5FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
                        imprimer_alien(alien);
                    }
                    auto deplacement = djikstra(etat2, manchot.pos, alien.pos, manchot.id_agent);
                    if (cout(deplacement) < min){
                        min = cout(deplacement);
                        P("sur le point de assigner actions a effectuer");
                        actions_a_effectuer = deplacement;
                    }
                }
            }
            etat2 = actualiser(etat2, actions_a_effectuer);




        }
    }

    return etat2;
}
/// Fonction appelée à chaque tour.
void jouer_tour()
{
    // initialisation du tour
    std::clock_t begin = std::clock();
    std::vector<alien_info> aliens;
    for (alien_info alien :liste_aliens()){
        if (alien_sur_case(alien.pos)){
            aliens.push_back(alien);
        }
    }
    std::cout << "aliens !!!" << std::endl;

    std::array<agent, NB_AGENTS> agents_j1;
    std::array<agent, NB_AGENTS> agents_j2;
    for (int i = 0; i < NB_AGENTS; i++){
        agents_j1[i] = {i, position_agent(1, i), 8};
        agents_j2[i] = {i, position_agent(2, i), 8};
    }
    std::cout << "initialisation" << std::endl;
    tour_jeu etat = {aliens, tour_actuel(), moi(), agents_j1, agents_j2};
    std::cout << "etat initialiser !!!" << std::endl;
    update_tour(etat);
    double elapsed_time = (double)(std::clock() - begin)/CLOCKS_PER_SEC;
    temps_tour[tour_actuel()] = elapsed_time;
    V(elapsed_time);
  // fonction a completer
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
    for (int i = 0; i < 100; i ++){
        P(i);
        P(temps_tour[i]);
    }
  // fonction a completer
}
