#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/* Pour avoir arc4random_uniform() */
#define u_char uint8_t
#include <bsd/stdio.h>


static void
usage(void)
{
	const char *__progname;

	fprintf(stderr, "usage: %s [-n <pulsars>] [-p <puissance>] [-r <total>] [-T <période>]\n"
			"\tPetit programme pour générer des cartes aléatoires\n"
			"\técrit avec amour par lesmon™\n"
			"\t    -n\tIndiquer le nombre de pulsars                 (défaut: 42)\n"
			"\t    -p\tPuissance maximale d'un pulsar                (défaut: 32)\n"
			"\t    -r\tNombre maximal de répétitions d'un pulsar:    (défaut: 50)\n"
			"\t    -T\tPériode maximale d'un pulsar                  (défaut: 12)\n\n",
			__progname);
	exit(EXIT_FAILURE);
}


int
main(int argc, char *argv[])
{
	bool pulsar[39][39] = {false};
	int n = 42, p = 32, r = 50, T = 12, c;

	while ((c = getopt(argc, argv, "hn:p:r:T:")) != -1)
		switch (c)
		{
		case 'h':
			usage();
			break;
		case 'n':
			if (sscanf(optarg, "%i", &n) != 1)
				usage();
			break;
		case 'p':
			if (sscanf(optarg, "%i", &p) != 1)
				usage();
			break;
		case 'r':
			if (sscanf(optarg, "%i", &r) != 1)
				usage();
			break;
		case 'T':
			if (sscanf(optarg, "%i", &T) != 1)
				usage();
			break;
		default:
			usage();
		}

	while (n--)
	{
		int x, y;

		do {
			x = arc4random_uniform(37) + 1;
			y = arc4random_uniform(37) + 1;
		/* On évite les doublons */
		} while (pulsar[x][y]);

		pulsar[x][y] = true;
	}

	for (int x = 0; x < 39; x++)
		for (int y = 0; y < 39; y++)
			if (pulsar[x][y])
			{
				int periode, puissance, total;

				periode = arc4random_uniform(T) + 1;
				puissance = arc4random_uniform(p) + 1;
				total = arc4random_uniform(r) + 1;

				printf("%d %d %d %d %d\n", x, y, periode, puissance, total);
			}

	return 0;
}
