#include "strategy.h"
#include "utils.h"

void strategy()
{
    std::cout << "== Début de tour ==" << std::endl;

    makeWeakList();

    attackWeakOpponentPipe();

    while(points_action() > 0)
    {
        if(!makePipes()) break;
        std::clock_t currentTime = std::clock();
        if(double(currentTime-startTurn)/CLOCKS_PER_SEC > 0.5) break;
    }

    optimizeAspiration();

    while(points_action() > 0)
    {
        std::clock_t currentTime = std::clock();
        if(double(currentTime-startTurn)/CLOCKS_PER_SEC > 0.5) break;
        if(!upgradePipes()) break;
    }

    std::cout << "== Fin de tour ==" << std::endl;
}

bool makePipes()
{
    auto alreadyConstructed = [](std::vector<position> path)
    {
        for(position pos : path)
        {
            if(!est_tuyau(pos)) return false;
        }
        return true;
    };

    std::vector<position> toBuild = choosePath(isBuildable, bestPath, alreadyConstructed);
    if(toBuild.empty())
    {
        std::cout << "Nothing to build" << std::endl;
        return false;
    }

    std::cout << "Going from ";
    printPos(toBuild.front());
    std::cout << " to ";
    printPos(toBuild.back());
    std::cout << std::endl;

    for(position p : toBuild) printPos(p);
    std::cout << std::endl;

    for(int i = toBuild.size()-1 ; i >= 0 ; i--)
    {
        position p = toBuild[i];

        if(est_tuyau(p)) continue;
        else if(points_action() == 0)
        {
            std::cout << "Need more actions to build !" << std::endl ;
            return false;
        }
        else if(est_debris(p))
        {
            if(points_action() < COUT_DEBLAYAGE) return false;
            deblayer(p);
        }

        std::cout << "Building at ";
        printPos(p);
        std::cout << std::endl;
        construire(p);
    }

    return true;
}

void optimizeAspiration()
{
    position usefullBase = position{0,0};
    position uselessBase = position{0,0};
    for(position p : ma_base())
    {
        bool linked = false;
        for(position dir : DIRECTIONS)
        {
            if(est_tuyau(p+dir)) linked = true;
        }

        if(linked && puissance_aspiration(p) != LIMITE_ASPIRATION) usefullBase = p;
        else if(puissance_aspiration(p) > 0) uselessBase = p;
    }

    if(usefullBase != position{0,0} && uselessBase != position{0,0})
    {
        deplacer_aspiration(uselessBase, usefullBase);
    }
}

void attackWeakOpponentPipe()
{
    int nbOpponentPipeTopLeft = 0;
    int nbOpponentPipeBottomRight = 0;
    position pipeTopLeft;
    position pipeBottomRight;
    for(position p : base_ennemie())
    {
        for(position dir : DIRECTIONS)
        {
            position pos = p+dir;
            if(est_tuyau(pos))
            {
                if(p.x == 0 || p.y == 0)
                {
                    nbOpponentPipeTopLeft++;
                    pipeTopLeft = pos;
                }
                else
                {
                    nbOpponentPipeBottomRight++;
                    pipeBottomRight = pos;
                }
            }
        }
    }
    if(nbOpponentPipeTopLeft == 1) detruire(pipeTopLeft);
    else if(nbOpponentPipeBottomRight == 1) detruire(pipeBottomRight);
}

bool upgradePipes()
{
    auto alreadyUpgraded = [](std::vector<position> path)
    {
        for(position pos : path)
        {
            if((pos.x + pos.y) % 2 && !est_super_tuyau(pos)) return false;
        }
        return true;
    };

    std::vector<position> toBuild = choosePath(est_tuyau, upgradePath, alreadyUpgraded);
    if(toBuild.empty())
    {
        std::cout << "Nothing to upgrade" << std::endl;
        return false;
    }

    std::cout << "Upgrade from ";
    printPos(toBuild.front());
    std::cout << " to ";
    printPos(toBuild.back());
    std::cout << std::endl;

    for(position p : toBuild) printPos(p);
    std::cout << std::endl;

    for(int i = toBuild.size()-1 ; i >= 0 ; i--)
    {
        position p = toBuild[i];
        if((p.x + p.y) % 2)
        {
            std::cout << "Upgrading at ";
            printPos(p);
            std::cout << std::endl;
            ameliorer(p);
        }
    }

    return true;
}
