#include "actions.h"
#include "loopavoider.h"

#ifdef DEBUG
#include <cstdio>
#endif

bool goToBestPortal()
{
#ifdef DEBUG
    std::printf("--New move (%d,%d)--\n", myPos().x, myPos().y);
    std::fflush(stdout);
#endif

    position portal;
    if(portalValue(myPos()) && !LoopAvoider::instance().checkLoop(myPos())) portal = myPos();
    else portal = bestPortal();
    LoopAvoider::instance().setNextObjective(portal);

    if(myPos() != portal)
    {
        while(points_deplacement() < distance(portal, myPos()))
        {
            if(points_action() < COUT_TURBO) break;
            utiliser_turbo();
        }

        if(deplacer(portal) != OK)
        {
            deplacer(interestingNear(myPos(), portal, points_deplacement()));
            return false;
        }
    }
    return true;
}

bool takePortal()
{
    if(portail_joueur(myPos()) == adversaire())
    {
        if(neutraliser() == PA_INSUFFISANTS) return false;
    }
    if(capturer() == PA_INSUFFISANTS) return false;

    return true;
}

bool fortifyPortal(int objective)
{
    while(portail_boucliers(myPos()) < objective)
    {
        if(ajouter_bouclier() != OK) return false;
    }
    return true;
}

bool createLinks()
{
#ifdef DEBUG
    std::printf("--New links (%d,%d)--\n", myPos().x, myPos().y);
    std::fflush(stdout);
#endif

    std::vector<position> linksToCreate = computeBestLinks(myPos());
    for(uint i = 0 ; i < linksToCreate.size() ; i++)
    {
#ifdef DEBUG
        std::printf("Link to (%d,%d)\n", linksToCreate[i].x, linksToCreate[i].y);
        std::fflush(stdout);
#endif
        erreur e = lier(linksToCreate[i]);
        if(e == PA_INSUFFISANTS) return false;
#ifdef DEBUG
        else if(e != OK) std::printf("Erreur création de lien : %d\n", e);
#endif
    }
    return true;
}
