#include "loopavoider.h"
#include "utils.h"

#ifdef DEBUG
#include <cstdio>
#endif

/**
 * Renvoie l'instance du LoopAvoider
 */
LoopAvoider& LoopAvoider::instance()
{
    static LoopAvoider instance;
    return instance;
}

/**
 * Initialise le LoopAvoider
 */
LoopAvoider::LoopAvoider()
{
    lastPos = -1;
    for(int i = 0 ; i < MAX_LOOP_SIZE ; i++)
    {
        oldPos[i] = StateData(position(-1,-1), position(-1,-1), position(-1,-1), 0);
    }
}

/**
 * Définit l'objectif de la position donnée
 */
void LoopAvoider::setNextObjective(position o)
{
    objective = o;
}

/**
 * Prévient le LoopAvoider que la position p a été atteinte avec un score spécifié
 */
void LoopAvoider::posReached(position myPos, position advPos, int score)
{
    lastPos++;
    lastPos %= MAX_LOOP_SIZE;

    oldPos[lastPos] = StateData(objective, myPos, advPos, score);
}

/**
 * Vérifie si il existe une boucle défavorable dans la situation actuelle si on va à p
 */
bool LoopAvoider::checkLoop(position p)
{
    int diffScore = 0;
    for(int i = 0 ; i < MAX_LOOP_SIZE ; i++)
    {
        int index = (lastPos-i+MAX_LOOP_SIZE) % MAX_LOOP_SIZE;

        position obj = oldPos[index].objective;
        position myPosition = oldPos[index].myPos;
        position advPos = oldPos[index].myPos;;
        diffScore += oldPos[index].score;

        if(obj == p && myPosition == myPos() && advPos == position_agent(adversaire()))
        {
#ifdef DEBUG
            std::printf("LOOP DETECTED !\n");
            std::fflush(stdout);
#endif
            if(diffScore*nbTurnLeft() + score(moi()) - score(adversaire()) < 0)
            {
                return true;
            }
        }
    }
    return false;
}
