#include "prologin.hh"
#include "actions.h"
#include "loopavoider.h"
#include <cstdio>

///
// Fonction appelée au début de la partie.
//
void partie_init()
{
    // Rien à initialiser
}

position pos = position(-1,-1);
position advPos = position(-1,-1);
int area = 0;

///
// Fonction appelée à chaque tour.
//
void jouer_tour()
{
#ifdef DEBUG
    std::printf("##### DEBUT DU TOUR (Player %d) #####\n", moi());
    std::fflush(stdout);
#endif

    area -= currentArea(adversaire());
    LoopAvoider::instance().posReached(pos, advPos, area);

    pos = myPos();
    advPos = position_agent(adversaire());

    while(true)
    {
        if(!goToBestPortal()) return;
        if(!takePortal()) return;
        if(!fortifyPortal(2)) return;
        if(!createLinks()) return;

        // Ceci permet de conserver mieux ses positions. Si on y arrive pas tant pis on passe à la suite
        if(liens_incidents_portail(myPos()).size()) fortifyPortal(6);
    }

    area = currentArea(moi());

#ifdef DEBUG
    std::printf("##### FIN DU TOUR #####\n");
#endif
    std::printf("%d) PA:%d PM:%d\n", tour_actuel(), points_action(), points_deplacement());
    std::fflush(stdout);
}

///
// Fonction appelée à la fin de la partie.
//
void partie_fin()
{
    // Rien à désallouer
}

