#include "global.h"

/**
 * @fn position remap(position pos)
 * Remappe la position comme si le joueur était le joueur 1
 * @param pos position à remapper
 * @return postion remappée
 */
position remap(position pos)
{
    bool horizontalRotation = false;
    bool verticalRotation = false;
    if(base_joueur(moi()).x) horizontalRotation = true;
    if(base_joueur(moi()).y) verticalRotation = true;

    if(horizontalRotation) pos.x = TAILLE_TERRAIN-1-pos.x;
    if(verticalRotation) pos.y = TAILLE_TERRAIN-1-pos.y;

    return pos;
}

position nearestEnemyTower(position pos)
{
    position posFound(-1, -1);
    int radius = 1;
    while(posFound.x == -1 && radius < TAILLE_TERRAIN)
    {
        for(int x = pos.x - radius ; x < pos.x + radius ; x++)
        {
            for(int y = pos.y - radius ; y < pos.y + radius ; y++)
            {
                if(info_case(remap(position(x, y))) == CASE_TOURELLE && joueur_case(remap(position(x, y))) != moi())
                    posFound = position(x, y);
            }
        }
        radius++;
    }
    if(posFound.x == -1) return position(0, 0);
    return posFound;
}

int countEnemyTowerAttacking(position pos)
{
    int count = 0;
    int deltaY = -1;
    for(int x = pos.x - 7 ; x <= pos.x + 7 ; x++)
    {
        if(x > pos.x) deltaY -= 1;
        else deltaY += 1;
        if(x < 0 || x >= TAILLE_TERRAIN) continue;

        for(int y = pos.y - deltaY ; y <= pos.y + deltaY ; y++)
        {
            if(y < 0 || y >= TAILLE_TERRAIN) continue;
            if(info_case(remap(position(x, y))) == CASE_TOURELLE)
            {
                tourelle t = tourelle_case(remap(position(x, y)));
                if(t.portee <= manhatanDist(t.pos, pos)) count++;
            }
        }
    }
    return count;
}

int countEnemyAround(position pos, int radius)
{
    int count = 0;
    int deltaY = -1;
    for(int x = pos.x - radius ; x <= pos.x + radius ; x++)
    {
        if(x > pos.x) deltaY -= 1;
        else deltaY += 1;
        if(x < 0 || x >= TAILLE_TERRAIN) continue;

        for(int y = pos.y - deltaY ; y <= pos.y + deltaY ; y++)
        {
            if(y < 0 || y >= TAILLE_TERRAIN) continue;

            int own = joueur_case(remap(position(x, y)));
            if(own == moi()) continue;
            count += nb_sorciers(remap(position(x, y)), own);
        }
    }
    return count;
}

/**
 * @fn void partie_debut()
 * Fonction appelée au début de la partie
 */
void partie_debut()
{
    //
}

/**
 * Fonction appelée à la fin de la partie
 */
void partie_fin()
{
    //
}

