#include "global.h"


/**
 * @fn position remap(position pos)
 * Remappe la position comme si le joueur était le joueur 1
 * @param pos position à remapper
 * @return postion remappée
 */
position remap(position pos)
{
    bool horizontalRotation = false;
    bool verticalRotation = false;
    if(base_joueur(moi()).x) horizontalRotation = true;
    if(base_joueur(moi()).y) verticalRotation = true;

    if(horizontalRotation) pos.x = TAILLE_TERRAIN-1-pos.x;
    if(verticalRotation) pos.y = TAILLE_TERRAIN-1-pos.y;

    return pos;
}

position nearestEnemyTower(position pos)
{
    position posFound(-1, -1);
    int radius = 1;
    while(posFound.x == -1 && radius < TAILLE_TERRAIN)
    {
        for(int x = pos.x - radius ; x < pos.x + radius ; x++)
        {
            for(int y = pos.y - radius ; y < pos.y + radius ; y++)
            {
                if(info_case(position(x, y)) == CASE_TOURELLE)
                {
                    if(tourelle_case(position(x, y)).joueur != moi()) posFound = position(x, y);
                }
            }
        }
        radius++;
    }
    if(posFound.x == -1) return position(0, 0);
    return posFound;
}

position nearestAllyTower(position pos)
{
    position posFound(-1, -1);
    int radius = 1;
    while(posFound.x == -1 && radius < TAILLE_TERRAIN)
    {
        for(int x = pos.x - radius ; x < pos.x + radius ; x++)
        {
            for(int y = pos.y - radius ; y < pos.y + radius ; y++)
            {
                if(Map::getInstance()->haveTower(position(x, y))) posFound = position(x, y);
            }
        }
        radius++;
    }
    if(posFound.x == -1) return position(0, 0);
    return posFound;
}

/**
 * @fn void partie_debut()
 * Fonction appelée au début de la partie
 */
void partie_debut()
{
    Map::getInstance();
}

///
// Fonction appelée à la fin de la partie
//
void partie_fin()
{
    Map::deleteInstance();
}

