#ifndef MAP_H
#define MAP_H

#include "prologin.h"
#include <map>
#include <set>
#include <vector>

class Map
{
public:
    static Map* getInstance();
    static void deleteInstance();
    void addWizard(int, position = position(0, 0));
    void moveWizard(int, position, position);
    void loseWizard(int, position);
    std::vector<position> wizPos();

    void addTower(position);
    void removeTower(position);
    bool haveTower(position);
private:
    Map();
    std::map<position, int> myWizMap;
    std::set<position> myTowerMap;
    static Map* instance;
};

bool inline operator<(const position a, const position b) { return a.x*TAILLE_TERRAIN + a.y < b.x*TAILLE_TERRAIN + b.y; }

#endif // MAP_H
