#ifndef GLOBAL_H
#define GLOBAL_H

#include "prologin.h"

position remap(position pos);
position nearestEnemyTower(position pos);
int countEnemyTowerAttacking(position pos);
int countEnemyAround(position pos, int radius);

inline int abs(int n) { return n > 0 ? n : -n; }
inline int manhatanDist(position a, position b) { return abs(a.x - b.x) + abs(a.y - b.y); }

inline bool operator==(const position& a, const position& b) { return a.x == b.x && a.y == b.y; }
inline bool operator!=(const position& a, const position& b) { return !(a==b); }
inline bool operator<(const position& a, const position& b) { return a.x*TAILLE_TERRAIN + a.y < b.x*TAILLE_TERRAIN + b.y; }

#endif // GLOBAL_H
