#include "global.h"
#include <iostream>

int dangerMap[TAILLE_TERRAIN][TAILLE_TERRAIN];
int enemyMap[TAILLE_TERRAIN][TAILLE_TERRAIN];

void increaseZoneDanger(position pos)
{
    dangerMap[pos.x][pos.y] += 10;
    if(pos.x >= 0) dangerMap[pos.x - 1][pos.y] += 5;
    if(pos.y >= 0) dangerMap[pos.x][pos.y - 1] += 5;
    if(pos.x + 1 < TAILLE_TERRAIN) dangerMap[pos.x + 1][pos.y] += 5;
    if(pos.y + 1 < TAILLE_TERRAIN) dangerMap[pos.x][pos.y + 1] += 5;
}

void initDangerMap()
{
    for(int x = 0 ; x < TAILLE_TERRAIN ; x++)
    {
        for(int y = 0 ; y < TAILLE_TERRAIN ; y++)
        {
            int danger = 50 - manhatanDist(position(0,0), position(x, y));
            dangerMap[x][y] = danger;
        }
    }

    increaseZoneDanger(position(0,15));
    increaseZoneDanger(position(15,0));
    increaseZoneDanger(position(15,15));
    increaseZoneDanger(position(15,30));
    increaseZoneDanger(position(30,15));
}

void initEnemyMap()
{
    for(int x = 0 ; x < TAILLE_TERRAIN ; x++)
    {
        for(int y = 0 ; y < TAILLE_TERRAIN ; y++)
        {
            int player = joueur_case(remap(position(x, y)));
            if(!player || player == moi()) enemyMap[x][y] = 0;
            else
            {
                int wiz = nb_sorciers(remap(position(x, y)), player);
                enemyMap[x][y] = wiz;
            }
        }
    }
}

std::vector<position> getShootable(position from, int radius)
{
    std::vector<position> result;
    int deltaY = -1;
    //std::cout << from.x << '$' << from.y << '$' << radius << " ";
    for(int x = from.x - radius ; x <= from.x + radius ; x++)
    {
        if(x > from.x) deltaY -= 1;
        else deltaY += 1;
        if(x < 0 || x >= TAILLE_TERRAIN) continue;

        for(int y = from.y - deltaY ; y <= from.y + deltaY ; y++)
        {
            if(y < 0 || y >= TAILLE_TERRAIN) continue;
            if(enemyMap[x][y])
            {
                result.push_back(position(x, y));
                //std::cout << x << "-" << y << "  ";
            }
        }
    }

    return result;
}

/**
 * Fonction appelée pendant la phase de tirs des tourelles
 */
void phase_tirs()
{
    initDangerMap();
    initEnemyMap();

    std::vector<tourelle> tourelles = tourelles_joueur(moi());
    //for(tourelle t : tourelles) std::cout << t.pos.x << "+" << t.pos.y << ' ';
    for(tourelle t : tourelles) increaseZoneDanger(remap(t.pos));
    for(tourelle t : tourelles)
    {
        std::vector<position> shootable = getShootable(remap(t.pos), t.portee);
        //for(position p : shootable) std::cout << p.x << "*" << p.y << "  ";
        bool end = false;
        while(t.attaque && !end)
        {
            position maxRisk = position(-1, -1);
            int riskMax = -1;
            int toKill = 0;
            for(position e : shootable)
            {
                int risk = dangerMap[e.x][e.y];
                if(risk > riskMax)
                {
                    maxRisk = e;
                    riskMax = risk;
                    toKill = enemyMap[e.x][e.y];
                }
            }

            if(riskMax == -1) end = true;
            else
            {
                if(toKill > t.attaque) toKill = t.attaque;
                //std::cout << maxRisk.x << "*" << maxRisk.y;
                t.attaque -= toKill;
                tirer(toKill, t.pos, remap(maxRisk));
            }
        }
    }
}
