#include "global.h"

/**
 * @fn position remap(position pos)
 * Remappe la position comme si le joueur était le joueur 1
 * Cette fonction est a appeler sur toute les données entrantes ou sortantes de l'API
 * @param pos position à remapper
 * @return postion remappée
 */
position remap(position pos)
{
    bool horizontalRotation = false;
    bool verticalRotation = false;
    if(base_joueur(moi()).x) horizontalRotation = true;
    if(base_joueur(moi()).y) verticalRotation = true;

    if(horizontalRotation) pos.x = TAILLE_TERRAIN-1-pos.x;
    if(verticalRotation) pos.y = TAILLE_TERRAIN-1-pos.y;

    return pos;
}

/**
 * @fn position nearestEnemyTower(position pos)
 * Renvoie la position de la tourelle ennemie la plus proche
 * @param pos position à partir de laquelle rechercher
 * @return position de la tourelle la plus proche
 */
position nearestEnemyTower(position pos)
{
    position posFound(-1, -1);
    int radius = 1;
    while(posFound.x == -1 && radius < TAILLE_TERRAIN)
    {
        for(int x = pos.x - radius ; x < pos.x + radius ; x++)
        {
            for(int y = pos.y - radius ; y < pos.y + radius ; y++)
            {
                if(info_case(remap(position(x, y))) == CASE_TOURELLE && joueur_case(remap(position(x, y))) != moi())
                    posFound = position(x, y);
            }
        }
        radius++;
    }
    if(posFound.x == -1) return position(0, 0);
    return posFound;
}

/**
 * @fn int countEnemyTowerAttacking(position pos)
 * Compte le nombre de tourelles qui pourraient attaquer une position définie
 * @param pos position attaquable
 * @return le nombre de positions attaquables
 */
int countEnemyTowerAttacking(position pos)
{
    int count = 0;
    int deltaY = -1;
    for(int x = pos.x - 7 ; x <= pos.x + 7 ; x++)
    {
        if(x > pos.x) deltaY -= 1;
        else deltaY += 1;
        if(x < 0 || x >= TAILLE_TERRAIN) continue;

        for(int y = pos.y - deltaY ; y <= pos.y + deltaY ; y++)
        {
            if(y < 0 || y >= TAILLE_TERRAIN) continue;
            if(info_case(remap(position(x, y))) == CASE_TOURELLE)
            {
                tourelle t = tourelle_case(remap(position(x, y)));
                if(t.portee <= manhatanDist(t.pos, pos)) count++;
            }
        }
    }
    return count;
}

/**
 * @fn int countEnemyAround(position pos, int radius)
 * Compte le nombre d'ennemis autour d'une position donnée
 * @param pos position a partir de laquelle compter
 * @param radius rayon pour lequel comptabiliser le nombre d'ennemis
 * @return nombre d'ennemis autour de la position
 */
int countEnemyAround(position pos, int radius)
{
    int count = 0;
    int deltaY = -1;
    for(int x = pos.x - radius ; x <= pos.x + radius ; x++)
    {
        if(x > pos.x) deltaY -= 1;
        else deltaY += 1;
        if(x < 0 || x >= TAILLE_TERRAIN) continue;

        for(int y = pos.y - deltaY ; y <= pos.y + deltaY ; y++)
        {
            if(y < 0 || y >= TAILLE_TERRAIN) continue;

            int own = joueur_case(remap(position(x, y)));
            if(own == moi()) continue;
            count += nb_sorciers(remap(position(x, y)), own);
        }
    }
    return count;
}

/**
 * @fn void partie_debut()
 * Fonction appelée au début de la partie par l'API
 */
void partie_debut()
{
    // Aucune initialisation particulière...
}

/**
 * Fonction appelée à la fin de la partie par l'API
 */
void partie_fin()
{
    // Aucune libération particulière...
}

