#include "global.h"
#include <iostream>

std::vector<position> pathTo(position from, position to)
{
    std::map<position, position> checked;
    checked[from] = from;
    std::vector<position> toCheck;
    toCheck.push_back(from);
    std::vector<position> nextToCheck;
    while(toCheck.size())
    {
        for(position p : toCheck)
        {
            if(p == to)
            {
                std::vector<position> solution;
                solution.push_back(to);
                while(solution.front() != from)
                {
                    solution.insert(solution.begin(), checked[solution.front()]);
                    return solution;
                }
            }
            if(p.x-1 >= 0)
            {
                position newP = p;
                newP.x -= 1;
                checked[newP] = p;
                nextToCheck.push_back(newP);
            }
            if(p.y-1 >= 0)
            {
                position newP = p;
                newP.y -= 1;
                checked[newP] = p;
                nextToCheck.push_back(newP);
            }
            if(p.x+1 <= TAILLE_TERRAIN)
            {
                position newP = p;
                newP.x += 1;
                checked[newP] = p;
                nextToCheck.push_back(newP);
            }
            if(p.y+1 <= TAILLE_TERRAIN)
            {
                position newP = p;
                newP.y += 1;
                checked[newP] = p;
                nextToCheck.push_back(newP);
            }
        }
        toCheck = nextToCheck;
        nextToCheck.clear();
    }

    return std::vector<position>();
}

void firstTurnsConstruction()
{
    int nbWiz = MAGIE_TOUR / COUT_SORCIER;
    creer(nbWiz);
    Map::getInstance()->addWizard(nbWiz);
}

enum TowerGoal
{
    DIAGONAL,
    FONTAINE1,
    FONTAINE2,
    DEFENSE
};

void towerConstruction()
{
    static int goal = FONTAINE1;
    static bool maxX = false;
    while(magie(moi()) >= COUT_TOURELLE && goal != DEFENSE)
    {
        position newTowerPos = position(-1,-1);
        if(goal == DIAGONAL)
        {
            position towerNearObj = nearestAllyTower(position(14, 14));
            int offsetX = maxX ? 2 : 1;
            int offsetY = maxX ? 1 : 2;
            newTowerPos = position(towerNearObj.x + offsetX, towerNearObj.y + offsetY);
            maxX = !maxX;

            if(!constructible(remap(newTowerPos), moi())) goal += 1;
        }
        else if(goal == FONTAINE1 || goal == FONTAINE2)
        {
            position objectiveTower;
            if(goal == FONTAINE1) objectiveTower = position(14, 0);
            else objectiveTower = position(0, 15);
            position towerNearObj = nearestAllyTower(objectiveTower);

            std::vector<position> path = chemin(towerNearObj, position(0, 15));
            newTowerPos = path[2];
            if(!constructible(remap(newTowerPos), moi())) newTowerPos = path[1];
            if(!constructible(remap(newTowerPos), moi())) goal += 1;

        }
        Map::getInstance()->addTower(newTowerPos);
        if(magie(moi()) > COUT_TOURELLE + COUT_PORTEE + 4) construire(remap(newTowerPos), PORTEE_TOURELLE + 2);
        else construire(remap(newTowerPos), PORTEE_TOURELLE);
    }
}

/**
 * Fonction appelée pendant la phase de construction
 */
void phase_construction()
{
    int currentTurn = tour_actuel();
    if(currentTurn < 3) firstTurnsConstruction();
    else towerConstruction();
}
