#include "global.h"

Map* Map::instance = 0;

Map::Map()
{
}

Map* Map::getInstance()
{
    if(!instance) instance = new Map;
    return instance;
}

void Map::deleteInstance()
{
    if(instance) delete instance;
}

void Map::addWizard(int num, position pos)
{
    int currentWiz = 0;
    if(myWizMap.count(pos)) currentWiz = myWizMap[pos];
    myWizMap[pos] = currentWiz + num;
}

void Map::moveWizard(int num, position orig, position pos)
{
    loseWizard(num, orig);
    addWizard(num, pos);
}

void Map::loseWizard(int num, position pos)
{
    if(!myWizMap.count(pos)) return;
    int currentWiz = myWizMap[pos];
    if(currentWiz < num) myWizMap.erase(pos);
    myWizMap[pos] = currentWiz - num;
}

std::vector<position> Map::wizPos()
{
    std::vector<position> pos;
    for(std::pair<position, int> t : myWizMap)
    {
        pos.push_back(t.first);
    }
    return pos;
}

void Map::addTower(position p)
{
    myTowerMap.insert(p);
}

void Map::removeTower(position p)
{
    myTowerMap.erase(p);
}

bool Map::haveTower(position p)
{
    return(myTowerMap.count(p));
}
