#include "global.h"
#include "WizardGroup.h"
#include <iostream>

std::vector<WizardGroup*> wizGrp;

/**
 * Fonction appelée pendant la phase de déplacement
 */
void phase_deplacement()
{
    if(tour_actuel() == 0)
    {
        WizardGroup* g = new WizardGroup(position(0,0));
        g->setDestination(position(15, 0));
        wizGrp.push_back(g);
    }
    else if(tour_actuel() == 2)
    {
        WizardGroup* g = new WizardGroup(position(0,0));
        g->setDestination(position(0, 15));
        wizGrp.push_back(g);
    }
    else if(countEnemyAround(position(0, 0), 9) > 40 || countEnemyAround(position(0, 0), 5) > 20)
    {
        if(countEnemyAround(position(0,0), 9) - 40 > nb_sorciers(remap(position(0, 0)), moi()));
        std::cout << "DANGER !";
        for(WizardGroup* g : wizGrp)
        {
            g->setDestination(position(0,0));
        }
    }
    else if(tour_actuel() >= 90 && tour_actuel() <= 92)
    {
        WizardGroup* g = new WizardGroup(position(0,0), nb_sorciers(remap(position(0,0)), moi()) - 50);
        wizGrp.push_back(g);
        for(WizardGroup* g : wizGrp)
        {
            g->setDestination(position(15,15));
        }
    }
    else
    {
        int menaceTourelleTop = countEnemyTowerAttacking(position(0, 15));
        int menaceTourelleLeft = countEnemyTowerAttacking(position(15,0));

        int nbEnemiesTop = nb_sorciers(remap(position(0, 15)), joueur_case(remap(position(0, 15))));
        int allyRequiredTop = nbEnemiesTop + 11 + countEnemyAround(position(0, 15), 5)/2 + (menaceTourelleTop*10);
        if(joueur_case(remap(position(0, 15))) == moi()) allyRequiredTop = 0;

        int nbEnemiesLeft = nb_sorciers(remap(position(15, 0)), joueur_case(remap(position(15, 0))));
        int allyRequiredLeft = nbEnemiesLeft + 11 + countEnemyAround(position(15, 0), 5)/2 + (menaceTourelleLeft*10);
        if(joueur_case(remap(position(15, 0))) == moi()) allyRequiredLeft = 0;


        int sorciersBase = nb_sorciers(remap(position(0,0)), moi());

        if(allyRequiredLeft + allyRequiredTop < sorciersBase)
        {
            WizardGroup* gTop = new WizardGroup(position(0,0), allyRequiredTop);
            gTop->setDestination(position(0, 15));
            wizGrp.push_back(gTop);

            WizardGroup* gLeft = new WizardGroup(position(0,0), allyRequiredLeft);
            gLeft->setDestination(position(15, 0));
            wizGrp.push_back(gLeft);
        }
        else
        {
            position destination = position(-1, -1);
            int allyRequired = 0;

            if(allyRequiredTop && allyRequiredTop < allyRequiredLeft)
            {
                destination = position(0,15);
                allyRequired = allyRequiredTop;
            }
            else if(allyRequiredLeft)
            {
                destination = position(15,0);
                allyRequired = allyRequiredLeft;
            }
            /*else if(menaceTourelleTop)
            {
                destination = nearestEnemyTower(position(0, 15));
                allyRequired = countEnemyTowerAttacking(destination)*30;
            }
            else if(menaceTourelleLeft)
            {
                destination = nearestEnemyTower(position(15, 0));
                allyRequired = countEnemyTowerAttacking(destination)*30;
            }*/

            if(allyRequired >= sorciersBase) allyRequired = 0;
            if(allyRequired > 0)
            {
                std::cout << "\nTour sorcier " << allyRequired << "#" << allyRequiredTop << "#" << allyRequiredLeft;

                WizardGroup* g = new WizardGroup(position(0,0), allyRequired);
                g->setDestination(destination);
                wizGrp.push_back(g);
            }
        }
    }

    for(WizardGroup* g : wizGrp)
    {
        g->doAction();
    }
}

/**
 * Fonction appelée pendant la phase de siège des tourelles
 */
void phase_siege()
{
    for(WizardGroup* g : wizGrp)
    {
        g->atkNearestTower();
    }
}
