/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_php.rb

#include "interface.hh"

static void _init_php();

template <typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
zval cxx2lang<zval, int>(int in)
{
    zval x;
    ZVAL_LONG(&x, (long)in);
    return x;
}

template <>
zval cxx2lang<zval, bool>(bool in)
{
    zval x;
    ZVAL_BOOL(&x, in);
    return x;
}

template <>
zval cxx2lang<zval, double>(double in)
{
    zval x;
    ZVAL_DOUBLE(&x, in);
    return x;
}

template <>
zval cxx2lang<zval, std::string>(std::string in)
{
    zval x;
    ZVAL_STRINGL(&x, in.c_str(), in.length());
    return x;
}

template <typename Cxx>
zval cxx2lang_array(const std::vector<Cxx>& in)
{
    zval x;
    array_init(&x);

    size_t s = in.size();

    for (size_t i = 0; i < s; ++i) {
      zval tmp = cxx2lang<zval, Cxx>(in[i]);
      add_next_index_zval(&x, &tmp);
    }

    return x;
}

template <typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
int lang2cxx<zval*, int>(zval* in)
{
    if (Z_TYPE_P(in) != IS_LONG) {
        zend_error(E_WARNING, "parameter should be an int");
        throw 42;
    }
    return (int)Z_LVAL_P(in);
}

template <>
double lang2cxx<zval*, double>(zval* in)
{
    if (Z_TYPE_P(in) != IS_DOUBLE) {
        zend_error(E_WARNING, "parameter should be a double");
        throw 42;
    }
    return (double)Z_DVAL_P(in);
}

template <>
bool lang2cxx<zval*, bool>(zval* in)
{
    if (Z_TYPE_P(in) != IS_TRUE && Z_TYPE_P(in) != IS_FALSE) {
        zend_error(E_WARNING, "parameter should be a boolean");
        throw 42;
    }
    return (bool)(Z_TYPE_P(in) == IS_TRUE);
}

template <>
std::string lang2cxx<zval*, std::string>(zval* in)
{
    if (Z_TYPE_P(in) != IS_STRING) {
        zend_error(E_WARNING, "parameter should be a string");
        throw 42;
    }
    return Z_STRVAL_P(in);
}

template <typename Cxx>
std::vector<Cxx> lang2cxx_array(zval* in)
{
    if (Z_TYPE_P(in) != IS_ARRAY) {
        zend_error(E_WARNING, "parameter should be an array");
        throw 42;
    }

    HashTable* ht = Z_ARRVAL_P(in);
    std::vector<Cxx> out;
    size_t s = zend_hash_num_elements(ht);

    for (size_t i = 0; i < s; ++i)
    {
        zval* v = zend_hash_index_find(ht, i);
        out.push_back(lang2cxx<zval*, Cxx>(v));
    }

    return out;
}
/// Types de cases
template <>
zval cxx2lang<zval, case_type>(case_type in)
{
    return cxx2lang<zval, int>((int)in);
}

template <>
case_type lang2cxx<zval*, case_type>(zval* in)
{
    return (case_type)lang2cxx<zval*, int>(in);
}

/// Direction
template <>
zval cxx2lang<zval, direction>(direction in)
{
    return cxx2lang<zval, int>((int)in);
}

template <>
direction lang2cxx<zval*, direction>(zval* in)
{
    return (direction)lang2cxx<zval*, int>(in);
}

/// Erreurs possibles
template <>
zval cxx2lang<zval, erreur>(erreur in)
{
    return cxx2lang<zval, int>((int)in);
}

template <>
erreur lang2cxx<zval*, erreur>(zval* in)
{
    return (erreur)lang2cxx<zval*, int>(in);
}

/// Types d'actions
template <>
zval cxx2lang<zval, action_type>(action_type in)
{
    return cxx2lang<zval, int>((int)in);
}

template <>
action_type lang2cxx<zval*, action_type>(zval* in)
{
    return (action_type)lang2cxx<zval*, int>(in);
}

/// Types de drapeaux de débug
template <>
zval cxx2lang<zval, debug_drapeau>(debug_drapeau in)
{
    return cxx2lang<zval, int>((int)in);
}

template <>
debug_drapeau lang2cxx<zval*, debug_drapeau>(zval* in)
{
    return (debug_drapeau)lang2cxx<zval*, int>(in);
}

/// Position dans la mine, donnée par deux coordonnées.
template <>
zval cxx2lang<zval, position>(position in)
{
    zval ret;
    zval tmp;
    array_init(&ret);
    tmp = (cxx2lang<zval, int>(in.ligne));
    add_assoc_zval(&ret, "ligne", &tmp);
    tmp = (cxx2lang<zval, int>(in.colonne));
    add_assoc_zval(&ret, "colonne", &tmp);
    return ret;
}

template <>
position lang2cxx<zval*, position>(zval* in)
{
    position out;
    if (Z_TYPE_P(in) != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    HashTable* ht = Z_ARRVAL_P(in);
    zval* tmp = NULL;
    tmp = zend_hash_str_find(ht, "ligne", 5);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"ligne\" of struct \"position\" not found");
        throw 42;
    }
    out.ligne = lang2cxx<zval*, int>(tmp);

    tmp = zend_hash_str_find(ht, "colonne", 7);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"colonne\" of struct \"position\" not found");
        throw 42;
    }
    out.colonne = lang2cxx<zval*, int>(tmp);

    return out;
}

/// Minerai à récolter
template <>
zval cxx2lang<zval, minerai>(minerai in)
{
    zval ret;
    zval tmp;
    array_init(&ret);
    tmp = (cxx2lang<zval, int>(in.resistance));
    add_assoc_zval(&ret, "resistance", &tmp);
    tmp = (cxx2lang<zval, int>(in.rendement));
    add_assoc_zval(&ret, "rendement", &tmp);
    return ret;
}

template <>
minerai lang2cxx<zval*, minerai>(zval* in)
{
    minerai out;
    if (Z_TYPE_P(in) != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    HashTable* ht = Z_ARRVAL_P(in);
    zval* tmp = NULL;
    tmp = zend_hash_str_find(ht, "resistance", 10);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"resistance\" of struct \"minerai\" not found");
        throw 42;
    }
    out.resistance = lang2cxx<zval*, int>(tmp);

    tmp = zend_hash_str_find(ht, "rendement", 9);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"rendement\" of struct \"minerai\" not found");
        throw 42;
    }
    out.rendement = lang2cxx<zval*, int>(tmp);

    return out;
}

/// Nain (standard)
template <>
zval cxx2lang<zval, nain>(nain in)
{
    zval ret;
    zval tmp;
    array_init(&ret);
    tmp = (cxx2lang<zval, position>(in.pos));
    add_assoc_zval(&ret, "pos", &tmp);
    tmp = (cxx2lang<zval, int>(in.vie));
    add_assoc_zval(&ret, "vie", &tmp);
    tmp = (cxx2lang<zval, int>(in.pa));
    add_assoc_zval(&ret, "pa", &tmp);
    tmp = (cxx2lang<zval, int>(in.pm));
    add_assoc_zval(&ret, "pm", &tmp);
    tmp = (cxx2lang<zval, bool>(in.accroche));
    add_assoc_zval(&ret, "accroche", &tmp);
    tmp = (cxx2lang<zval, int>(in.butin));
    add_assoc_zval(&ret, "butin", &tmp);
    return ret;
}

template <>
nain lang2cxx<zval*, nain>(zval* in)
{
    nain out;
    if (Z_TYPE_P(in) != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    HashTable* ht = Z_ARRVAL_P(in);
    zval* tmp = NULL;
    tmp = zend_hash_str_find(ht, "pos", 3);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"pos\" of struct \"nain\" not found");
        throw 42;
    }
    out.pos = lang2cxx<zval*, position>(tmp);

    tmp = zend_hash_str_find(ht, "vie", 3);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"vie\" of struct \"nain\" not found");
        throw 42;
    }
    out.vie = lang2cxx<zval*, int>(tmp);

    tmp = zend_hash_str_find(ht, "pa", 2);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"pa\" of struct \"nain\" not found");
        throw 42;
    }
    out.pa = lang2cxx<zval*, int>(tmp);

    tmp = zend_hash_str_find(ht, "pm", 2);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"pm\" of struct \"nain\" not found");
        throw 42;
    }
    out.pm = lang2cxx<zval*, int>(tmp);

    tmp = zend_hash_str_find(ht, "accroche", 8);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"accroche\" of struct \"nain\" not found");
        throw 42;
    }
    out.accroche = lang2cxx<zval*, bool>(tmp);

    tmp = zend_hash_str_find(ht, "butin", 5);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"butin\" of struct \"nain\" not found");
        throw 42;
    }
    out.butin = lang2cxx<zval*, int>(tmp);

    return out;
}

/// Action de déplacement représentée dans l'historique.
template <>
zval cxx2lang<zval, action_hist>(action_hist in)
{
    zval ret;
    zval tmp;
    array_init(&ret);
    tmp = (cxx2lang<zval, action_type>(in.atype));
    add_assoc_zval(&ret, "atype", &tmp);
    tmp = (cxx2lang<zval, int>(in.id_nain));
    add_assoc_zval(&ret, "id_nain", &tmp);
    tmp = (cxx2lang<zval, direction>(in.dir));
    add_assoc_zval(&ret, "dir", &tmp);
    tmp = (cxx2lang<zval, direction>(in.sens));
    add_assoc_zval(&ret, "sens", &tmp);
    return ret;
}

template <>
action_hist lang2cxx<zval*, action_hist>(zval* in)
{
    action_hist out;
    if (Z_TYPE_P(in) != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    HashTable* ht = Z_ARRVAL_P(in);
    zval* tmp = NULL;
    tmp = zend_hash_str_find(ht, "atype", 5);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"atype\" of struct \"action_hist\" not found");
        throw 42;
    }
    out.atype = lang2cxx<zval*, action_type>(tmp);

    tmp = zend_hash_str_find(ht, "id_nain", 7);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"id_nain\" of struct \"action_hist\" not found");
        throw 42;
    }
    out.id_nain = lang2cxx<zval*, int>(tmp);

    tmp = zend_hash_str_find(ht, "dir", 3);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"dir\" of struct \"action_hist\" not found");
        throw 42;
    }
    out.dir = lang2cxx<zval*, direction>(tmp);

    tmp = zend_hash_str_find(ht, "sens", 4);
    if (tmp == NULL) {
        zend_error(E_WARNING, "field \"sens\" of struct \"action_hist\" not found");
        throw 42;
    }
    out.sens = lang2cxx<zval*, direction>(tmp);

    return out;
}

/// Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
PHP_FUNCTION(php_api_chemin)
{
    zval* _pos1;
    zval* _pos2;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_pos1, &_pos2) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang_array(api_chemin(lang2cxx<zval*, position>(_pos1), lang2cxx<zval*, position>(_pos2)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
PHP_FUNCTION(php_api_deplacer)
{
    zval* _id_nain;
    zval* _dir;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_id_nain, &_dir) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, erreur>(api_deplacer(lang2cxx<zval*, int>(_id_nain), lang2cxx<zval*, direction>(_dir)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Le nain (standard) ``id_nain`` lâche la paroi.
PHP_FUNCTION(php_api_lacher)
{
    zval* _id_nain;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id_nain) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, erreur>(api_lacher(lang2cxx<zval*, int>(_id_nain)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Le nain (standard) ``id_nain`` s'agrippe à la paroi.
PHP_FUNCTION(php_api_agripper)
{
    zval* _id_nain;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id_nain) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, erreur>(api_agripper(lang2cxx<zval*, int>(_id_nain)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
PHP_FUNCTION(php_api_miner)
{
    zval* _id_nain;
    zval* _dir;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_id_nain, &_dir) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, erreur>(api_miner(lang2cxx<zval*, int>(_id_nain), lang2cxx<zval*, direction>(_dir)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
PHP_FUNCTION(php_api_tirer)
{
    zval* _id_nain;
    zval* _dir_corde;
    zval* _sens;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &_id_nain, &_dir_corde, &_sens) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, erreur>(api_tirer(lang2cxx<zval*, int>(_id_nain), lang2cxx<zval*, direction>(_dir_corde), lang2cxx<zval*, direction>(_sens)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
PHP_FUNCTION(php_api_poser_corde)
{
    zval* _id_nain;
    zval* _dir;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_id_nain, &_dir) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, erreur>(api_poser_corde(lang2cxx<zval*, int>(_id_nain), lang2cxx<zval*, direction>(_dir)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le drapeau spécifié sur la case indiquée.
PHP_FUNCTION(php_api_debug_afficher_drapeau)
{
    zval* _pos;
    zval* _drapeau;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_pos, &_drapeau) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, erreur>(api_debug_afficher_drapeau(lang2cxx<zval*, position>(_pos), lang2cxx<zval*, debug_drapeau>(_drapeau)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie le type d'une case donnée.
PHP_FUNCTION(php_api_type_case)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, case_type>(api_type_case(lang2cxx<zval*, position>(_pos)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie la liste de toutes les positions occupées par une corde dans la mine.
PHP_FUNCTION(php_api_liste_cordes)
{
    try {
        zval ret = cxx2lang_array(api_liste_cordes());
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Indique si une corde se trouve sur une case donnée.
PHP_FUNCTION(php_api_corde_sur_case)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, bool>(api_corde_sur_case(lang2cxx<zval*, position>(_pos)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
PHP_FUNCTION(php_api_nain_sur_case)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, int>(api_nain_sur_case(lang2cxx<zval*, position>(_pos)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
PHP_FUNCTION(php_api_info_nain)
{
    zval* _id_joueur;
    zval* _id_nain;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_id_joueur, &_id_nain) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, nain>(api_info_nain(lang2cxx<zval*, int>(_id_joueur), lang2cxx<zval*, int>(_id_nain)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie la liste de tous les minerais dans la mine.
PHP_FUNCTION(php_api_liste_minerais)
{
    try {
        zval ret = cxx2lang_array(api_liste_minerais());
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
PHP_FUNCTION(php_api_info_minerai)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, minerai>(api_info_minerai(lang2cxx<zval*, position>(_pos)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
PHP_FUNCTION(php_api_cout_de_deplacement)
{
    zval* _id_nain;
    zval* _dir;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_id_nain, &_dir) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, int>(api_cout_de_deplacement(lang2cxx<zval*, int>(_id_nain), lang2cxx<zval*, direction>(_dir)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
PHP_FUNCTION(php_api_position_taverne)
{
    zval* _id_joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, position>(api_position_taverne(lang2cxx<zval*, int>(_id_joueur)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
PHP_FUNCTION(php_api_historique)
{
    try {
        zval ret = cxx2lang_array(api_historique());
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
PHP_FUNCTION(php_api_score)
{
    zval* _id_joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
        zval ret = cxx2lang<zval, int>(api_score(lang2cxx<zval*, int>(_id_joueur)));
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie votre numéro de joueur.
PHP_FUNCTION(php_api_moi)
{
    try {
        zval ret = cxx2lang<zval, int>(api_moi());
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Renvoie le numéro de joueur de votre adversaire.
PHP_FUNCTION(php_api_adversaire)
{
    try {
        zval ret = cxx2lang<zval, int>(api_adversaire());
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
PHP_FUNCTION(php_api_annuler)
{
    try {
        zval ret = cxx2lang<zval, bool>(api_annuler());
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Retourne le numéro du tour actuel.
PHP_FUNCTION(php_api_tour_actuel)
{
    try {
        zval ret = cxx2lang<zval, int>(api_tour_actuel());
        RETURN_ZVAL(&ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type case_type
PHP_FUNCTION(php_api_afficher_case_type)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_case_type(lang2cxx<zval*, case_type>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type direction
PHP_FUNCTION(php_api_afficher_direction)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_direction(lang2cxx<zval*, direction>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type erreur
PHP_FUNCTION(php_api_afficher_erreur)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_erreur(lang2cxx<zval*, erreur>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type action_type
PHP_FUNCTION(php_api_afficher_action_type)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_action_type(lang2cxx<zval*, action_type>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type debug_drapeau
PHP_FUNCTION(php_api_afficher_debug_drapeau)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_debug_drapeau(lang2cxx<zval*, debug_drapeau>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type position
PHP_FUNCTION(php_api_afficher_position)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_position(lang2cxx<zval*, position>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type minerai
PHP_FUNCTION(php_api_afficher_minerai)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_minerai(lang2cxx<zval*, minerai>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type nain
PHP_FUNCTION(php_api_afficher_nain)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_nain(lang2cxx<zval*, nain>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

/// Affiche le contenu d'une valeur de type action_hist
PHP_FUNCTION(php_api_afficher_action_hist)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

    try {
api_afficher_action_hist(lang2cxx<zval*, action_hist>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

static zend_function_entry module_functions_table[] = {
    PHP_FALIAS(chemin, php_api_chemin, NULL)    PHP_FALIAS(deplacer, php_api_deplacer, NULL)    PHP_FALIAS(lacher, php_api_lacher, NULL)    PHP_FALIAS(agripper, php_api_agripper, NULL)    PHP_FALIAS(miner, php_api_miner, NULL)    PHP_FALIAS(tirer, php_api_tirer, NULL)    PHP_FALIAS(poser_corde, php_api_poser_corde, NULL)    PHP_FALIAS(debug_afficher_drapeau, php_api_debug_afficher_drapeau, NULL)    PHP_FALIAS(type_case, php_api_type_case, NULL)    PHP_FALIAS(liste_cordes, php_api_liste_cordes, NULL)    PHP_FALIAS(corde_sur_case, php_api_corde_sur_case, NULL)    PHP_FALIAS(nain_sur_case, php_api_nain_sur_case, NULL)    PHP_FALIAS(info_nain, php_api_info_nain, NULL)    PHP_FALIAS(liste_minerais, php_api_liste_minerais, NULL)    PHP_FALIAS(info_minerai, php_api_info_minerai, NULL)    PHP_FALIAS(cout_de_deplacement, php_api_cout_de_deplacement, NULL)    PHP_FALIAS(position_taverne, php_api_position_taverne, NULL)    PHP_FALIAS(historique, php_api_historique, NULL)    PHP_FALIAS(score, php_api_score, NULL)    PHP_FALIAS(moi, php_api_moi, NULL)    PHP_FALIAS(adversaire, php_api_adversaire, NULL)    PHP_FALIAS(annuler, php_api_annuler, NULL)    PHP_FALIAS(tour_actuel, php_api_tour_actuel, NULL)    PHP_FALIAS(afficher_case_type, php_api_afficher_case_type, NULL)    PHP_FALIAS(afficher_direction, php_api_afficher_direction, NULL)    PHP_FALIAS(afficher_erreur, php_api_afficher_erreur, NULL)    PHP_FALIAS(afficher_action_type, php_api_afficher_action_type, NULL)    PHP_FALIAS(afficher_debug_drapeau, php_api_afficher_debug_drapeau, NULL)    PHP_FALIAS(afficher_position, php_api_afficher_position, NULL)    PHP_FALIAS(afficher_minerai, php_api_afficher_minerai, NULL)    PHP_FALIAS(afficher_nain, php_api_afficher_nain, NULL)    PHP_FALIAS(afficher_action_hist, php_api_afficher_action_hist, NULL)    {NULL, NULL, NULL}
};
static zend_module_entry api_module_entry = {
    STANDARD_MODULE_HEADER,
    "api",
    module_functions_table,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    "1.0",
    STANDARD_MODULE_PROPERTIES
};

static void _init_php()
{
    static int initialized = 0;
    if (initialized)
        return;
    initialized = 1;

    char* argv[] = { "champion", NULL };
    char buffer[1024];
    const char* path;
    zend_file_handle script;

    path = getenv("CHAMPION_PATH");
    if (!path)
        path = ".";

    snprintf(buffer, 1024, "include('%s/%s.php');", path, "prologin");

    php_embed_init(1, argv);
    zend_startup_module(&api_module_entry);
    zend_eval_string(buffer, NULL, "PHP to Stechec interface");
}

/// Fonction appelée au début de la partie.
extern "C" void partie_init()
{
    zval ret;
    zval fname;
    _init_php();

    ZVAL_STRING(&fname, "partie_init");
    if (call_user_function(EG(function_table), NULL, &fname, &ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
}

/// Fonction appelée à chaque tour.
extern "C" void jouer_tour()
{
    zval ret;
    zval fname;
    _init_php();

    ZVAL_STRING(&fname, "jouer_tour");
    if (call_user_function(EG(function_table), NULL, &fname, &ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
}

/// Fonction appelée à la fin de la partie.
extern "C" void partie_fin()
{
    zval ret;
    zval fname;
    _init_php();

    ZVAL_STRING(&fname, "partie_fin");
    if (call_user_function(EG(function_table), NULL, &fname, &ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
}

