<?php
/*
 * Taille de la mine (longueur et largeur).
 */
define('TAILLE_MINE', 31);

/*
 * Nombre de tours à jouer avant la fin de la partie.
 */
define('NB_TOURS', 100);

/*
 * Nombre de points de déplacement par tour par nain (standard).
 */
define('NB_POINTS_DEPLACEMENT', 5);

/*
 * Nombre de points d'action par tour par nain (standard).
 */
define('NB_POINTS_ACTION', 6);

/*
 * Nombre de points de vie d'un nain (standard).
 */
define('VIE_NAIN', 10);

/*
 * Nombre de joueurs.
 */
define('NB_JOUEURS', 2);

/*
 * Nombre de nains (standard) par joueur.
 */
define('NB_NAINS', 6);

/*
 * Dégât infligé par un coup de pioche à un nain (standard).
 */
define('DEGAT_PIOCHE', 3);

/*
 * Valeur cumulée maximale des minerais qu'un nain (standard) peut emporter avec lui.
 */
define('BUTIN_MAX', 25);

/*
 * Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case.
 */
define('COUT_DEPLACEMENT', 1);

/*
 * Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case lorsqu'il est agrippé.
 */
define('COUT_ESCALADER', 2);

/*
 * Nombre de points de déplacement pour qu'un nain (standard) se déplace vers une case occupée par une corde lorsqu'il est agrippé.
 */
define('COUT_ESCALADER_CORDE', 1);

/*
 * Nombre de points d'action pour qu'un nain (standard) mine un bloc.
 */
define('COUT_MINER', 6);

/*
 * Nombre de points d'action pour qu'un nain (standard) tire sur une corde.
 */
define('COUT_TIRER', 1);

/*
 * Nombre de points d'action pour qu'un nain (standard) lâche la paroi.
 */
define('COUT_LACHER', 0);

/*
 * Nombre de points d'action pour qu'un nain (standard) s'agrippe à la paroi.
 */
define('COUT_AGRIPPER', 0);

/*
 * Types de cases
 */
define('LIBRE', 0); // Case libre, qui peut abriter une corde et des nains (standard)
define('GRANITE', 1); // Granite (standard), qui peut cacher du minerai
define('OBSIDIENNE', 2); // Obsidienne
define('ERREUR_CASE', 3); // Erreur

/*
 * Direction
 */
define('HAUT', 0); // Direction : haut
define('BAS', 1); // Direction : bas
define('GAUCHE', 2); // Direction : gauche
define('DROITE', 3); // Direction : droite
define('ERREUR_DIRECTION', 4); // Erreur

/*
 * Erreurs possibles
 */
define('OK', 0); // L'action s'est effectuée avec succès.
define('PA_INSUFFISANTS', 1); // Votre nain (standard) ne possède pas assez de points d'action pour réaliser cette action.
define('PM_INSUFFISANTS', 2); // Votre nain (standard) ne possède pas assez de points de déplacement pour réaliser ce déplacement.
define('HORS_LIMITES', 3); // L'action est en dehors des limites de la mine.
define('DIRECTION_INVALIDE', 4); // La direction spécifiée n'existe pas, ou vous n'êtes pas autorisé à cibler cette direction pour cette action.
define('ID_NAIN_INVALIDE', 5); // Le nain (standard) spécifié n'existe pas.
define('OBSTACLE_MUR', 6); // La position spécifiée est un mur.
define('OBSTACLE_NAIN', 7); // La position spécifiée est un nain (standard) adverse.
define('OBSTACLE_CORDE', 8); // Il y a déjà une corde dans la direction spécifiée.
define('PAS_DE_CIBLE', 9); // Il n'y a pas de nain (standard) ni de granite (standard) sur la position spécifiée.
define('NAIN_MORT', 10); // Le nain (standard) spécifié est mort.
define('PAS_ACCROCHE', 11); // Le nain (standard) n'est pas accroché.
define('DEJA_ACCROCHE', 12); // Le nain (standard) est déjà accroché.
define('PAS_DE_CORDE', 13); // Il n'y a pas de corde dans la direction spécifiée.
define('DRAPEAU_INVALIDE', 14); // Le drapeau spécifié n'existe pas.

/*
 * Types d'actions
 */
define('ACTION_DEPLACER', 0); // Action ``deplacer``
define('ACTION_LACHER', 1); // Action ``lacher``
define('ACTION_MINER', 2); // Action ``miner``
define('ACTION_POSER_CORDE', 3); // Action ``poser_corde``
define('ACTION_TIRER', 4); // Action ``tirer``
define('ACTION_AGRIPPER', 5); // Action ``agripper``

/*
 * Types de drapeaux de débug
 */
define('AUCUN_DRAPEAU', 0); // Aucun drapeau, enlève le drapeau présent
define('DRAPEAU_BLEU', 1); // Drapeau bleu
define('DRAPEAU_VERT', 2); // Drapeau vert
define('DRAPEAU_ROUGE', 3); // Drapeau rouge

?>
