/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_haskell.rb

#include <stdbool.h>
/// Types de cases
typedef enum case_type {
  LIBRE, /* <- Case libre, qui peut abriter une corde et des nains (standard) */
  GRANITE, /* <- Granite (standard), qui peut cacher du minerai */
  OBSIDIENNE, /* <- Obsidienne */
  ERREUR_CASE, /* <- Erreur */
} case_type;


/// Direction
typedef enum direction {
  HAUT, /* <- Direction : haut */
  BAS, /* <- Direction : bas */
  GAUCHE, /* <- Direction : gauche */
  DROITE, /* <- Direction : droite */
  ERREUR_DIRECTION, /* <- Erreur */
} direction;


/// Erreurs possibles
typedef enum erreur {
  OK, /* <- L'action s'est effectuée avec succès. */
  PA_INSUFFISANTS, /* <- Votre nain (standard) ne possède pas assez de points d'action pour réaliser cette action. */
  PM_INSUFFISANTS, /* <- Votre nain (standard) ne possède pas assez de points de déplacement pour réaliser ce déplacement. */
  HORS_LIMITES, /* <- L'action est en dehors des limites de la mine. */
  DIRECTION_INVALIDE, /* <- La direction spécifiée n'existe pas, ou vous n'êtes pas autorisé à cibler cette direction pour cette action. */
  ID_NAIN_INVALIDE, /* <- Le nain (standard) spécifié n'existe pas. */
  OBSTACLE_MUR, /* <- La position spécifiée est un mur. */
  OBSTACLE_NAIN, /* <- La position spécifiée est un nain (standard) adverse. */
  OBSTACLE_CORDE, /* <- Il y a déjà une corde dans la direction spécifiée. */
  PAS_DE_CIBLE, /* <- Il n'y a pas de nain (standard) ni de granite (standard) sur la position spécifiée. */
  NAIN_MORT, /* <- Le nain (standard) spécifié est mort. */
  PAS_ACCROCHE, /* <- Le nain (standard) n'est pas accroché. */
  DEJA_ACCROCHE, /* <- Le nain (standard) est déjà accroché. */
  PAS_DE_CORDE, /* <- Il n'y a pas de corde dans la direction spécifiée. */
  DRAPEAU_INVALIDE, /* <- Le drapeau spécifié n'existe pas. */
} erreur;


/// Types d'actions
typedef enum action_type {
  ACTION_DEPLACER, /* <- Action ``deplacer`` */
  ACTION_LACHER, /* <- Action ``lacher`` */
  ACTION_MINER, /* <- Action ``miner`` */
  ACTION_POSER_CORDE, /* <- Action ``poser_corde`` */
  ACTION_TIRER, /* <- Action ``tirer`` */
  ACTION_AGRIPPER, /* <- Action ``agripper`` */
} action_type;


/// Types de drapeaux de débug
typedef enum debug_drapeau {
  AUCUN_DRAPEAU, /* <- Aucun drapeau, enlève le drapeau présent */
  DRAPEAU_BLEU, /* <- Drapeau bleu */
  DRAPEAU_VERT, /* <- Drapeau vert */
  DRAPEAU_ROUGE, /* <- Drapeau rouge */
} debug_drapeau;


struct position;
struct minerai;
struct nain;
struct action_hist;

typedef struct direction_array {
  direction* datas;
  size_t length;
} direction_array;

typedef struct position_array {
  struct position* datas;
  size_t length;
} position_array;

typedef struct action_hist_array {
  struct action_hist* datas;
  size_t length;
} action_hist_array;

/// Position dans la mine, donnée par deux coordonnées.
typedef struct position {
  int ligne;  /* <- Coordonnée : ligne */
  int colonne;  /* <- Coordonnée : colonne */
} position;


/// Minerai à récolter
typedef struct minerai {
  int resistance;  /* <- Nombre de coups de pioches encore nécessaires avant que le bloc de minerais ne casse */
  int rendement;  /* <- Valeur marchande du bloc de minerai */
} minerai;


/// Nain (standard)
typedef struct nain {
  position pos;  /* <- Position actuelle du nain (standard) */
  int vie;  /* <- Point(s) de vie restant du nain (standard) */
  int pa;  /* <- Point(s) d'action restant du nain (standard) */
  int pm;  /* <- Point(s) de déplacement restant du nain (standard) */
  bool accroche;  /* <- Le nain (standard) est accroché à la paroi ou à une corde */
  int butin;  /* <- Valeur marchande totale que le nain (standard) possède */
} nain;


/// Action de déplacement représentée dans l'historique.
typedef struct action_hist {
  action_type atype;  /* <- Type de l'action */
  int id_nain;  /* <- Numéro du nain (standard) concerné par l'action */
  direction dir;  /* <- Direction visée par le nain (standard) durant le déplacement */
  direction sens;  /* <- Sens de l'action, utilisé uniquement pour préciser si l'on doit tirer une corde vers le bas ou vers le haut. Direction doit cibler la droite ou la gauche. */
} action_hist;


