(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

(*
** Taille de la mine (longueur et largeur).
*)
let taille_mine = 31

(*
** Nombre de tours à jouer avant la fin de la partie.
*)
let nb_tours = 100

(*
** Nombre de points de déplacement par tour par nain (standard).
*)
let nb_points_deplacement = 5

(*
** Nombre de points d'action par tour par nain (standard).
*)
let nb_points_action = 6

(*
** Nombre de points de vie d'un nain (standard).
*)
let vie_nain = 10

(*
** Nombre de joueurs.
*)
let nb_joueurs = 2

(*
** Nombre de nains (standard) par joueur.
*)
let nb_nains = 6

(*
** Dégât infligé par un coup de pioche à un nain (standard).
*)
let degat_pioche = 3

(*
** Valeur cumulée maximale des minerais qu'un nain (standard) peut emporter avec lui.
*)
let butin_max = 25

(*
** Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case.
*)
let cout_deplacement = 1

(*
** Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case lorsqu'il est agrippé.
*)
let cout_escalader = 2

(*
** Nombre de points de déplacement pour qu'un nain (standard) se déplace vers une case occupée par une corde lorsqu'il est agrippé.
*)
let cout_escalader_corde = 1

(*
** Nombre de points d'action pour qu'un nain (standard) mine un bloc.
*)
let cout_miner = 6

(*
** Nombre de points d'action pour qu'un nain (standard) tire sur une corde.
*)
let cout_tirer = 1

(*
** Nombre de points d'action pour qu'un nain (standard) lâche la paroi.
*)
let cout_lacher = 0

(*
** Nombre de points d'action pour qu'un nain (standard) s'agrippe à la paroi.
*)
let cout_agripper = 0

(*
** Types de cases
*)
type case_type =
| Libre (* <- Case libre, qui peut abriter une corde et des nains (standard) *)
| Granite (* <- Granite (standard), qui peut cacher du minerai *)
| Obsidienne (* <- Obsidienne *)
| Erreur_case (* <- Erreur *)


(*
** Direction
*)
type direction =
| Haut (* <- Direction : haut *)
| Bas (* <- Direction : bas *)
| Gauche (* <- Direction : gauche *)
| Droite (* <- Direction : droite *)
| Erreur_direction (* <- Erreur *)


(*
** Erreurs possibles
*)
type erreur =
| Ok (* <- L'action s'est effectuée avec succès. *)
| Pa_insuffisants (* <- Votre nain (standard) ne possède pas assez de points d'action pour réaliser cette action. *)
| Pm_insuffisants (* <- Votre nain (standard) ne possède pas assez de points de déplacement pour réaliser ce déplacement. *)
| Hors_limites (* <- L'action est en dehors des limites de la mine. *)
| Direction_invalide (* <- La direction spécifiée n'existe pas, ou vous n'êtes pas autorisé à cibler cette direction pour cette action. *)
| Id_nain_invalide (* <- Le nain (standard) spécifié n'existe pas. *)
| Obstacle_mur (* <- La position spécifiée est un mur. *)
| Obstacle_nain (* <- La position spécifiée est un nain (standard) adverse. *)
| Obstacle_corde (* <- Il y a déjà une corde dans la direction spécifiée. *)
| Pas_de_cible (* <- Il n'y a pas de nain (standard) ni de granite (standard) sur la position spécifiée. *)
| Nain_mort (* <- Le nain (standard) spécifié est mort. *)
| Pas_accroche (* <- Le nain (standard) n'est pas accroché. *)
| Deja_accroche (* <- Le nain (standard) est déjà accroché. *)
| Pas_de_corde (* <- Il n'y a pas de corde dans la direction spécifiée. *)
| Drapeau_invalide (* <- Le drapeau spécifié n'existe pas. *)


(*
** Types d'actions
*)
type action_type =
| Action_deplacer (* <- Action ``deplacer`` *)
| Action_lacher (* <- Action ``lacher`` *)
| Action_miner (* <- Action ``miner`` *)
| Action_poser_corde (* <- Action ``poser_corde`` *)
| Action_tirer (* <- Action ``tirer`` *)
| Action_agripper (* <- Action ``agripper`` *)


(*
** Types de drapeaux de débug
*)
type debug_drapeau =
| Aucun_drapeau (* <- Aucun drapeau, enlève le drapeau présent *)
| Drapeau_bleu (* <- Drapeau bleu *)
| Drapeau_vert (* <- Drapeau vert *)
| Drapeau_rouge (* <- Drapeau rouge *)


(*
** Position dans la mine, donnée par deux coordonnées.
*)
type position = (int * int)

(*
** Minerai à récolter
*)
type minerai = {
  resistance : int ; (* <- Nombre de coups de pioches encore nécessaires avant que le bloc de minerais ne casse *)
  rendement : int ; (* <- Valeur marchande du bloc de minerai *)
}

(*
** Nain (standard)
*)
type nain = {
  pos : position ; (* <- Position actuelle du nain (standard) *)
  vie : int ; (* <- Point(s) de vie restant du nain (standard) *)
  pa : int ; (* <- Point(s) d'action restant du nain (standard) *)
  pm : int ; (* <- Point(s) de déplacement restant du nain (standard) *)
  accroche : bool ; (* <- Le nain (standard) est accroché à la paroi ou à une corde *)
  butin : int ; (* <- Valeur marchande totale que le nain (standard) possède *)
}

(*
** Action de déplacement représentée dans l'historique.
*)
type action_hist = {
  atype : action_type ; (* <- Type de l'action *)
  id_nain : int ; (* <- Numéro du nain (standard) concerné par l'action *)
  dir : direction ; (* <- Direction visée par le nain (standard) durant le déplacement *)
  sens : direction ; (* <- Sens de l'action, utilisé uniquement pour préciser si l'on doit tirer une corde vers le bas ou vers le haut. Direction doit cibler la droite ou la gauche. *)
}

(*
** Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
*)
external chemin : position -> position -> direction array = "ml_chemin"
(*
** Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
*)
external deplacer : int -> direction -> erreur = "ml_deplacer"
(*
** Le nain (standard) ``id_nain`` lâche la paroi.
*)
external lacher : int -> erreur = "ml_lacher"
(*
** Le nain (standard) ``id_nain`` s'agrippe à la paroi.
*)
external agripper : int -> erreur = "ml_agripper"
(*
** Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
*)
external miner : int -> direction -> erreur = "ml_miner"
(*
** Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
*)
external tirer : int -> direction -> direction -> erreur = "ml_tirer"
(*
** Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
*)
external poser_corde : int -> direction -> erreur = "ml_poser_corde"
(*
** Affiche le drapeau spécifié sur la case indiquée.
*)
external debug_afficher_drapeau : position -> debug_drapeau -> erreur = "ml_debug_afficher_drapeau"
(*
** Renvoie le type d'une case donnée.
*)
external type_case : position -> case_type = "ml_type_case"
(*
** Renvoie la liste de toutes les positions occupées par une corde dans la mine.
*)
external liste_cordes : unit -> position array = "ml_liste_cordes"
(*
** Indique si une corde se trouve sur une case donnée.
*)
external corde_sur_case : position -> bool = "ml_corde_sur_case"
(*
** Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
*)
external nain_sur_case : position -> int = "ml_nain_sur_case"
(*
** Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
*)
external info_nain : int -> int -> nain = "ml_info_nain"
(*
** Renvoie la liste de tous les minerais dans la mine.
*)
external liste_minerais : unit -> position array = "ml_liste_minerais"
(*
** Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
*)
external info_minerai : position -> minerai = "ml_info_minerai"
(*
** Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
*)
external cout_de_deplacement : int -> direction -> int = "ml_cout_de_deplacement"
(*
** Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
*)
external position_taverne : int -> position = "ml_position_taverne"
(*
** Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
*)
external historique : unit -> action_hist array = "ml_historique"
(*
** Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
*)
external score : int -> int = "ml_score"
(*
** Renvoie votre numéro de joueur.
*)
external moi : unit -> int = "ml_moi"
(*
** Renvoie le numéro de joueur de votre adversaire.
*)
external adversaire : unit -> int = "ml_adversaire"
(*
** Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
*)
external annuler : unit -> bool = "ml_annuler"
(*
** Retourne le numéro du tour actuel.
*)
external tour_actuel : unit -> int = "ml_tour_actuel"
(*
** Affiche le contenu d'une valeur de type case_type
*)
external afficher_case_type : case_type -> unit = "ml_afficher_case_type"
(*
** Affiche le contenu d'une valeur de type direction
*)
external afficher_direction : direction -> unit = "ml_afficher_direction"
(*
** Affiche le contenu d'une valeur de type erreur
*)
external afficher_erreur : erreur -> unit = "ml_afficher_erreur"
(*
** Affiche le contenu d'une valeur de type action_type
*)
external afficher_action_type : action_type -> unit = "ml_afficher_action_type"
(*
** Affiche le contenu d'une valeur de type debug_drapeau
*)
external afficher_debug_drapeau : debug_drapeau -> unit = "ml_afficher_debug_drapeau"
(*
** Affiche le contenu d'une valeur de type position
*)
external afficher_position : position -> unit = "ml_afficher_position"
(*
** Affiche le contenu d'une valeur de type minerai
*)
external afficher_minerai : minerai -> unit = "ml_afficher_minerai"
(*
** Affiche le contenu d'une valeur de type nain
*)
external afficher_nain : nain -> unit = "ml_afficher_nain"
(*
** Affiche le contenu d'une valeur de type action_hist
*)
external afficher_action_hist : action_hist -> unit = "ml_afficher_action_hist"
