/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include "consts.hh"
#include <vector>
#include <iostream>
#include <array>
#include <deque>
#include <queue>
#include <cmath>
#include <chrono>
#define ACTION_RUN ACTION_POSER_CORDE

using namespace std;

const int INF = 1000*1000*1000;
array<direction, 4> ALL_DIRS = {HAUT, BAS, DROITE, GAUCHE};

/*
	Variables globales d'etat de la partie
*/

int myId, enemyId, tourActu;
position tavernes[2];


/*
	Structures pour representer l'etat de jeu et les calculs
*/

// struct Nain : nain {
// 	// position pos;
//     // int vie;
//     // int pa;
//     // int pm;
//     // bool accroche;
//     // int butin;
// 	int iPlayer;
// };

// struct Action : action_hist {
//     // action_type atype;
//     // int id_nain;
//     // direction dir;
//     // direction sens;
// };

using Nain = nain;
using Action = action_hist;
using ActList = vector<Action>;

struct ActListVal { // Passer = ActList empty
	ActList acts;
	double value;
};

bool operator < (const ActListVal& a, const ActListVal& b) {
	return a.value < b.value;
}

struct PathSit { // Represente le cout pour aller jusqu'a une position ainsi que comment y aller
	position pos, previousPos;
	action_type previousMove;
	direction previousDir;

	int turns, hasMined, pmLeft;
};

bool operator < (const PathSit& a, const PathSit& b) {
	if (a.turns != b.turns) {
		return a.turns > b.turns;
	} else if (a.hasMined != b.hasMined) {
		return a.hasMined > b.hasMined;
	}
	return a.pmLeft < b.pmLeft;
}

struct PotentialSit {
	position pos;
	double gain;
};

bool operator < (const PotentialSit& a, const PotentialSit& b) {
	return a.gain > b.gain;
}

using MapDists = array<array<PathSit, TAILLE_MINE>, TAILLE_MINE>;
using PotentialMap = array<array<double, TAILLE_MINE>, TAILLE_MINE>;

/*
	Utilitaires
*/

inline bool isPosValid(const position& pos) {
	return pos.ligne >= 0 && pos.colonne >= 0 && pos.ligne < TAILLE_MINE && pos.colonne < TAILLE_MINE;
}

inline position getNewPos(const position& pos, direction dir, int nbCells = 1) {
	if (dir == HAUT) {
		return {pos.ligne - nbCells, pos.colonne};
	} else if (dir == BAS) {
		return {pos.ligne + nbCells, pos.colonne};
	} else if (dir == GAUCHE) {
		return {pos.ligne, pos.colonne - nbCells};
	} else if (dir == DROITE) {
		return {pos.ligne, pos.colonne + nbCells};
	}
	return {-1000, -1000};
}

inline direction invDir(direction dir) {
	if (dir == HAUT) { return BAS; }
	if (dir == BAS) { return HAUT; }
	if (dir == GAUCHE) { return DROITE; }
	return GAUCHE;
}

inline direction dirBtw(position p1, position p2) {
	if (p1.ligne < p2.ligne) { return BAS; }
	if (p1.ligne > p2.ligne) { return HAUT; }
	if (p1.colonne > p2.colonne) { return GAUCHE; }
	return DROITE;
}

inline bool isDirHorizontal(direction dir) {
	return dir == DROITE || dir == GAUCHE;
}

// bool operator == (const position& a, const position& b) {
// 	return a.ligne == b.ligne && a.colonne == b.colonne;
// }

position operator - (const position& a, const position& b) {
	return {a.ligne - b.ligne, a.colonne - b.colonne};
}

int normAxis(const position p) {
	return abs(p.ligne) + abs(p.colonne);
}

inline int fallDammages(int fall) {
	if (fall < 4) {
		return 0;
	}
	return 1 << (fall-4);
}

inline int notMe(int iPlayer) {
	return iPlayer ^ 1;
}

/*
	Represente un etat de la map a un instant donne
*/
struct Game {
	case_type grid[TAILLE_MINE][TAILLE_MINE];
	int gainMine[TAILLE_MINE][TAILLE_MINE];
	int coupsMine[TAILLE_MINE][TAILLE_MINE];
	int playerOn[TAILLE_MINE][TAILLE_MINE];
	int hauteurAt[TAILLE_MINE][TAILLE_MINE];
	bool isCord[TAILLE_MINE][TAILLE_MINE];

	vector<Nain> nains[2];
	vector<position> cordes;
	int goldBank[2];

	PotentialMap potentials;

	void getFromAPI();
	void prepare();
	void quickComputeDists(int forNain);

	bool checkDeath(int iPlayer, int iNain);
	void doAction(const Action& action, const Game& state);
	void doActionList(const ActList& actList, const Game& state);

	bool isEmpty(position pos, int iPlayer);
	void resetPam();
};

struct AllDistsMap {
	vector<MapDists> distsNains[2];

	void computeDistsComplex(Game& state);
};

#include "debug.hh"

void Game::getFromAPI() { // Lit l'entree depuis l'API pour avoir l'etat courrant du jeu
	for (int lig = 0; lig < TAILLE_MINE; lig++) {
		for (int col = 0; col < TAILLE_MINE; col++) {
			this->grid[lig][col] = type_case({lig, col});
			if (this->grid[lig][col] == GRANITE) {
				minerai m = info_minerai({lig, col});
				this->gainMine[lig][col] = m.rendement;
				this->coupsMine[lig][col] = m.resistance;

				if (m.rendement == -1) {
					this->gainMine[lig][col] = 0;
					this->coupsMine[lig][col] = 1;
				}
			} else if (this->grid[lig][col] == LIBRE) {
				this->gainMine[lig][col] = 0;
				this->coupsMine[lig][col] = 0;
			} else if (this->grid[lig][col] == OBSIDIENNE) {
				this->gainMine[lig][col] = 0;
				this->coupsMine[lig][col] = 1000;
			}
		}
	}
	this->cordes = liste_cordes();
	for (int iPlayer = 0; iPlayer < NB_JOUEURS; iPlayer++) {
		this->nains[iPlayer].resize(NB_NAINS);
		for (int iNain = 0; iNain < NB_NAINS; iNain++) {
			this->nains[iPlayer][iNain] = info_nain(iPlayer+1, iNain);
		}
		goldBank[iPlayer] = score(iPlayer+1);
	}
}

/*
	Fonctions utilitaires pour acceder a / modifier des infos
*/

bool Game::isEmpty(position pos, int iPlayer) { // TODO: for ennemy ?
	if (!isPosValid(pos)) {
		return false;
	}
	return this->coupsMine[pos.ligne][pos.colonne] <= 0
		&& (iPlayer < 0 || this->playerOn[pos.ligne][pos.colonne] != notMe(iPlayer));
}

void Game::resetPam() {
	for (int iPlayer = 0; iPlayer < NB_JOUEURS; iPlayer++) {
		for (int iNain = 0; iNain < NB_NAINS; iNain++) {
			this->nains[iPlayer][iNain].pa = NB_POINTS_ACTION;
			this->nains[iPlayer][iNain].pm = NB_POINTS_DEPLACEMENT;
		}
	}
}

/*
	Stocke les joueurs "possedant" une case, ainsi que les hauteurs et les cordes
*/
void Game::prepare() { // TODO: for both players
	for (int lig = TAILLE_MINE-1; lig >= 0; lig--) {
		for (int col = 0; col < TAILLE_MINE; col++) {
			if (!this->isEmpty({lig, col}, myId) || !this->isEmpty({lig+1, col}, myId)) {
				this->hauteurAt[lig][col] = 0;
			} else {
				this->hauteurAt[lig][col] = this->hauteurAt[lig+1][col] + 1;
			}
			this->playerOn[lig][col] = -1;
		}
	}
	for (int iPlayer = 0; iPlayer < NB_JOUEURS; iPlayer++) {
		for (int iNain = 0; iNain < NB_NAINS; iNain++) {
			position pos = this->nains[iPlayer][iNain].pos;
			this->playerOn[pos.ligne][pos.colonne] = iPlayer;
		}
	}
	for (position pos : this->cordes) {
		while (this->isEmpty(pos, -1)) {
			this->isCord[pos.ligne][pos.colonne] = true;
			pos.ligne -= 1;
		}
	}
}

/*
	Fonctions auxiliaires pour le deijkstra
*/
PathSit normSit(PathSit sit, int costPm, int mine = 0) {
	sit.pmLeft -= costPm;
	sit.hasMined += mine;

	if (sit.pmLeft < 0 || sit.hasMined > 1) {
		if (sit.hasMined > 1) {
			sit.turns += sit.hasMined-1;
			sit.hasMined = 1;
		} else {
			sit.hasMined = 0;
		}
		if (sit.pmLeft < 0) {
			sit.pmLeft = NB_POINTS_DEPLACEMENT - costPm;
		} else {
			sit.pmLeft = NB_POINTS_DEPLACEMENT;
		}
		sit.turns += 1;
	}
	return sit;
}

inline bool isSitBetter(const PathSit& a, const PathSit& b) {
	return b < a;
}

inline void Push(priority_queue<PathSit>& nextPos, MapDists& mapDists, PathSit sit) {
	if (isSitBetter(sit, mapDists[sit.pos.ligne][sit.pos.colonne])) {
		mapDists[sit.pos.ligne][sit.pos.colonne] = sit;
		nextPos.push(sit);
	}
}

/*
	Calcule les distances pour un nain sur le reste de la map. Version la plus complete
	et la plus lente, utilisee pour les mouvements, qui necessitent d'etre precis
*/
void computeNainDist(Game& state, MapDists& mapDists, Nain& nain, int iPlayer) {
	// TODO: mouvement accroche != non accroche ; prendre en compte gravitee
	PathSit InfPath = {
		position{-1, -1}, position{-1, -1},
		ACTION_DEPLACER, ERREUR_DIRECTION,
		INF, INF, INF
	};
	for (int lig = 0; lig < TAILLE_MINE; lig++) {
		for (int col = 0; col < TAILLE_MINE; col++) {
			mapDists[lig][col] = InfPath;
		}
	}

	priority_queue<PathSit> nextPosQ;
	nextPosQ.push({
		nain.pos, nain.pos,
		ACTION_DEPLACER, ERREUR_DIRECTION,
		0, (int)(nain.pa < NB_POINTS_ACTION), nain.pm
	});
	mapDists[nain.pos.ligne][nain.pos.colonne] = nextPosQ.top();

	while (!nextPosQ.empty()) {
		PathSit sit = nextPosQ.top();
		nextPosQ.pop();

		if (isSitBetter(mapDists[sit.pos.ligne][sit.pos.colonne], sit)) {
			continue ;
		}

		// Mouvement accroche
		for (auto dir : ALL_DIRS) {
			auto next = getNewPos(sit.pos, dir);
			if (state.isEmpty(next, iPlayer)) {
				int coutAction = COUT_ESCALADER;
				if (state.isCord[next.ligne][next.colonne]) {
					coutAction = COUT_ESCALADER_CORDE;
				}
				Push(nextPosQ, mapDists, normSit({
					next, sit.pos,
					ACTION_DEPLACER, dir,
					sit.turns, sit.hasMined, sit.pmLeft
				}, coutAction));
			} else if (isPosValid(next) && state.coupsMine[next.ligne][next.colonne] != 0) {
				Push(nextPosQ, mapDists, normSit({
					next, sit.pos,
					ACTION_MINER, dir,
					sit.turns, sit.hasMined, sit.pmLeft
				}, COUT_ESCALADER, state.coupsMine[next.ligne][next.colonne]));
			}
		}

		// Mouvement au sol
		for (auto dir : ALL_DIRS) {
			if (!isDirHorizontal(dir)) {continue; }
			auto next = getNewPos(sit.pos, dir);
			if (state.isEmpty(next, iPlayer)
				&& state.hauteurAt[next.ligne][next.colonne] <= C_MAX_FALL
				&& state.hauteurAt[sit.pos.ligne][sit.pos.colonne] == 0) {

				int hFall = state.hauteurAt[next.ligne][next.colonne];
				Push(nextPosQ, mapDists, normSit({
					position{next.ligne, next.colonne + hFall}, sit.pos,
					ACTION_RUN, dir,
					sit.turns, sit.hasMined, sit.pmLeft
				}, COUT_DE_DEPLACEMENT));
			}
		}

		// TODO: mouvement au sol, lacher, creuser

		// TODO: utiliser les cordes
	}

	// for (int lig = 0; lig < 9; lig++) {
	// 	for (int col = 0; col < 9; col++) {
	// 		int dd = mapDists[lig][col].turns;
	// 		if (mapDists[lig][col].pmLeft < NB_POINTS_DEPLACEMENT) {
	// 			dd += 1;
	// 		}
	// 		cerr << dd << " ";
	// 		cerr << "[" << mapDists[lig][col].turns << " " << mapDists[lig][col].pmLeft << "] ";

	// 	}
	// 	cerr << "\n";
	// }
	// exit(0);
}

inline void QuickPush(priority_queue<PotentialSit>& nextPos, PotentialMap& potentials, PotentialSit sit, int steps = 0) {
	sit.gain *= pow(C_EXP_DIST, steps)
	if (potentials[sit.pos.ligne][sit.pos.colonne] < sit.gain) {
		potentials[sit.pos.ligne][sit.pos.colonne] = sit.gain;
		nextPos.push(sit);
	}
}

/*
	Donner une "evaluation" du "cout" pour aller vers une case, pour les fonctions d'evaluation.
	En effet, le deijkstra ci dessus est trop lent pour etre effectue beaucoup de fois par tour.
	Celui-ci est plus rapide, mais moins precis et ne permet pas de calculer des chemins
	facilement.
*/

std::chrono::duration<double> elapsed_compd_quick;
void Game::quickComputeDists() {
	auto chrono_debut = chrono::system_clock::now();

	PotentialMap& potentials = this->potentials;
	for (int lig = 0; lig < TAILLE_MINE; lig++) {
		fill(potentials[lig].begin(), potentials[lig].end(), 0);
	}

	priority_queue<PotentialSit> nextPosQ;
	for (int lig = 0; lig < TAILLE_MINE; lig++) {
		for (int col = 0; col < TAILLE_MINE; col++) {
			if (gainPossible[lig][col] > 0) {
				QuickPush(nextPosQ, potentials, {position{lig, col}, gainPossible[lig][col]}, coupsMine[lig][col]);
			}
		}
	}
	QuickPush(nextPosQ, potentials, {nain.pos, 0});

	while (!nextPosQ.empty()) {
		QuickSit sit = nextPosQ.top();
		nextPosQ.pop();

		if (potentials[sit.pos.ligne][sit.pos.colonne] > sit.gain) {
			continue;
		}

		for (auto dir : ALL_DIRS) {
			auto next = getNewPos(sit.pos, dir);
			if (isPosValid(next)) {
				QuickPush(nextPosQ, potentials, {next, sit.gain},
					coupsMine[next.lig][next.col]
					+ (this->isCord[next.ligne][next.colonne] ? COUT_ESCALADER_CORDE :
						(this->hauteurAt[next.ligne][next.colonne] == 0 : COUT_DE_DEPLACEMENT ? COUT_ESCALADER)
				);
			}
		}
	}

	for (int lig = 0; lig < 9; lig++) {
		for (int col = 0; col < 9; col++) {
			cerr << setprecision(4) << potentials[lig][col] << " ";
		}
		cerr << "\n";
	}

	auto chrono_fin = chrono::system_clock::now();
	elapsed_compd_quick += chrono_fin - chrono_debut;
}

std::chrono::duration<double> elapsed_compd;

void AllDistsMap::computeDistsComplex(Game& state) {
	auto chrono_debut = chrono::system_clock::now();

	for (int iPlayer = 0; iPlayer < NB_JOUEURS; iPlayer++) {
		this->distsNains[iPlayer].resize(NB_NAINS);
		for (int iNain = 0; iNain < NB_NAINS; iNain++) {
			//cerr << "Compute for " << iPlayer << " " << iNain << "\n";
			computeNainDist(
				state,
				this->distsNains[iPlayer][iNain],
				state.nains[iPlayer][iNain],
				iPlayer
			);
		}
	}
	auto chrono_fin = chrono::system_clock::now();
	elapsed_compd += chrono_fin - chrono_debut;
}

bool Game::checkDeath(int iPlayer, int iNain) {
	auto& nain = this->nains[iPlayer][iNain];
	if (nain.vie <= 0) {
		nain.vie = VIE_NAIN;
		nain.pa = 0;
		nain.pm = 0;
		nain.pos = tavernes[iPlayer];
		return true;
	}
	return false;
}

void Game::doAction(const Action& act, const Game& state) { // TODO : other player ?
	int iPlayer = myId;
	auto& nain = this->nains[iPlayer][act.id_nain];

	if (act.atype == ACTION_DEPLACER) { // TODO : sur corde coute moins cher
		nain.pos = getNewPos(nain.pos, act.dir);
		if (nain.accroche) {
			if (state.isCord[nain.pos.ligne][nain.pos.colonne]) {
				nain.pm -=  COUT_ESCALADER_CORDE;
			} else {
				nain.pm -= COUT_ESCALADER;
			}
		} else {
			nain.pm -= COUT_DE_DEPLACEMENT;
		}
	}
	
	else if (act.atype == ACTION_LACHER) {
		nain.pa -= COUT_LACHER;
		nain.accroche = false;
	} else if (act.atype == ACTION_AGRIPPER) {
		nain.pa -= COUT_AGRIPPER;
		nain.accroche = true;
	}
	
	else if (act.atype == ACTION_MINER) {
		nain.pa -= COUT_MINER;
		position minePos = getNewPos(nain.pos, act.dir);
		
		if (this->playerOn[minePos.ligne][minePos.colonne] == -1) { // On creuse un bloc
			this->coupsMine[minePos.ligne][minePos.colonne] -= 1;

			if (this->coupsMine[minePos.ligne][minePos.colonne] == 0) {
				nain.butin = min(
					nain.butin + this->gainMine[minePos.ligne][minePos.colonne],
					BUTIN_MAX
				);
				this->gainMine[minePos.ligne][minePos.colonne] = 0;
				this->grid[minePos.ligne][minePos.colonne] = LIBRE;
			}

		} else { // On tape des nains !
			for (int iP = 0; iP < NB_JOUEURS; iP++) {
				for (int iNain = 0; iNain < NB_NAINS; iNain++) {
					if (this->nains[iP][iNain].pos == minePos) {
						this->nains[iP][iNain].vie -= DEGAT_PIOCHE;
						int goldNain = this->nains[iP][iNain].butin;
						if (this->checkDeath(iP, iNain)) {
							nain.butin = min(nain.butin + goldNain,	BUTIN_MAX);
						}
					}
				}
			}
		}
	} 
	
	else if (act.atype == ACTION_POSER_CORDE) {
		// TODO
	} 
	
	else if (act.atype == ACTION_TIRER) {
		// TODO
	}
	

	// Gravitee, regarder taverne [soi et ennemi], et regarder si mort
	if (!nain.accroche) {
		int fall = this->hauteurAt[nain.pos.ligne][nain.pos.colonne];
		if (fall) {
			nain.pos = getNewPos(nain.pos, BAS, fall);
			nain.vie -= fallDammages(fall);
		}
	}
	if (nain.pos == tavernes[notMe(iPlayer)]) {
		nain.vie = 0;
		goldBank[notMe(iPlayer)] += max(0, nain.butin);
	}
	if (nain.pos == tavernes[iPlayer]) {
		goldBank[iPlayer] += nain.butin;
	}

	this->checkDeath(iPlayer, act.id_nain);

	if (nain.pos == tavernes[iPlayer]) {
		nain.vie = VIE_NAIN;
	}

	if (nain.pm < 0) {cerr << "ERREUR pm < 0\n";}
	if (nain.pa < 0) {cerr << "ERREUR pa < 0\n";}
}

void Game::doActionList(const ActList& actList, const Game& state) {
	for (const Action& act : actList) {
		this->doAction(act, state);
	}
}

/*
	Sous-fonctions d'evaluation
*/
double evalDist(const LiteMapDists& mapDists, position pos, position startAt) {
	return mapDists[pos.ligne][pos.colonne]
		+ C_DIST_FLY * normAxis(pos - startAt);
	// return mapDists[pos.ligne][pos.colonne].turns * C_DIST_TURNS_TO_PM
	// 		+ (NB_POINTS_DEPLACEMENT- mapDists[pos.ligne][pos.colonne].pmLeft)
	// 		+ mapDists[pos.ligne][pos.colonne].hasMined * C_DIST_PA_TO_PM
	// 		+ C_DIST_FLY * normAxis(pos - startAt);
}

pair<double, position> evalDistSideBlock(const LiteMapDists& mapDists, position pos, position startAt) {
	double distMin = INF;
	position bestBlock;
	for (auto dir : ALL_DIRS) {
		position nextPos = getNewPos(pos, dir);
		if (isPosValid(nextPos) && mapDists[nextPos.ligne][nextPos.colonne] < INF) {
			double value = evalDist(mapDists, nextPos, startAt);
			if (value < distMin) {
				distMin = value;
				bestBlock = nextPos;
			}
		}
	}
	return {distMin, bestBlock};
}

double evalDistMineBlockValue(const Game& state, const LiteMapDists& mapDists, position pos, const Nain& nain) {
	int lig = pos.ligne, col = pos.colonne;
	if (state.grid[lig][col] != GRANITE || state.gainMine[lig][col] <= 0) {
		return 0;
	}
	double dist = evalDistSideBlock(mapDists, pos, nain.pos).first;
	if (dist > INF/2) {
		return 0;
	}
	dist += (state.coupsMine[lig][col]) * C_DIST_MINE_TO_PM;
	return min(state.gainMine[lig][col], BUTIN_MAX - nain.butin)
		 / dist; //log(1 + dist);
}

/*
	L'une des fonctions majeures. Evalue un etat de jeu pour lui attribuer un score
*/
double evalState(const Game& state, int asPlayer, int forNain) {
	int asEnnemy = notMe(asPlayer);
	double value = 0;

	// Score total
	value += C_BANK * state.goldBank[asPlayer];
	value -= C_BANK_ADV * state.goldBank[asEnnemy];

	// Score des nains
	for (int iNain = 0; iNain < NB_NAINS; iNain++) {

		auto& nain = state.nains[asPlayer][iNain];
		auto& mapDists = state.distsNains[asPlayer][iNain];

		// Score de butin
		value += C_BUTIN * nain.butin;

		if (iNain != forNain) {
			continue; // On se fichera maintenant des autres nains de l'equipe
		}

		// Score de distance au meilleur block
		if (nain.butin < LIMIT_GO_BACK) {
			double bestBlock = 0;
			for (int lig = 0; lig < TAILLE_MINE; lig++) {
				for (int col = 0; col < TAILLE_MINE; col++) {
					bestBlock = max(bestBlock,
						evalDistMineBlockValue(state, mapDists, {lig, col}, nain)
					);
				}
			}
			value += bestBlock * C_NEAR_BLOCK;
			//cerr << nain.pos.ligne << " " << nain.pos.colonne << " " << bestBlock << "\n";
		}
		// Score de distance a la taverne
		else {
			value += GAIN_BRUT_GO_BACK +
				GAIN_BRUT_GO_BACK / log(1+evalDist(mapDists, tavernes[asPlayer], nain.pos));
		}
	}
	return value;
}

ActList getActionsListMoveTo(Game& state, MapDists mapDists, int asPlayer, int iNain, position pos) {
	ActList actions;
	direction dirMinerFin = ERREUR_DIRECTION;

	while (pos != state.nains[asPlayer][iNain].pos) {
		PathSit& sit = mapDists[pos.ligne][pos.colonne];
		if (sit.turns > 0) {
			actions.resize(0);
		}
		if (sit.turns <= 0) {
			auto move = sit.previousMove;
			if (sit.previousMove == ACTION_RUN) {
				move = ACTION_DEPLACER;
				actions.push_back({ACTION_AGRIPPER, iNain, HAUT, HAUT});
			}

			Action act = {
				move, iNain,
				sit.previousDir, sit.previousDir,
			};
			actions.push_back(act);

			if (sit.previousMove == ACTION_RUN) {
				actions.push_back({ACTION_LACHER, iNain, HAUT, HAUT});
			} else if (sit.previousMove == ACTION_MINER) {
				dirMinerFin = ERREUR_DIRECTION;
			}
		} else if (sit.previousMove == ACTION_MINER) {
			dirMinerFin = sit.previousDir;
		} else {
			dirMinerFin = ERREUR_DIRECTION;
		}
		pos = sit.previousPos;
	}
	reverse(actions.begin(), actions.end());
	if (dirMinerFin != ERREUR_DIRECTION) {
		actions.push_back({ACTION_MINER, iNain, dirMinerFin, dirMinerFin});
	}
	return actions;
}

/*
	Fonction importante. Retourne les differentes suites d'actions potentiellement
	interessantes que l'on peut faire sur la map
*/
vector<ActList> getActionsOk(Game& state, MapDists& mapDists, int asPlayer, int iNain) {
	vector<ActList> actions;

	auto& nain = state.nains[asPlayer][iNain];
	auto& quickMapDists = state.distsNains[asPlayer][iNain];

	// Retour a la taverne
	actions.push_back(getActionsListMoveTo(
		state, mapDists, asPlayer, iNain, tavernes[asPlayer]
	));

	// Si trop loin de la taverne pour revenir avant la fin :
	auto cellVals = mapDists[tavernes[asPlayer].ligne][tavernes[asPlayer].colonne];
	int turnsGoBack = cellVals.turns + 1;
	if (cellVals.pmLeft < NB_POINTS_DEPLACEMENT || cellVals.hasMined) {
		turnsGoBack += 1;
	}
	if (turnsGoBack + tourActu >= NB_TOURS) { // TODO: si butin > 0
		return actions; // On retourne forcement a la taverne
	}

	// Aller vers un block / creuser un bloc
	double bestBlock = 0.0000001;
	int bestLig = -1, bestCol = -1;
	position bestSide;

	double bestDig = 0.0000001;
	int bestLigDig = -1, bestColDig = -1;
	position bestSideDig;

	for (int lig = 0; lig < TAILLE_MINE; lig++) {
		for (int col = 0; col < TAILLE_MINE; col++) {
			double gainPossible = evalDistMineBlockValue(state, quickMapDists, {lig, col}, nain);
			if (gainPossible < 1e-6) {
				continue;
			}
			position side_dest = evalDistSideBlock(quickMapDists, {lig, col}, nain.pos).second;

			if (gainPossible > bestBlock) {
				bestBlock = gainPossible;
				bestLig = lig, bestCol = col;
			}
			if (mapDists[side_dest.ligne][side_dest.colonne].turns == 0 && mapDists[side_dest.ligne][side_dest.colonne].hasMined == 0) {
				if (gainPossible > bestDig) {
					bestDig = gainPossible;
					bestLigDig = lig, bestColDig = col;
				}
			}
		}
	}
	if (bestLig != -1) {
		position side_dest = evalDistSideBlock(quickMapDists, {bestLig, bestCol}, nain.pos).second;
		actions.push_back(getActionsListMoveTo(state, mapDists, asPlayer, iNain, side_dest));
	}
	if (bestLigDig != -1 && nain.pa >= COUT_MINER) {
		position side_dest = evalDistSideBlock(quickMapDists, {bestLigDig, bestColDig}, nain.pos).second;
		auto listAct = getActionsListMoveTo(state, mapDists, asPlayer, iNain, side_dest);
		listAct.push_back({ACTION_MINER, iNain,
			dirBtw(nain.pos, {bestLigDig, bestColDig}), HAUT
		});
		actions.push_back(listAct);
	}

	// Creuser un bloc

	actions.push_back(ActList()); // Passer le tour si plus rien a faire
	return actions;
}

/*
	Effectue une suite d'actions et renvoie la valeur de l'etat en utilisant evalState
*/
inline double evalActList(Game state, ActList actions, int asPlayer, int forNain) {
	// cerr << "Eval list : " << "\n";
	// for (auto act : actions) {
	// 	cerr << ss(act.atype) << " dir " << ss(act.dir) << " + ";
	// }
	state.doActionList(actions, state);

	state.resetPam();
	state.prepare();

	return evalState(state, asPlayer, forNain);
}

/*
	Pour communiquer avec l'API
*/
void doActionWithAPI(const Action& act) {
	cerr << "Action " << ss(act.atype) << " nain " << act.id_nain << " dir " << ss(act.dir) << "\n";
	if (act.atype == ACTION_DEPLACER) {
		deplacer(act.id_nain, act.dir);
	} else if (act.atype == ACTION_LACHER) {
		lacher(act.id_nain);
	} else if (act.atype == ACTION_MINER) {
		miner(act.id_nain, act.dir);
	} else if (act.atype == ACTION_POSER_CORDE) {
		poser_corde(act.id_nain, act.dir);
	} else if (act.atype == ACTION_TIRER) {
		tirer(act.id_nain, act.dir, act.sens);
	} else if (act.atype == ACTION_AGRIPPER) {
		agripper(act.id_nain);
	}
}

void doActionListWithAPI(const ActList& actList) {
	for (const Action& act : actList) {
		doActionWithAPI(act);
	}
}

/*
	Fonctions principales pour un tour de jeu
*/

void playTurn(Game& state) {
	AllDistsMap distsMap;
	
	for (int iNain = 0; iNain < NB_NAINS; iNain++) { // TODO: shuffle ?
		cerr << "Jouer nain " << iNain << " pos " << state.nains[myId][iNain].pos.ligne 
			<< " " << state.nains[myId][iNain].pos.colonne << " butin " << state.nains[myId][iNain].butin << "\n";

		// if (iNain > 0) {continue; } // TODO: remove

		while (true) {
			state.prepare();
			state.quickComputeDists();
			distsMap.computeDistsComplex(state);

			vector<ActList> actionsOK = getActionsOk(state, distsMap.distsNains[myId][iNain], myId, iNain);
			vector<ActListVal> actionValue;

			actionValue.resize(actionsOK.size());
			for (int iAct = 0; iAct < (int)actionsOK.size(); iAct++) {
				cerr << "\n---- Eval " << iAct << " size " << actionsOK[iAct].size() << "\n";
				actionValue[iAct].acts = actionsOK[iAct];
				actionValue[iAct].value = evalActList(state, actionsOK[iAct], myId, iNain);
				cerr << "Value : " << actionValue[iAct].value << "\n";
			}
			sort(actionValue.rbegin(), actionValue.rend());

			ActList choosenOne = actionValue[0].acts;
			if (choosenOne.empty()) {
				cerr << "PASS TURN\n";
				break;
			}
			doActionListWithAPI(choosenOne);
			state.doActionList(choosenOne, state);
		}
	}
}

/// Fonction appelée au début de la partie.
void partie_init() {
	myId = moi()-1;
	enemyId = adversaire()-1;
	tavernes[0] = position_taverne(1);
	tavernes[1] = position_taverne(2);
	//cerr << "IDS: " << myId << " " << enemyId << "\n";
}

/// Fonction appelée à chaque tour.
void jouer_tour() {
	auto chrono_debut = chrono::system_clock::now();
	elapsed_compd = chrono_debut - chrono_debut;
	elapsed_compd_quick = chrono_debut - chrono_debut;

	tourActu = tour_actuel();
	if (tourActu > 0) { // TODO: remove
		//return;
	}
	cerr << "\n\n\n======== Play turn " << tour_actuel() << "\n";

	for (int iNain = 0; iNain < NB_NAINS; iNain++) {
		if (!info_nain(myId+1, iNain).accroche) {
			agripper(iNain); // Nos nains sont tres peureux, ils s'accrochent toujours
		}
	}

	Game curState;
	curState.getFromAPI();
	playTurn(curState);

	auto chrono_fin = chrono::system_clock::now();
	std::chrono::duration<double> elapsed_seconds = chrono_fin-chrono_debut;
	cerr << "Elapsed time : " << elapsed_seconds.count() << "\n";
	cerr << "Passe a faire des Deijkstras : " << elapsed_compd.count() << "\n";
	cerr << "Passe a faire des Deijkstras rapides : " << elapsed_compd_quick.count() << "\n";


	if (tourActu == 0) {
		poser_corde(0, HAUT);
	}
}

/// Fonction appelée à la fin de la partie.
void partie_fin() {
	// fonction a completer
}